/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.config;

import io.ebean.config.AutoConfigure;
import io.ebean.config.ServerConfig;
import io.ebean.datasource.DataSourceConfig;
import io.ebean.test.config.RunOnceMarker;
import io.ebean.test.config.platform.PlatformAutoConfig;
import io.ebean.test.config.provider.ProviderAutoConfig;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoConfigureForTesting
implements AutoConfigure {
    private static final Logger log = LoggerFactory.getLogger(AutoConfigureForTesting.class);
    private final String environmentDb = System.getProperty("db");

    public void preConfigure(ServerConfig serverConfig) {
        Properties properties = serverConfig.getProperties();
        if (this.isExtraServer(serverConfig, properties)) {
            this.setupExtraDataSourceIfNecessary(serverConfig);
            return;
        }
        String testPlatform = properties.getProperty("ebean.test.platform");
        log.debug("automatic testing config - with ebean.test.platform:{} environment db:{} name:{}", new Object[]{testPlatform, this.environmentDb, serverConfig.getName()});
        if (RunOnceMarker.isRun()) {
            this.setupPlatform(this.environmentDb, serverConfig);
        }
    }

    public void postConfigure(ServerConfig serverConfig) {
        this.setupProviders(serverConfig);
    }

    private boolean isExtraServer(ServerConfig serverConfig, Properties properties) {
        String extraDb = properties.getProperty("ebean.test.extraDb.dbName", properties.getProperty("ebean.test.extraDb"));
        if (extraDb != null && extraDb.equals(serverConfig.getName())) {
            serverConfig.setDefaultServer(false);
            return true;
        }
        return false;
    }

    private void setupExtraDataSourceIfNecessary(ServerConfig serverConfig) {
        DataSourceConfig dataSourceConfig = serverConfig.getDataSourceConfig();
        if (dataSourceConfig == null || dataSourceConfig.getUsername() == null) {
            new PlatformAutoConfig(this.environmentDb, serverConfig).configExtraDataSource();
        }
    }

    private void setupProviders(ServerConfig serverConfig) {
        new ProviderAutoConfig(serverConfig).run();
    }

    private void setupPlatform(String db, ServerConfig serverConfig) {
        new PlatformAutoConfig(db, serverConfig).run();
    }
}

