/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.ebean.test.IOUtils;
import io.ebean.test.JsonAssertContains;
import java.io.IOException;
import java.util.List;

public class Json {
    private static final ObjectMapper MAPPER = Json.initMapper();

    public static Resource resource(String resourcePath) {
        return new Resource(resourcePath);
    }

    public static void assertContains(String actualJson, String expectedJson) {
        Json.assertContains(Json.readNode(actualJson), Json.readNode(expectedJson));
    }

    public static void assertContains(JsonNode actualJsonNode, JsonNode expectedJsonNode) {
        JsonAssertContains.assertContains(actualJsonNode, expectedJsonNode);
    }

    public static String readResource(String resourcePath) {
        return IOUtils.readResource(resourcePath);
    }

    public static <T> T readFromResource(Class<T> type, String resourcePath) {
        return Json.read(type, Json.readResource(resourcePath));
    }

    public static <T> T read(Class<T> type, String json) {
        try {
            return (T)MAPPER.readValue(json, type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> readList(Class<T> type, String json) {
        CollectionType collectionType = MAPPER.getTypeFactory().constructCollectionType(List.class, type);
        try {
            return (List)MAPPER.readValue(json, (JavaType)collectionType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonNode readNodeFromResource(String resourcePath) {
        return Json.readNode(IOUtils.readResource(resourcePath));
    }

    public static JsonNode readNode(String json) {
        try {
            return MAPPER.readTree(json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toJsonString(Object bean) {
        try {
            return MAPPER.writeValueAsString(bean);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static ObjectMapper initMapper() {
        return new ObjectMapper().registerModule((Module)new JavaTimeModule()).configure(SerializationFeature.INDENT_OUTPUT, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.INDENT_OUTPUT, true).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static class Resource {
        private final String resourcePath;

        private Resource(String resourcePath) {
            this.resourcePath = resourcePath;
        }

        <T> T asBean(Class<T> cls) {
            return Json.read(cls, Json.readResource(this.resourcePath));
        }

        <T> List<T> asList(Class<T> cls) {
            return Json.readList(cls, Json.readResource(this.resourcePath));
        }

        JsonNode asNode() {
            return Json.readNodeFromResource(this.resourcePath);
        }
    }
}

