/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test;

import com.fasterxml.jackson.databind.JsonNode;
import io.ebean.test.CompareResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.assertj.core.api.Assertions;

class JsonAssertContains {
    private final Stack<String> path = new Stack();

    JsonAssertContains() {
    }

    static void assertContains(JsonNode actualJsonNode, JsonNode expectedJsonNode) {
        new JsonAssertContains().contains(actualJsonNode, expectedJsonNode);
    }

    private void contains(JsonNode actualJsonNode, JsonNode expectedJsonNode) {
        CompareResult result = this.checkRecursive(null, actualJsonNode, expectedJsonNode);
        if (result.hasErrors()) {
            List<String> errors = result.getErrors();
            Object errorsString = String.join((CharSequence)"\n", errors);
            errorsString = (String)errorsString + "\nExpected JSON fields: " + String.valueOf(expectedJsonNode);
            errorsString = (String)errorsString + "\nActual JSON: " + String.valueOf(actualJsonNode);
            Assertions.fail((String)errorsString);
        }
    }

    private CompareResult checkRecursive(String name, JsonNode actualJsonNode, JsonNode expectedJsonNode) {
        CompareResult result;
        if (name != null) {
            this.path.push(name);
        }
        if ((result = this.checkNull(actualJsonNode, expectedJsonNode)).isApplicable()) {
            return this.pop(name, result);
        }
        result = this.checkType(actualJsonNode, expectedJsonNode);
        if (result.isApplicable()) {
            return this.pop(name, result);
        }
        result = this.checkArray(actualJsonNode, expectedJsonNode);
        if (result.isApplicable()) {
            return this.pop(name, result);
        }
        result = this.checkObject(actualJsonNode, expectedJsonNode);
        if (result.isApplicable()) {
            return this.pop(name, result);
        }
        result = this.checkValue(actualJsonNode, expectedJsonNode);
        if (result.isApplicable()) {
            return this.pop(name, result);
        }
        return CompareResult.NOT_APPLICABLE;
    }

    private CompareResult pop(String name, CompareResult result) {
        if (name != null) {
            this.path.pop();
        }
        return result;
    }

    private CompareResult checkNull(JsonNode actualJsonNode, JsonNode expectedJsonNode) {
        if (actualJsonNode == null) {
            return CompareResult.error(String.format("Expected field '%s' to be '%s' but was null", this.path(), expectedJsonNode));
        }
        return CompareResult.NOT_APPLICABLE;
    }

    private CompareResult checkType(JsonNode actualJsonNode, JsonNode expectedJsonNode) {
        if (!expectedJsonNode.getNodeType().equals((Object)actualJsonNode.getNodeType())) {
            return CompareResult.error(String.format("Expected field '%s' to be of type '%s' but was '%s'", this.path(), expectedJsonNode.getNodeType(), actualJsonNode.getNodeType()));
        }
        return CompareResult.NOT_APPLICABLE;
    }

    private CompareResult checkArray(JsonNode actualJsonNode, JsonNode expectedJsonNode) {
        if (!expectedJsonNode.isArray()) {
            return CompareResult.NOT_APPLICABLE;
        }
        return new MatchArrayElements(actualJsonNode, expectedJsonNode).match();
    }

    private CompareResult checkObject(JsonNode actualJsonNode, JsonNode expectedJsonNode) {
        if (!expectedJsonNode.isObject()) {
            return CompareResult.NOT_APPLICABLE;
        }
        LinkedList<String> errors = new LinkedList<String>();
        Iterator expectedFields = expectedJsonNode.fields();
        while (expectedFields.hasNext()) {
            Map.Entry expectedField = (Map.Entry)expectedFields.next();
            String expectedKey = (String)expectedField.getKey();
            JsonNode actualNode = actualJsonNode.get(expectedKey);
            if (actualNode == null) {
                errors.add(String.format("Expected field '%s' to be present", this.path(expectedKey)));
                continue;
            }
            CompareResult result = this.checkRecursive(expectedKey, actualNode, (JsonNode)expectedField.getValue());
            errors.addAll(result.getErrors());
        }
        return CompareResult.errors(errors);
    }

    private CompareResult checkValue(JsonNode actualJsonNode, JsonNode expectedJsonNode) {
        if (!expectedJsonNode.equals((Object)actualJsonNode)) {
            return CompareResult.error(String.format("Expected field '%s' to be equal to '%s' but was '%s'", this.path(), expectedJsonNode, actualJsonNode));
        }
        return CompareResult.NO_ERRORS;
    }

    String path(String expectedKey) {
        if (this.path.isEmpty()) {
            return expectedKey;
        }
        return this.path() + "." + expectedKey;
    }

    String path() {
        if (this.path.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)".", this.path).replace(".[", "[");
    }

    private class MatchArrayElements {
        private final JsonNode actualJsonNode;
        private final JsonNode expectedJsonNode;
        private final Map<Integer, JsonNode> expectedMap = new LinkedHashMap<Integer, JsonNode>();
        private final Map<Integer, JsonNode> actualMap = new LinkedHashMap<Integer, JsonNode>();

        MatchArrayElements(JsonNode actualJsonNode, JsonNode expectedJsonNode) {
            this.actualJsonNode = actualJsonNode;
            this.expectedJsonNode = expectedJsonNode;
            for (int e = 0; e < expectedJsonNode.size(); ++e) {
                this.expectedMap.put(e, expectedJsonNode.get(e));
            }
            for (int a = 0; a < actualJsonNode.size(); ++a) {
                this.actualMap.put(a, actualJsonNode.get(a));
            }
        }

        CompareResult match() {
            Iterator<Map.Entry<Integer, JsonNode>> iterator = this.expectedMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, JsonNode> expectedEntry = iterator.next();
                int matchPos = this.findFirstMatch(expectedEntry.getKey(), expectedEntry.getValue());
                if (matchPos <= -1) continue;
                iterator.remove();
            }
            ArrayList<String> errors = new ArrayList<String>();
            if (this.actualJsonNode.size() != this.expectedJsonNode.size()) {
                errors.add(String.format("Unmatched array size for '%s', expected %d but got %d elements", JsonAssertContains.this.path(), this.expectedJsonNode.size(), this.actualJsonNode.size()));
            }
            for (Map.Entry<Integer, JsonNode> entry : this.expectedMap.entrySet()) {
                errors.add(String.format("Expected array element '%s[%d]' was not matched to an element in the actual array - element: %s", JsonAssertContains.this.path(), entry.getKey(), entry.getValue()));
            }
            for (Map.Entry<Integer, JsonNode> entry : this.actualMap.entrySet()) {
                errors.add(String.format("Actual array element '%s[%d]' was not matched to an element in the expected array - element: %s", JsonAssertContains.this.path(), entry.getKey(), entry.getValue()));
            }
            return CompareResult.errors(errors);
        }

        private int findFirstMatch(int e, JsonNode expectedNode) {
            Iterator<Map.Entry<Integer, JsonNode>> iterator = this.actualMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, JsonNode> entry = iterator.next();
                CompareResult result = JsonAssertContains.this.checkRecursive("[" + e + "]", entry.getValue(), expectedNode);
                if (!result.isApplicable() || result.hasErrors()) continue;
                iterator.remove();
                return entry.getKey();
            }
            return -1;
        }
    }
}

