/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.config.platform;

import io.ebean.docker.commands.ElasticContainer;
import java.util.Properties;

class ElasticSearchSetup {
    private static final String[] DOCKER_PARAMS = new String[]{"containerName", "image", "internalPort", "startMode", "shutdownMode"};
    private final Properties config;

    ElasticSearchSetup(Properties config) {
        this.config = config;
    }

    void run() {
        String version = this.read("version", null);
        if (version != null) {
            Properties properties = this.populateDockerProperties(version);
            ((ElasticContainer.Builder)ElasticContainer.builder((String)version).properties(properties)).build().start();
        }
    }

    private Properties populateDockerProperties(String version) {
        PropertiesBuilder properties = new PropertiesBuilder();
        String mode = this.config.getProperty("ebean.test.shutdownMode");
        if (mode != null) {
            properties.set("shutdownMode", mode);
        }
        properties.set("version", version);
        properties.set("port", this.read("port", "9201"));
        for (String dockerParam : DOCKER_PARAMS) {
            String val = this.read(dockerParam, null);
            if (val == null) continue;
            properties.set(dockerParam, val);
        }
        return properties.build();
    }

    private String read(String key, String defaultValue) {
        return this.config.getProperty("ebean.docstore.elastic." + key, defaultValue);
    }

    private static class PropertiesBuilder {
        private final Properties dockerProperties = new Properties();

        private PropertiesBuilder() {
        }

        private void set(String key, String val) {
            this.dockerProperties.setProperty("elastic." + key, val);
        }

        private Properties build() {
            return this.dockerProperties;
        }
    }
}

