/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.config.platform;

import io.ebean.test.config.platform.Config;
import io.ebean.test.config.platform.PlatformSetup;
import java.util.Properties;

class YugabyteSetup
implements PlatformSetup {
    YugabyteSetup() {
    }

    @Override
    public Properties setup(Config config) {
        int defaultPort = config.isUseDocker() ? 6433 : 5433;
        config.ddlMode("dropCreate");
        config.setDefaultPort(defaultPort);
        config.setUsernameDefault();
        config.setPasswordDefault();
        config.setUrl("jdbc:postgresql://${host}:${port}/${databaseName}");
        String schema = config.getSchema();
        if (schema != null && !schema.equals(config.getUsername())) {
            config.urlAppend("?currentSchema=" + schema);
        }
        config.setDriver("org.postgresql.Driver");
        config.datasourceDefaults();
        return this.dockerProperties(config);
    }

    private Properties dockerProperties(Config config) {
        if (!config.isUseDocker()) {
            return new Properties();
        }
        config.setDockerVersion("2.16.0.1-b7");
        config.setExtensions("pgcrypto");
        return config.getDockerProperties();
    }

    @Override
    public void setupExtraDbDataSource(Config config) {
        int defaultPort = config.isUseDocker() ? 6433 : 5433;
        config.setDefaultPort(defaultPort);
        config.setExtraUsernameDefault();
        config.setExtraDbPasswordDefault();
        config.setUrl("jdbc:postgresql://${host}:${port}/${databaseName}");
        config.setDriver("org.postgresql.Driver");
        config.extraDatasourceDefaults();
    }

    @Override
    public boolean isLocal() {
        return false;
    }
}

