/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.querybean.generator;

import io.ebean.querybean.generator.Constants;
import io.ebean.querybean.generator.FindDbName;
import io.ebean.querybean.generator.PropertyType;
import io.ebean.querybean.generator.PropertyTypeArray;
import io.ebean.querybean.generator.PropertyTypeAssoc;
import io.ebean.querybean.generator.PropertyTypeEnum;
import io.ebean.querybean.generator.PropertyTypeMap;
import io.ebean.querybean.generator.Split;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

class ProcessingContext
implements Constants {
    private final Types typeUtils;
    private final Filer filer;
    private final Messager messager;
    private final Elements elementUtils;
    private final String generatedAnnotation;
    private final PropertyTypeMap propertyTypeMap = new PropertyTypeMap();

    ProcessingContext(ProcessingEnvironment processingEnv) {
        this.typeUtils = processingEnv.getTypeUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
        this.elementUtils = processingEnv.getElementUtils();
        boolean jdk8 = processingEnv.getSourceVersion().compareTo(SourceVersion.RELEASE_8) <= 0;
        this.generatedAnnotation = this.generatedAnnotation(jdk8);
    }

    private String generatedAnnotation(boolean jdk8) {
        if (jdk8) {
            return this.isTypeAvailable("javax.annotation.Generated") ? "javax.annotation.Generated" : null;
        }
        return this.isTypeAvailable("javax.annotation.processing.Generated") ? "javax.annotation.processing.Generated" : null;
    }

    private boolean isTypeAvailable(String canonicalName) {
        return null != this.elementUtils.getTypeElement(canonicalName);
    }

    List<VariableElement> allFields(Element element) {
        ArrayList<VariableElement> list = new ArrayList<VariableElement>();
        this.gatherProperties(list, element);
        return list;
    }

    private void gatherProperties(List<VariableElement> fields, Element element) {
        TypeElement typeElement = (TypeElement)element;
        TypeMirror superclass = typeElement.getSuperclass();
        Element mappedSuper = this.typeUtils.asElement(superclass);
        if (this.isMappedSuperOrInheritance(mappedSuper)) {
            this.gatherProperties(fields, mappedSuper);
        }
        List<VariableElement> allFields = ElementFilter.fieldsIn(element.getEnclosedElements());
        for (VariableElement field : allFields) {
            if (this.ignoreField(field)) continue;
            fields.add(field);
        }
    }

    private boolean ignoreField(VariableElement field) {
        return this.isStaticOrTransient(field) || this.ignoreEbeanInternalFields(field);
    }

    private boolean ignoreEbeanInternalFields(VariableElement field) {
        String fieldName = field.getSimpleName().toString();
        return fieldName.startsWith("_ebean") || fieldName.startsWith("_EBEAN");
    }

    private boolean isStaticOrTransient(VariableElement field) {
        Set<Modifier> modifiers = field.getModifiers();
        return modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.TRANSIENT);
    }

    private static boolean hasAnnotations(Element element, String ... annotations) {
        return ProcessingContext.getAnnotation(element, annotations) != null;
    }

    private static AnnotationMirror getAnnotation(Element element, String ... annotations) {
        if (element == null) {
            return null;
        }
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String name = annotationMirror.getAnnotationType().asElement().toString();
            for (String annotation : annotations) {
                if (!annotation.equals(name)) continue;
                return annotationMirror;
            }
        }
        return null;
    }

    private boolean isMappedSuperOrInheritance(Element mappedSuper) {
        return ProcessingContext.hasAnnotations(mappedSuper, "javax.persistence.MappedSuperclass", "javax.persistence.Inheritance");
    }

    private boolean isEntityOrEmbedded(Element mappedSuper) {
        return ProcessingContext.hasAnnotations(mappedSuper, "javax.persistence.Entity", "javax.persistence.Embeddable");
    }

    boolean isEntity(Element element) {
        return ProcessingContext.hasAnnotations(element, "javax.persistence.Entity");
    }

    String findDbName(TypeElement element) {
        return FindDbName.value(element, this.typeUtils);
    }

    private static boolean dbJsonField(Element field) {
        return ProcessingContext.hasAnnotations(field, "io.ebean.annotation.DbJson", "io.ebean.annotation.DbJsonB");
    }

    private static boolean dbArrayField(Element field) {
        return ProcessingContext.hasAnnotations(field, "io.ebean.annotation.DbArray");
    }

    private static String typeDef(TypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            return declaredType.asElement().toString();
        }
        return typeMirror.toString();
    }

    PropertyType getPropertyType(VariableElement field) {
        String fullType;
        TypeMirror typeMirror;
        TypeMirror currentType = typeMirror = field.asType();
        while (currentType != null) {
            PropertyType type = this.propertyTypeMap.getType(ProcessingContext.typeDef(currentType));
            if (type != null) {
                return type;
            }
            TypeElement fieldType = (TypeElement)this.typeUtils.asElement(currentType);
            currentType = fieldType == null ? null : fieldType.getSuperclass();
        }
        if (ProcessingContext.dbJsonField(field)) {
            return this.propertyTypeMap.getDbJsonType();
        }
        if (ProcessingContext.dbArrayField(field)) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            fullType = ProcessingContext.typeDef(declaredType.getTypeArguments().get(0));
            return new PropertyTypeArray(fullType, Split.shortName(fullType));
        }
        Element fieldType = this.typeUtils.asElement(typeMirror);
        if (fieldType != null) {
            TypeMirror argType;
            Element argElement;
            DeclaredType declaredType;
            List<? extends TypeMirror> typeArguments;
            if ((fieldType = this.elementUtils.getTypeElement(fieldType.toString())).getKind() == ElementKind.ENUM) {
                fullType = ProcessingContext.typeDef(typeMirror);
                return new PropertyTypeEnum(fullType, Split.shortName(fullType));
            }
            if (this.isEntityOrEmbedded(fieldType)) {
                return this.createPropertyTypeAssoc(ProcessingContext.typeDef(typeMirror));
            }
            if (typeMirror.getKind() == TypeKind.DECLARED && (typeArguments = (declaredType = (DeclaredType)typeMirror).getTypeArguments()).size() == 1 && this.isEntityOrEmbedded(argElement = this.typeUtils.asElement(argType = typeArguments.get(0)))) {
                return this.createPropertyTypeAssoc(ProcessingContext.typeDef(argElement.asType()));
            }
        }
        return null;
    }

    private PropertyType createPropertyTypeAssoc(String fullName) {
        String[] split = Split.split(fullName);
        String propertyName = "QAssoc" + split[1];
        String packageName = this.packageAppend(split[0]);
        return new PropertyTypeAssoc(propertyName, packageName);
    }

    private String packageAppend(String origPackage) {
        if (origPackage == null) {
            return "query.assoc";
        }
        return origPackage + ".query.assoc";
    }

    JavaFileObject createWriter(String factoryClassName, Element originatingElement) throws IOException {
        return this.filer.createSourceFile(factoryClassName, originatingElement);
    }

    void logError(Element e, String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    void logNote(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
    }

    boolean isGeneratedAvailable() {
        return this.generatedAnnotation != null;
    }

    String getGeneratedAnnotation() {
        return this.generatedAnnotation;
    }
}

