/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.querybean.generator;

import io.ebean.querybean.generator.Constants;
import io.ebean.querybean.generator.ProcessingContext;
import io.ebean.querybean.generator.SimpleQueryBeanWriter;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public class Processor
extends AbstractProcessor
implements Constants {
    private ProcessingContext processingContext;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.processingContext = new ProcessingContext(processingEnv);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add("javax.persistence.Entity");
        annotations.add("javax.persistence.Embeddable");
        return annotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        int count = 0;
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                this.generateQueryBeans(element);
                ++count;
            }
        }
        if (count > 0) {
            this.processingContext.logNote("Generated " + count + " query beans", new Object[0]);
        }
        return true;
    }

    private void generateQueryBeans(Element element) {
        try {
            SimpleQueryBeanWriter beanWriter = new SimpleQueryBeanWriter((TypeElement)element, this.processingContext);
            beanWriter.writeRootBean();
            beanWriter.writeAssocBean();
        }
        catch (Exception e) {
            this.processingContext.logError(element, "Error generating query beans: " + e, new Object[0]);
        }
    }
}

