/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.querybean.generator;

import io.ebean.querybean.generator.PropertyType;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

class PropertyTypeMap {
    private final PropertyType dbJsonType = new PropertyType("PJson");
    private Map<String, PropertyType> map = new HashMap<String, PropertyType>();

    PropertyTypeMap() {
        this.map.put("boolean", new PropertyType("PBoolean"));
        this.map.put("short", new PropertyType("PShort"));
        this.map.put("int", new PropertyType("PInteger"));
        this.map.put("long", new PropertyType("PLong"));
        this.map.put("double", new PropertyType("PDouble"));
        this.map.put("float", new PropertyType("PFloat"));
        this.addType(Boolean.class);
        this.addType(Short.class);
        this.addType(Integer.class);
        this.addType(Long.class);
        this.addType(Double.class);
        this.addType(Float.class);
        this.addType(String.class);
        this.addType(Timestamp.class);
        this.map.put(Date.class.getName(), new PropertyType("PSqlDate"));
        this.map.put(java.util.Date.class.getName(), new PropertyType("PUtilDate"));
        this.addType(Time.class);
        this.addType(TimeZone.class);
        this.addType(BigDecimal.class);
        this.addType(BigInteger.class);
        this.addType(Calendar.class);
        this.addType(Currency.class);
        this.addType(Class.class);
        this.addType(Locale.class);
        this.map.put("java.lang.Class<?>", new PropertyType("PClass"));
        this.addType(File.class);
        this.addType(InetAddress.class);
        this.map.put(URI.class.getName(), new PropertyType("PUri"));
        this.map.put(URL.class.getName(), new PropertyType("PUrl"));
        this.map.put(UUID.class.getName(), new PropertyType("PUuid"));
        this.map.put("io.ebean.types.Inet", new PropertyType("PInet"));
        this.map.put("io.ebean.types.Cdir", new PropertyType("PCdir"));
        this.addJava8Types();
        this.addJodaTypes();
    }

    private void addType(Class<?> cls) {
        String simpleName = cls.getSimpleName();
        this.map.put(cls.getName(), new PropertyType("P" + simpleName));
    }

    private void addJava8Types() {
        try {
            Class.forName("java.time.Instant");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        this.addType(DayOfWeek.class);
        this.addType(Duration.class);
        this.addType(Instant.class);
        this.addType(LocalDate.class);
        this.addType(LocalDateTime.class);
        this.addType(LocalTime.class);
        this.addType(Month.class);
        this.addType(MonthDay.class);
        this.addType(OffsetDateTime.class);
        this.addType(OffsetTime.class);
        this.addType(Year.class);
        this.addType(YearMonth.class);
        this.addType(ZoneId.class);
        this.addType(ZoneOffset.class);
    }

    private void addJodaTypes() {
        this.map.put("org.joda.time.DateTime", new PropertyType("PJodaDateTime"));
        this.map.put("org.joda.time.DateMidnight", new PropertyType("PJodaDateMidnight"));
        this.map.put("org.joda.time.LocalDate", new PropertyType("PJodaLocalDate"));
        this.map.put("org.joda.time.LocalDateTime", new PropertyType("PJodaLocalDateTime"));
        this.map.put("org.joda.time.LocalTime", new PropertyType("PJodaLocalTime"));
    }

    PropertyType getType(String classDesc) {
        return this.map.get(classDesc);
    }

    PropertyType getDbJsonType() {
        return this.dbJsonType;
    }
}

