/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.querybean.generator;

import io.ebean.querybean.generator.Append;
import io.ebean.querybean.generator.ProcessingContext;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;

class SimpleModuleInfoWriter {
    private final ProcessingContext processingContext;
    private final String factoryPackage;
    private final String factoryShortName;
    private final String factoryFullName;
    private Append writer;

    SimpleModuleInfoWriter(ProcessingContext processingContext) {
        this.processingContext = processingContext;
        this.factoryPackage = processingContext.getFactoryPackage();
        this.factoryShortName = "_Ebean$ModuleInfo";
        this.factoryFullName = this.factoryPackage + "." + this.factoryShortName;
    }

    void write() throws IOException {
        this.writer = new Append(this.createFileWriter());
        this.writePackage();
        this.writeStartClass();
        this.writeEndClass();
        this.writer.close();
        this.writeServicesFile();
        this.writeManifestFile();
    }

    private void writeServicesFile() {
        try {
            FileObject jfo = this.processingContext.createMetaInfServicesWriter();
            if (jfo != null) {
                Writer writer = jfo.openWriter();
                writer.write(this.factoryFullName);
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.processingContext.logError(null, "Failed to write services file " + e.getMessage(), new Object[0]);
        }
    }

    private void writeManifestFile() {
        try {
            FileObject jfo;
            Set<String> allEntityPackages = this.processingContext.getAllEntityPackages();
            if (!allEntityPackages.isEmpty() && (jfo = this.processingContext.createManifestWriter()) != null) {
                Writer writer = jfo.openWriter();
                writer.write("generated-by: Ebean query bean generator\n");
                writer.write(this.manifestEntityPackages(allEntityPackages));
                writer.write("\n");
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.processingContext.logError(null, "Failed to write services file " + e.getMessage(), new Object[0]);
        }
    }

    private String manifestEntityPackages(Set<String> allEntityPackages) {
        StringBuilder builder = new StringBuilder("entity-packages: ");
        for (String pkg : allEntityPackages) {
            builder.append(pkg).append("\n").append("  ");
        }
        return builder.delete(builder.lastIndexOf("\n"), builder.length()).append("\n").toString();
    }

    private void writePackage() {
        this.writer.append("package %s;", this.factoryPackage).eol().eol();
        this.writer.append("import java.util.ArrayList;").eol();
        this.writer.append("import java.util.Collections;").eol();
        this.writer.append("import java.util.List;").eol();
        this.writer.append("import %s;", "io.ebean.typequery.Generated").eol();
        this.writer.eol();
        this.writer.append("import io.ebean.config.ModuleInfo;").eol();
        this.writer.append("import io.ebean.config.ModuleInfoLoader;").eol();
        this.writer.eol();
    }

    void buildAtContextModule(Append writer) {
        writer.append("@Generated(\"io.ebean.querybean.generator\")").eol();
        writer.append("@ModuleInfo(");
        if (this.processingContext.hasOtherClasses()) {
            writer.append("other={%s}, ", this.otherClasses());
        }
        writer.append("entities={%s}", this.prefixEntities());
        writer.append(")").eol();
    }

    private String otherClasses() {
        return this.quoteTypes(this.processingContext.getOtherClasses());
    }

    private String prefixEntities() {
        return this.quoteTypes(this.processingContext.getPrefixEntities());
    }

    private String quoteTypes(Set<String> otherClasses) {
        StringJoiner sb = new StringJoiner(",");
        for (String fullType : otherClasses) {
            sb.add("\"" + fullType + "\"");
        }
        return sb.toString();
    }

    private void writeStartClass() {
        this.buildAtContextModule(this.writer);
        this.writer.append("public class %s implements ModuleInfoLoader {", this.factoryShortName).eol().eol();
        this.writeMethodOtherClasses();
        this.writeMethodEntityClasses(this.processingContext.getDbEntities(), null);
        Map<String, Set<String>> otherDbEntities = this.processingContext.getOtherDbEntities();
        for (Map.Entry<String, Set<String>> otherDb : otherDbEntities.entrySet()) {
            this.writeMethodEntityClasses(otherDb.getValue(), otherDb.getKey());
        }
        this.writeMethodEntityClassesFor(otherDbEntities.keySet());
        this.writeMethodEntityClassesFor();
    }

    private void writeMethodOtherClasses() {
        this.writeMethodComment("Register AttributeConverter etc", "");
        this.writer.append("  private List<Class<?>> otherClasses() {").eol();
        if (!this.processingContext.hasOtherClasses()) {
            this.writer.append("    return Collections.emptyList();").eol();
        } else {
            this.writer.append("    List<Class<?>> others = new ArrayList<>();").eol();
            for (String otherType : this.processingContext.getOtherClasses()) {
                this.writer.append("    others.add(%s.class);", otherType).eol();
            }
            this.writer.append("    return others;").eol();
        }
        this.writer.append("  }").eol().eol();
    }

    private void writeMethodEntityClasses(Set<String> dbEntities, String dbName) {
        String method = "defaultEntityClasses";
        if (dbName != null) {
            method = "entitiesFor_" + dbName;
            this.writeMethodComment("Entities for @DbName(name=\"%s\"))", dbName);
        } else {
            this.writeMethodComment("Entities with no @DbName", dbName);
        }
        this.writer.append("  private List<Class<?>> %s() {", method).eol();
        if (dbEntities.isEmpty() && !this.processingContext.hasOtherClasses()) {
            this.writer.append("    return Collections.emptyList();").eol();
        } else {
            this.writer.append("    List<Class<?>> entities = new ArrayList<>();").eol();
            for (String dbEntity : dbEntities) {
                this.writer.append("    entities.add(%s.class);", dbEntity).eol();
            }
            if (this.processingContext.hasOtherClasses()) {
                this.writer.append("    entities.addAll(otherClasses());").eol();
            }
            this.writer.append("    return entities;").eol();
        }
        this.writer.append("  }").eol().eol();
    }

    private void writeMethodComment(String msg, String arg) {
        this.writer.append("  /**").eol();
        this.writer.append("   * ").append(msg, arg).eol();
        this.writer.append("   */").eol();
    }

    private void writeMethodEntityClassesFor(Set<String> otherDbNames) {
        this.writer.append("  private List<Class<?>> classesFor(String dbName) {").eol();
        for (String dbName : otherDbNames) {
            this.writer.append("    if (\"%s\".equals(dbName)) return entitiesFor_%s();", dbName, dbName).eol();
        }
        this.writer.append("    return new ArrayList<>();").eol();
        this.writer.append("  }").eol().eol();
    }

    private void writeMethodEntityClassesFor() {
        this.writer.append("  @Override").eol();
        this.writer.append("  public List<Class<?>> classesFor(String dbName, boolean defaultServer) {").eol();
        this.writer.append("    List<Class<?>> classes = classesFor(dbName);").eol();
        this.writer.append("    if (defaultServer) {").eol();
        this.writer.append("      classes.addAll(defaultEntityClasses());").eol();
        this.writer.append("    }").eol();
        this.writer.append("    return classes;").eol();
        this.writer.append("  }").eol().eol();
    }

    private void writeEndClass() {
        this.writer.append("}").eol();
    }

    private Writer createFileWriter() throws IOException {
        JavaFileObject jfo = this.processingContext.createWriter(this.factoryFullName);
        return jfo.openWriter();
    }
}

