/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.querybean.generator;

import io.ebean.querybean.generator.Append;
import io.ebean.querybean.generator.ProcessingContext;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;

final class LookupWriter {
    private static final String METAINF_SERVICES_LOOKUP = "META-INF/services/io.ebean.config.LookupProvider";
    private static final String FILE_STRING = "package %s;\n\nimport java.lang.invoke.MethodHandles;\n\nimport io.ebean.config.LookupProvider;\n\npublic class EbeanMethodLookup implements LookupProvider {\n\n  private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();\n\n  @Override\n  public MethodHandles.Lookup provideLookup() {\n    return LOOKUP;\n  }\n}";

    private LookupWriter() {
    }

    static void write(ProcessingContext processingContext, Elements util, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ModuleElement module = annotations.stream().map(roundEnv::getElementsAnnotatedWith).filter(Predicate.not(Collection::isEmpty)).findAny().map(s -> (Element)s.iterator().next()).map(util::getModuleOf).orElse(null);
        if (module != null && !module.isUnnamed()) {
            String moduleNameString = module.getQualifiedName().toString();
            String pkg = moduleNameString + ".lookup";
            String fqn = pkg + ".EbeanMethodLookup";
            try {
                JavaFileObject javaFileObject = processingContext.createWriter(fqn);
                Append writer = new Append(javaFileObject.openWriter());
                writer.append(FILE_STRING, pkg);
                writer.close();
                LookupWriter.writeServicesFile(processingContext, fqn);
            }
            catch (FilerException e) {
                processingContext.logWarn(null, "FilerException writing Lookup " + e.getMessage());
            }
            catch (IOException e) {
                processingContext.logError(null, "Failed to write lookup class " + e.getMessage(), new Object[0]);
            }
        }
    }

    private static void writeServicesFile(ProcessingContext processingContext, String fqn) throws IOException {
        FileObject jfo = processingContext.createMetaInfWriter(METAINF_SERVICES_LOOKUP);
        if (jfo != null) {
            Writer writer = jfo.openWriter();
            writer.write(fqn);
            writer.close();
        }
    }
}

