/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.querybean.generator;

import io.ebean.querybean.generator.Append;
import io.ebean.querybean.generator.ProcessingContext;
import io.ebean.querybean.generator.PropertyMeta;
import io.ebean.querybean.generator.PropertyType;
import io.ebean.querybean.generator.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileObject;

class SimpleQueryBeanWriter {
    private final Set<String> importTypes = new TreeSet<String>();
    private final List<PropertyMeta> properties = new ArrayList<PropertyMeta>();
    private final TypeElement element;
    private final TypeElement implementsInterface;
    private String implementsInterfaceShortName;
    private final ProcessingContext processingContext;
    private final String dbName;
    private final String beanFullName;
    private final boolean isEntity;
    private final boolean embeddable;
    private final String destPackage;
    private final String shortName;
    private final String shortInnerName;
    private final boolean fullyQualify;
    private Append writer;

    SimpleQueryBeanWriter(TypeElement element, ProcessingContext processingContext) {
        this.element = element;
        this.processingContext = processingContext;
        this.beanFullName = element.getQualifiedName().toString();
        boolean nested = element.getNestingKind().isNested();
        this.destPackage = Util.packageOf(nested, this.beanFullName) + ".query";
        String sn = Util.shortName(nested, this.beanFullName);
        this.shortInnerName = Util.shortName(false, sn);
        this.shortName = sn.replace('.', '$');
        this.isEntity = processingContext.isEntity(element);
        this.embeddable = processingContext.isEmbeddable(element);
        this.dbName = this.findDbName();
        this.implementsInterface = this.initInterface(element);
        this.fullyQualify = processingContext.isNameClash(this.shortName);
    }

    private TypeElement initInterface(TypeElement element) {
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement e = (TypeElement)this.processingContext.asElement(typeMirror);
            String name = e.getQualifiedName().toString();
            if (name.startsWith("java") || name.startsWith("io.ebean")) continue;
            return e;
        }
        return null;
    }

    private String findDbName() {
        return this.processingContext.findDbName(this.element);
    }

    private boolean isEntity() {
        return this.isEntity;
    }

    private void gatherPropertyDetails() {
        if (this.implementsInterface != null) {
            String implementsInterfaceFullName = this.implementsInterface.getQualifiedName().toString();
            boolean nested = this.implementsInterface.getNestingKind().isNested();
            this.implementsInterfaceShortName = Util.shortName(nested, implementsInterfaceFullName);
            this.importTypes.add("io.avaje.lang.Nullable");
            this.importTypes.add("java.util.Collection");
            this.importTypes.add(implementsInterfaceFullName);
        }
        this.addClassProperties();
    }

    private void addClassProperties() {
        for (VariableElement field : this.processingContext.allFields(this.element)) {
            PropertyType type = this.processingContext.getPropertyType(field);
            if (type == null) continue;
            type.addImports(this.importTypes, this.fullyQualify);
            this.properties.add(new PropertyMeta(field.getSimpleName().toString(), type));
        }
    }

    void writeRootBean() throws IOException {
        this.gatherPropertyDetails();
        this.processingContext.addEntity(this.beanFullName, this.dbName);
        this.writer = new Append(this.createFileWriter());
        this.writePackage();
        this.writeImports();
        this.writeClass();
        if (this.isEntity()) {
            this.writeAlias();
            this.writeFields();
            this.writeConstructors();
            this.writeStaticAliasClass();
        }
        this.writeAssocClass();
        this.writeClassEnd();
        this.writer.close();
    }

    private void writeConstructors() {
        this.writer.eol();
        this.writer.append("  /**").eol();
        this.writer.append("   * Return a query bean used to build a FetchGroup.").eol();
        this.writer.append("   * <p>").eol();
        this.writer.append("   * FetchGroups are immutable and threadsafe and can be used by many").eol();
        this.writer.append("   * concurrent queries. We typically stored FetchGroup as a static final field.").eol();
        this.writer.append("   * <p>").eol();
        this.writer.append("   * Example creating and using a FetchGroup.").eol();
        this.writer.append("   * <pre>{@code").eol();
        this.writer.append("   * ").eol();
        this.writer.append("   * static final FetchGroup<Customer> fetchGroup = ").eol();
        this.writer.append("   *   QCustomer.forFetchGroup()").eol();
        this.writer.append("   *     .shippingAddress.fetch()").eol();
        this.writer.append("   *     .contacts.fetch()").eol();
        this.writer.append("   *     .buildFetchGroup();").eol();
        this.writer.append("   * ").eol();
        this.writer.append("   * List<Customer> customers = new QCustomer()").eol();
        this.writer.append("   *   .select(fetchGroup)").eol();
        this.writer.append("   *   .findList();").eol();
        this.writer.append("   * ").eol();
        this.writer.append("   * }</pre>").eol();
        this.writer.append("   */").eol();
        this.writer.append("  public static Q%s forFetchGroup() {", this.shortName).eol();
        this.writer.append("    return new Q%s(io.ebean.FetchGroup.queryFor(%s.class));", this.shortName, this.beanFullName).eol();
        this.writer.append("  }").eol();
        this.writer.eol();
        String name = this.dbName == null ? "default" : this.dbName;
        this.writer.append("  /** Construct using the %s Database */", name).eol();
        this.writer.append("  public Q%s() {", this.shortName).eol();
        if (this.dbName == null) {
            this.writer.append("    super(%s.class);", this.beanFullName).eol();
        } else {
            this.writer.append("    super(%s.class, io.ebean.DB.byName(\"%s\"));", this.beanFullName, this.dbName).eol();
        }
        this.writer.append("  }").eol();
        this.writer.eol();
        this.writer.append("  /** @deprecated migrate to query.usingTransaction() */").eol();
        this.writer.append("  @Deprecated(forRemoval = true)").eol();
        this.writer.append("  public Q%s(io.ebean.Transaction transaction) {", this.shortName).eol();
        if (this.dbName == null) {
            this.writer.append("    super(%s.class, transaction);", this.beanFullName).eol();
        } else {
            this.writer.append("    super(%s.class, io.ebean.DB.byName(\"%s\"), transaction);", this.beanFullName, this.dbName).eol();
        }
        this.writer.append("  }").eol();
        this.writer.eol();
        this.writer.append("  /** Construct with a given Database */").eol();
        this.writer.append("  public Q%s(io.ebean.Database database) {", this.shortName).eol();
        this.writer.append("    super(%s.class, database);", this.beanFullName).eol();
        this.writer.append("  }").eol();
        this.writer.eol();
        this.writer.eol();
        this.writer.append("  /** Private constructor for Alias */").eol();
        this.writer.append("  private Q%s(boolean dummy) {", this.shortName).eol();
        this.writer.append("    super(dummy);").eol();
        this.writer.append("  }").eol();
        this.writer.eol();
        this.writer.append("  /** Private constructor for FetchGroup building */").eol();
        this.writer.append("  private Q%s(io.ebean.Query<%s> fetchGroupQuery) {", this.shortName, this.beanFullName).eol();
        this.writer.append("    super(fetchGroupQuery);").eol();
        this.writer.append("  }").eol();
        this.writer.eol();
        this.writer.append("  /** Private constructor for filterMany */").eol();
        this.writer.append("  private Q%s(io.ebean.ExpressionList<%s> filter) {", this.shortName, this.beanFullName).eol();
        this.writer.append("    super(filter);").eol();
        this.writer.append("  }").eol();
        this.writer.eol();
        this.writer.append("  /** Return a copy of the query bean. */").eol();
        this.writer.append("  @Override").eol();
        this.writer.append("  public Q%s copy() {", this.shortName).eol();
        this.writer.append("    return new Q%s(query().copy());", this.shortName).eol();
        this.writer.append("  }").eol();
    }

    private void writeFields() {
        for (PropertyMeta property : this.properties) {
            property.writeFieldDefn(this.writer, this.shortName, false, this.fullyQualify);
            this.writer.eol();
        }
        this.writer.eol();
    }

    private void writeClass() {
        this.writer.append("/**").eol();
        this.writer.append(" * Query bean for %s.", this.shortName).eol();
        this.writer.append(" * <p>").eol();
        this.writer.append(" * THIS IS A GENERATED OBJECT, DO NOT MODIFY THIS CLASS.").eol();
        this.writer.append(" */").eol();
        this.writer.append("@SuppressWarnings(\"unused\")").eol();
        this.writer.append("@io.ebean.typequery.Generated(\"io.ebean.querybean.generator\")").eol();
        if (this.embeddable) {
            this.writer.append("public final class Q%s {", this.shortName).eol();
        } else {
            this.writer.append("@io.ebean.typequery.TypeQueryBean(\"v1\")").eol();
            this.writer.append("public final class Q%s extends io.ebean.typequery.QueryBean<%s,Q%s> {", this.shortName, this.beanFullName, this.shortName).eol();
        }
        this.writer.eol();
    }

    private void writeAlias() {
        this.writer.append("  private static final Q%s _alias = new Q%1$s(true);", this.shortName).eol().eol();
        this.writer.append("  /**").eol();
        this.writer.append("   * Return the shared 'Alias' instance used to provide properties to ").eol();
        this.writer.append("   * <code>select()</code> and <code>fetch()</code> ").eol();
        this.writer.append("   */").eol();
        this.writer.append("  public static Q%s alias() {", this.shortName).eol();
        this.writer.append("    return _alias;").eol();
        this.writer.append("  }").eol();
        this.writer.eol();
    }

    private void writeStaticAliasClass() {
        this.writer.eol();
        this.writer.append("  /**").eol();
        this.writer.append("   * Provides static properties to use in <em> select() and fetch() </em>").eol();
        this.writer.append("   * clauses of a query. Typically referenced via static imports. ").eol();
        this.writer.append("   */").eol();
        this.writer.append("  ").append("@io.ebean.typequery.Generated(\"io.ebean.querybean.generator\")").eol();
        this.writer.append("  public static final class Alias {").eol();
        for (PropertyMeta property : this.properties) {
            property.writeFieldAliasDefn(this.writer, this.shortName, this.fullyQualify);
            this.writer.eol();
        }
        this.writer.append("  }").eol();
    }

    private void writeAssocClass() {
        this.writer.eol();
        this.writer.append("  /** Association query bean */").eol();
        this.writer.append("  ").append("@io.ebean.typequery.Generated(\"io.ebean.querybean.generator\")").eol();
        this.writer.append("  ").append("@io.ebean.typequery.TypeQueryBean(\"v1\")").eol();
        if (this.embeddable) {
            this.writer.append("  public static final class Assoc<R> extends io.ebean.typequery.TQAssoc<%s,R> {", this.beanFullName).eol();
        } else {
            this.writer.append("  public static abstract class Assoc<R> extends io.ebean.typequery.TQAssocBean<%s,R,Q%s> {", this.beanFullName, this.shortInnerName).eol();
        }
        this.writer.eol();
        for (PropertyMeta property : this.properties) {
            this.writer.append("  ");
            property.writeFieldDefn(this.writer, this.shortName, true, this.fullyQualify);
            this.writer.eol();
        }
        this.writer.eol();
        this.writeAssocBeanConstructor("protected Assoc");
        this.writeAssocBeanFetch();
        this.writer.append("  }").eol();
        if (!this.embeddable) {
            this.writeAssocOne();
            this.writeAssocMany();
        }
    }

    private void writeAssocOne() {
        this.writer.eol();
        this.writer.append("  /** Associated ToOne query bean */").eol();
        this.writer.append("  ").append("@io.ebean.typequery.Generated(\"io.ebean.querybean.generator\")").eol();
        this.writer.append("  ").append("@io.ebean.typequery.TypeQueryBean(\"v1\")").eol();
        this.writer.append("  public static final class AssocOne<R> extends Assoc<R> {").eol();
        this.writeAssocBeanConstructor("public AssocOne");
        this.writer.append("  }").eol();
    }

    private void writeAssocMany() {
        this.writer.eol();
        this.writer.append("  /** Associated ToMany query bean */").eol();
        this.writer.append("  ").append("@io.ebean.typequery.Generated(\"io.ebean.querybean.generator\")").eol();
        this.writer.append("  ").append("@io.ebean.typequery.TypeQueryBean(\"v1\")").eol();
        this.writer.append("  public static final class AssocMany<R> extends Assoc<R> implements io.ebean.typequery.TQAssocMany<%s, R, Q%s>{", this.beanFullName, this.shortInnerName).eol();
        this.writeAssocBeanConstructor("public AssocMany");
        this.writeAssocFilterMany();
        this.writer.append("  }").eol();
    }

    private void writeAssocFilterMany() {
        this.writer.eol();
        this.writer.append("    @Override").eol();
        this.writer.append("    public R filterMany(java.util.function.Consumer<Q%s> apply) {", this.shortName).eol();
        this.writer.append("      final io.ebean.ExpressionList<%s> list = _newExpressionList();", this.beanFullName).eol();
        this.writer.append("      apply.accept(new Q%s(list));", this.shortName).eol();
        this.writer.append("      return _filterMany(list);").eol();
        this.writer.append("    }").eol();
        this.writer.eol();
        this.writer.append("    @Override").eol();
        this.writer.append("    public R filterMany(io.ebean.ExpressionList<%s> filter) { return _filterMany(filter); }", this.beanFullName).eol();
        this.writer.eol();
        this.writer.append("    @Override").eol();
        this.writer.append("    public R filterManyRaw(String rawExpressions, Object... params) { return _filterManyRaw(rawExpressions, params); }").eol();
        this.writer.eol();
        this.writer.append("    @Override").eol();
        this.writer.append("    public R isEmpty() { return _isEmpty(); }").eol();
        this.writer.eol();
        this.writer.append("    @Override").eol();
        this.writer.append("    public R isNotEmpty() { return _isNotEmpty(); }").eol();
    }

    private void writeAssocBeanConstructor(String prefix) {
        this.writer.append("    %s(String name, R root) { super(name, root); }", prefix).eol();
        this.writer.append("    %s(String name, R root, String prefix) { super(name, root, prefix); }", prefix).eol();
    }

    private void writeAssocBeanFetch() {
        if (this.isEntity() && this.implementsInterface != null) {
            this.writeAssocBeanExpression(false, "eq", "Is equal to by ID property.");
            this.writeAssocBeanExpression(true, "eqIfPresent", "Is equal to by ID property if the value is not null, if null no expression is added.");
            this.writeAssocBeanExpression(false, "in", "IN the given values.", this.implementsInterfaceShortName + "...", "in");
            this.writeAssocBeanExpression(false, "inBy", "IN the given interface values.", "Collection<? extends " + this.implementsInterfaceShortName + ">", "in");
            this.writeAssocBeanExpression(true, "inOrEmptyBy", "IN the given interface values if the collection is not empty. No expression is added if the collection is empty..", "Collection<? extends " + this.implementsInterfaceShortName + ">", "inOrEmpty");
        }
    }

    private void writeAssocBeanExpression(boolean nullable, String expression, String comment) {
        this.writeAssocBeanExpression(nullable, expression, comment, this.implementsInterfaceShortName, expression);
    }

    private void writeAssocBeanExpression(boolean nullable, String expression, String comment, String param, String actualExpression) {
        String nullableAnnotation = nullable ? "@Nullable " : "";
        String values = expression.startsWith("in") ? "values" : "value";
        String castVarargs = expression.equals("in") ? "(Object[])" : "";
        this.writer.append("  /**").eol();
        this.writer.append("   * ").append(comment).eol();
        this.writer.append("   */").eol();
        this.writer.append("  public final R %s(%s%s %s) {", expression, nullableAnnotation, param, values).eol();
        this.writer.append("    expr().%s(_name, %s%s);", actualExpression, castVarargs, values).eol();
        this.writer.append("    return _root;").eol();
        this.writer.append("  }").eol();
        this.writer.eol();
    }

    private void writeClassEnd() {
        this.writer.append("}").eol();
    }

    private void writeImports() {
        for (String importType : this.importTypes) {
            this.writer.append("import %s;", importType).eol();
        }
        this.writer.eol();
    }

    private void writePackage() {
        this.writer.append("package %s;", this.destPackage).eol().eol();
    }

    private Writer createFileWriter() throws IOException {
        JavaFileObject jfo = this.processingContext.createWriter(this.destPackage + ".Q" + this.shortName, this.element);
        return jfo.openWriter();
    }
}

