/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.querybean.generator;

import io.ebean.querybean.generator.Constants;
import io.ebean.querybean.generator.ProcessingContext;
import io.ebean.querybean.generator.SimpleModuleInfoWriter;
import io.ebean.querybean.generator.SimpleQueryBeanWriter;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public class Processor
extends AbstractProcessor
implements Constants {
    private ProcessingContext processingContext;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.processingContext = new ProcessingContext(processingEnv);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add("jakarta.persistence.Entity");
        annotations.add("jakarta.persistence.Embeddable");
        annotations.add("jakarta.persistence.Converter");
        annotations.add("io.ebean.annotation.EbeanComponent");
        annotations.add("io.ebean.config.ModuleInfo");
        return annotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.processingContext.readModuleInfo();
        int count = this.processEntities(roundEnv);
        this.processOthers(roundEnv);
        int loaded = this.processingContext.complete();
        if (roundEnv.processingOver()) {
            this.writeModuleInfoBean();
        }
        if (count > 0) {
            String msg = "Ebean APT generated %s query beans, loaded %s others - META-INF/ebean-generated-info.mf entity-packages: %s";
            this.processingContext.logNote(msg, count, loaded, this.processingContext.getAllEntityPackages());
        }
        return true;
    }

    private int processEntities(RoundEnvironment roundEnv) {
        int count = 0;
        for (Element element : roundEnv.getElementsAnnotatedWith(this.processingContext.embeddableAnnotation())) {
            this.generateQueryBeans(element);
            ++count;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(this.processingContext.entityAnnotation())) {
            this.generateQueryBeans(element);
            ++count;
        }
        return count;
    }

    private void processOthers(RoundEnvironment round) {
        this.processOthers(round, this.processingContext.converterAnnotation());
        this.processOthers(round, this.processingContext.componentAnnotation());
    }

    private void processOthers(RoundEnvironment roundEnv, TypeElement otherType) {
        if (otherType != null) {
            for (Element element : roundEnv.getElementsAnnotatedWith(otherType)) {
                this.processingContext.addOther(element);
            }
        }
    }

    private void writeModuleInfoBean() {
        try {
            new SimpleModuleInfoWriter(this.processingContext).write();
        }
        catch (FilerException e) {
            this.processingContext.logWarn(null, "FilerException trying to write EntityClassRegister: " + String.valueOf(e));
        }
        catch (Throwable e) {
            this.processingContext.logError(null, "Failed to write EntityClassRegister error:" + String.valueOf(e) + " stack:" + Arrays.toString(e.getStackTrace()), new Object[0]);
        }
    }

    private void generateQueryBeans(Element element) {
        try {
            SimpleQueryBeanWriter beanWriter = new SimpleQueryBeanWriter((TypeElement)element, this.processingContext);
            beanWriter.writeRootBean();
        }
        catch (Throwable e) {
            this.processingContext.logError(element, "Error generating query beans: " + String.valueOf(e), new Object[0]);
        }
    }
}

