/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.container.ContainerConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public abstract class BaseConfig
implements ContainerConfig {
    protected final String platform;
    protected String containerName;
    protected String port;
    protected String internalPort;
    protected String image;
    protected String startMode = "create";
    protected String stopMode = "stop";
    protected String shutdownMode;
    protected String characterSet;
    protected String collation;
    protected int maxReadyAttempts = 300;
    protected String docker = "docker";

    BaseConfig(String platform, String port, String internalPort, String version) {
        this.platform = platform;
        this.port = port;
        this.internalPort = internalPort;
        this.containerName = "ut_" + platform;
        this.image = platform + ":" + version;
    }

    @Override
    public String startDescription() {
        return "starting " + this.platform + " container:" + this.containerName + " port:" + this.port + " startMode:" + this.startMode;
    }

    @Override
    public String stopDescription() {
        return "stopping " + this.platform + " container:" + this.containerName + " stopMode:" + this.stopMode;
    }

    @Override
    public String platform() {
        return this.platform;
    }

    @Override
    public String containerName() {
        return this.containerName;
    }

    @Override
    public void setStartMode(String startMode) {
        this.startMode = startMode;
    }

    @Override
    public void setStopMode(String stopMode) {
        this.stopMode = stopMode;
    }

    @Override
    public void setShutdownMode(String shutdownMode) {
        this.shutdownMode = shutdownMode;
    }

    @Override
    public Connection createConnection() throws SQLException {
        throw new IllegalStateException("Not valid for this type");
    }

    @Override
    public Connection createAdminConnection() throws SQLException {
        throw new IllegalStateException("Not valid for this type");
    }

    @Override
    public String jdbcUrl() {
        throw new IllegalStateException("Not valid for this type");
    }

    public BaseConfig setProperties(Properties properties) {
        if (properties == null) {
            return this;
        }
        this.docker = properties.getProperty("docker", this.docker);
        this.containerName = this.prop(properties, "containerName", this.containerName);
        this.image = this.prop(properties, "image", this.image);
        this.port = this.prop(properties, "port", this.port);
        this.internalPort = this.prop(properties, "internalPort", this.internalPort);
        this.characterSet = this.prop(properties, "characterSet", this.characterSet);
        this.collation = this.prop(properties, "collation", this.collation);
        this.startMode = properties.getProperty("startMode", this.startMode);
        this.startMode = this.prop(properties, "startMode", this.startMode);
        this.stopMode = properties.getProperty("stopMode", this.stopMode);
        this.stopMode = this.prop(properties, "stopMode", this.stopMode);
        this.shutdownMode = properties.getProperty("shutdown", this.shutdownMode);
        this.shutdownMode = this.prop(properties, "shutdown", this.shutdownMode);
        String maxVal = this.prop(properties, "maxReadyAttempts", null);
        if (maxVal != null) {
            try {
                this.maxReadyAttempts = Integer.parseInt(maxVal);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this;
    }

    protected String prop(Properties properties, String key, String defaultValue) {
        String val = properties.getProperty("ebean.test." + this.platform + "." + key, defaultValue);
        return properties.getProperty(this.platform + "." + key, val);
    }

    public BaseConfig setContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    public BaseConfig setPort(String port) {
        this.port = port;
        return this;
    }

    public BaseConfig setInternalPort(String internalPort) {
        this.internalPort = internalPort;
        return this;
    }

    public BaseConfig setImage(String image) {
        this.image = image;
        return this;
    }

    public BaseConfig setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
        return this;
    }

    public BaseConfig setCollation(String collation) {
        this.collation = collation;
        return this;
    }

    public BaseConfig setMaxReadyAttempts(int maxReadyAttempts) {
        this.maxReadyAttempts = maxReadyAttempts;
        return this;
    }

    public BaseConfig setDocker(String docker) {
        this.docker = docker;
        return this;
    }

    public String getPort() {
        return this.port;
    }

    public String getInternalPort() {
        return this.internalPort;
    }

    public String getImage() {
        return this.image;
    }

    public String getStartMode() {
        return this.startMode;
    }

    public String getStopMode() {
        return this.stopMode;
    }

    public int getMaxReadyAttempts() {
        return this.maxReadyAttempts;
    }

    public String getDocker() {
        return this.docker;
    }

    public String shutdownMode() {
        return this.shutdownMode;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public String getCollation() {
        return this.collation;
    }

    public boolean isExplicitCollation() {
        return this.collation != null || this.characterSet != null;
    }

    public boolean isDefaultCollation() {
        return "default".equals(this.collation);
    }
}

