/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.BaseConfig;
import io.ebean.docker.commands.Commands;
import io.ebean.docker.commands.process.ProcessHandler;
import io.ebean.docker.container.Container;
import io.ebean.docker.container.ContainerConfig;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseContainer
implements Container {
    static final Logger log = LoggerFactory.getLogger(Commands.class);
    protected final BaseConfig config;
    protected final Commands commands;

    BaseContainer(BaseConfig config) {
        this.config = config;
        this.commands = new Commands(config.docker);
    }

    protected abstract ProcessBuilder runProcess();

    @Override
    public ContainerConfig config() {
        return this.config;
    }

    @Override
    public boolean start() {
        return this.shutdownHook(this.logStarted(this.startWithConnectivity()));
    }

    @Override
    public boolean isRunning() {
        return this.commands.isRunning(this.config.containerName());
    }

    public void registerShutdownHook(String mode) {
        Runtime.getRuntime().addShutdownHook(new Hook(mode));
    }

    protected boolean shutdownHook(boolean started) {
        String mode = this.config.shutdownMode();
        if (mode != null && !mode.equalsIgnoreCase("none")) {
            this.registerShutdownHook(mode);
        }
        return started;
    }

    protected boolean startWithConnectivity() {
        this.startIfNeeded();
        if (!this.waitForConnectivity()) {
            log.warn("Container {} failed to start - waiting for connectivity", (Object)this.config.containerName());
            return false;
        }
        return true;
    }

    boolean startIfNeeded() {
        if (this.commands.isRunning(this.config.containerName())) {
            this.checkPort(true);
            this.logRunning();
            return true;
        }
        if (this.commands.isRegistered(this.config.containerName())) {
            this.checkPort(false);
            this.logStart();
            this.commands.start(this.config.containerName());
        } else {
            this.logRun();
            this.runContainer();
        }
        return false;
    }

    private void checkPort(boolean isRunning) {
        String portBindings = this.commands.registeredPortMatch(this.config.containerName(), this.config.getPort());
        if (portBindings != null) {
            String msg = "The existing port bindings [" + portBindings + "] for this docker container [" + this.config.containerName() + "] don't match the configured port [" + this.config.getPort() + "] so it seems the port has changed? Maybe look to remove the container first if you want to use the new port via:";
            if (isRunning) {
                msg = msg + "    docker stop " + this.config.containerName();
            }
            msg = msg + "    docker rm " + this.config.containerName();
            throw new IllegalStateException(msg);
        }
    }

    void runContainer() {
        ProcessHandler.process(this.runProcess());
    }

    boolean logsContain(String match, String clearMatch) {
        return this.commands.logsContain(this.config.containerName(), match, clearMatch);
    }

    List<String> logs() {
        return this.commands.logs(this.config.containerName());
    }

    abstract boolean checkConnectivity();

    boolean waitForConnectivity() {
        log.debug("waitForConnectivity {} ... ", (Object)this.config.containerName());
        for (int i = 0; i < 120; ++i) {
            if (this.checkConnectivity()) {
                return true;
            }
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return false;
    }

    @Override
    public void stop() {
        String mode;
        switch (mode = this.config.getStopMode().toLowerCase().trim()) {
            case "stop": {
                this.stopOnly();
                break;
            }
            case "remove": {
                this.stopRemove();
                break;
            }
            default: {
                this.stopOnly();
            }
        }
    }

    public void stopRemove() {
        this.commands.stopRemove(this.config.containerName());
    }

    @Override
    public void stopOnly() {
        this.commands.stopIfRunning(this.config.containerName());
    }

    protected ProcessBuilder createProcessBuilder(List<String> args) {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(args);
        if (log.isDebugEnabled()) {
            log.debug(String.join((CharSequence)" ", args));
        }
        return pb;
    }

    void logRunning() {
        log.info("Container {} already running with port:{}", (Object)this.config.containerName(), (Object)this.config.getPort());
    }

    void logRun() {
        log.info("Run container {} with port:{}", (Object)this.config.containerName(), (Object)this.config.getPort());
    }

    void logStart() {
        log.info("Start container {} with port:{}", (Object)this.config.containerName(), (Object)this.config.getPort());
    }

    void logNotStarted() {
        log.warn("Failed to start container {} with port {}", (Object)this.config.containerName(), (Object)this.config.getPort());
    }

    void logStarted() {
        log.debug("Container {} ready with port {}", (Object)this.config.containerName(), (Object)this.config.getPort());
    }

    boolean logStarted(boolean started) {
        if (!started) {
            this.logNotStarted();
        } else {
            this.logStarted();
        }
        return started;
    }

    private class Hook
    extends Thread {
        private final String mode;

        Hook(String mode) {
            this.mode = mode;
        }

        @Override
        public void run() {
            if ("remove".equalsIgnoreCase(this.mode)) {
                BaseContainer.this.stopRemove();
            } else {
                BaseContainer.this.stopOnly();
            }
        }
    }
}

