/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.Commands;
import io.ebean.docker.commands.DbConfig;
import io.ebean.docker.commands.DbContainer;
import io.ebean.docker.container.Container;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDbContainer
extends DbContainer
implements Container {
    protected static final Logger log = LoggerFactory.getLogger(Commands.class);

    BaseDbContainer(DbConfig config) {
        super(config);
    }

    @Override
    public boolean startWithCreate() {
        this.startMode = DbContainer.Mode.Create;
        if (this.startIfNeeded() && this.fastStart()) {
            return true;
        }
        if (!this.waitForDatabaseReady()) {
            log.warn("Failed waitForDatabaseReady for container {}", (Object)this.config.containerName());
            return false;
        }
        this.createUser(true);
        this.createDatabase(true);
        this.createDatabaseExtensions();
        if (!this.waitForConnectivity()) {
            log.warn("Failed waiting for connectivity");
            return false;
        }
        return true;
    }

    @Override
    public boolean startWithDropCreate() {
        this.startMode = DbContainer.Mode.DropCreate;
        this.startIfNeeded();
        if (!this.waitForDatabaseReady()) {
            log.warn("Failed waitForDatabaseReady for container {}", (Object)this.config.containerName());
            return false;
        }
        if (!this.dropDatabaseIfExists() || !this.dropUserIfExists()) {
            return false;
        }
        if (!this.createUser(false) || !this.createDatabase(false)) {
            return false;
        }
        this.createDatabaseExtensions();
        if (!this.waitForConnectivity()) {
            log.warn("Failed waiting for connectivity");
            return false;
        }
        return true;
    }

    @Override
    protected boolean isFastStartDatabaseExists() {
        return this.databaseExists(this.dbConfig.getDbName());
    }

    public boolean createUser(boolean checkExists) {
        String extraDbUser = this.getExtraDbUser();
        if (!(!this.defined(extraDbUser) || checkExists && this.userExists(extraDbUser) || this.createUser(extraDbUser, this.getWithDefault(this.dbConfig.getExtraDbPassword(), this.dbConfig.getPassword())))) {
            log.error("Failed to create extra database user " + extraDbUser);
        }
        if (checkExists && this.userExists(this.dbConfig.getUsername())) {
            return true;
        }
        return this.createUser(this.dbConfig.getUsername(), this.dbConfig.getPassword());
    }

    private String getExtraDbUser() {
        String extraUser = this.getWithDefault(this.dbConfig.getExtraDbUser(), this.dbConfig.getExtraDb());
        return extraUser != null && !extraUser.equals(this.dbConfig.getUsername()) ? extraUser : null;
    }

    public boolean createDatabase(boolean checkExists) {
        String extraUser;
        String extraDb = this.dbConfig.getExtraDb();
        if (!(!this.defined(extraDb) || checkExists && this.databaseExists(extraDb) || this.createDatabase(extraDb, extraUser = this.getWithDefault(this.getExtraDbUser(), this.dbConfig.getUsername()), this.dbConfig.getExtraDbInitSqlFile(), this.dbConfig.getExtraDbSeedSqlFile()))) {
            log.error("Failed to create extra database " + extraDb);
        }
        if (checkExists && this.databaseExists(this.dbConfig.getDbName())) {
            return true;
        }
        return this.createDatabase(this.dbConfig.getDbName(), this.dbConfig.getUsername(), this.dbConfig.getInitSqlFile(), this.dbConfig.getSeedSqlFile());
    }

    private String getWithDefault(String value, String defaultValue) {
        return value == null ? defaultValue : value;
    }

    public void createDatabaseExtensions() {
        String dbExtn = this.dbConfig.getExtensions();
        if (this.defined(dbExtn)) {
            if (this.defined(this.dbConfig.getExtraDb())) {
                this.createDatabaseExtensionsFor(dbExtn, this.dbConfig.getExtraDb());
            }
            this.createDatabaseExtensionsFor(dbExtn, this.dbConfig.getDbName());
        }
    }

    protected abstract void createDatabaseExtensionsFor(String var1, String var2);

    public boolean dropDatabaseIfExists() {
        String extraDb = this.dbConfig.getExtraDb();
        if (this.defined(extraDb) && !this.dropDatabaseIfExists(extraDb)) {
            log.error("Failed to drop extra database " + extraDb);
        }
        return this.dropDatabaseIfExists(this.dbConfig.getDbName());
    }

    private boolean dropDatabaseIfExists(String dbName) {
        if (this.databaseExists(dbName)) {
            return this.dropDatabase(dbName);
        }
        return true;
    }

    public boolean dropUserIfExists() {
        String extraDbUser = this.getExtraDbUser();
        if (this.defined(extraDbUser) && !this.dropUserIfExists(extraDbUser)) {
            log.error("Failed to drop extra database user " + extraDbUser);
        }
        return this.dropUserIfExists(this.dbConfig.getUsername());
    }

    private boolean dropUserIfExists(String dbUser) {
        if (!this.userExists(dbUser)) {
            return true;
        }
        return this.dropUser(dbUser);
    }

    @Override
    protected abstract boolean isDatabaseAdminReady();

    public abstract boolean databaseExists(String var1);

    public abstract boolean userExists(String var1);

    protected abstract boolean createUser(String var1, String var2);

    protected abstract boolean createDatabase(String var1, String var2, String var3, String var4);

    @Override
    protected abstract void executeSqlFile(String var1, String var2, String var3);

    protected abstract boolean dropDatabase(String var1);

    protected abstract boolean dropUser(String var1);

    @Override
    public abstract boolean isDatabaseReady();
}

