/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.BaseDbContainer;
import io.ebean.docker.commands.ClickHouseConfig;
import io.ebean.docker.commands.process.ProcessHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ClickHouseContainer
extends BaseDbContainer {
    public static ClickHouseContainer create(String version, Properties properties) {
        return new ClickHouseContainer(new ClickHouseConfig(version, properties));
    }

    ClickHouseContainer(ClickHouseConfig config) {
        super(config);
    }

    @Override
    public boolean userExists(String dbUser) {
        return true;
    }

    @Override
    protected boolean createUser(String user, String pwd) {
        return true;
    }

    @Override
    protected boolean dropUser(String dbUser) {
        return true;
    }

    @Override
    protected void createDatabaseExtensionsFor(String dbExtn, String dbName) {
    }

    @Override
    protected boolean isDatabaseAdminReady() {
        return true;
    }

    @Override
    public boolean databaseExists(String dbName) {
        return this.execute(dbName, this.sqlProcess("SHOW DATABASES"));
    }

    @Override
    protected boolean createDatabase(String dbName, String dbUser, String initSqlFile, String seedSqlFile) {
        return this.hasZeroRows(this.sqlProcess("CREATE DATABASE " + dbName));
    }

    @Override
    protected void executeSqlFile(String dbUser, String dbName, String containerFilePath) {
    }

    @Override
    protected boolean dropDatabase(String dbName) {
        return this.hasZeroRows(this.sqlProcess("DROP DATABASE IF EXISTS " + dbName));
    }

    private boolean hasZeroRows(ProcessBuilder pb) {
        return this.hasZeroRows(ProcessHandler.process(pb).getOutLines());
    }

    private boolean hasZeroRows(List<String> stdOutLines) {
        return stdOutLines.isEmpty();
    }

    @Override
    protected ProcessBuilder runProcess() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker);
        args.add("run");
        args.add("-d");
        args.add("--name");
        args.add(this.config.containerName());
        args.add("--ulimit");
        args.add("nofile=262144:262144");
        args.add("-p");
        args.add(this.config.getPort() + ":" + this.config.getInternalPort());
        args.add(this.config.getImage());
        ProcessBuilder pb = this.createProcessBuilder(args);
        pb.redirectErrorStream(true);
        return pb;
    }

    @Override
    public boolean isDatabaseReady() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return true;
    }

    private ProcessBuilder sqlProcess(String sql) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker);
        args.add("exec");
        args.add("-i");
        args.add(this.config.containerName());
        args.add("clickhouse");
        args.add("client");
        args.add("--query");
        args.add(sql + ";");
        return this.createProcessBuilder(args);
    }
}

