/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.process.ProcessHandler;
import io.ebean.docker.commands.process.ProcessResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Commands {
    private static final Logger log = LoggerFactory.getLogger(Commands.class);
    private final String docker;

    public Commands() {
        this("docker");
    }

    public Commands(String docker) {
        this.docker = docker;
    }

    public void stopIfRunning(String containerName) {
        log.debug("stopIfRunning {}", (Object)containerName);
        if (this.isRunning(containerName)) {
            this.stop(containerName);
        }
    }

    public void stopRemove(String containerName) {
        log.debug("stopRemove {}", (Object)containerName);
        if (this.isRunning(containerName)) {
            this.stop(containerName);
        }
        if (this.isRegistered(containerName)) {
            this.remove(containerName);
        }
    }

    public void remove(String containerName) {
        log.debug("remove {}", (Object)containerName);
        ProcessHandler.command(this.docker, "rm", containerName);
    }

    public void start(String containerName) {
        log.debug("start {}", (Object)containerName);
        ProcessHandler.command(this.docker, "start", containerName);
    }

    public void stop(String containerName) {
        log.debug("stop {}", (Object)containerName);
        ProcessHandler.command(this.docker, "stop", containerName);
    }

    public boolean isRunning(String containerName) {
        return this.running().contains(containerName);
    }

    public boolean isRegistered(String containerName) {
        return this.registered().contains(containerName);
    }

    public boolean logsContain(String containerName, String match) {
        return this.logsContain(containerName, match, null);
    }

    public boolean logsContain(String containerName, String match, String clearMatch) {
        List<String> matchLines = this.logsWithMatch(containerName, match, clearMatch);
        return !matchLines.isEmpty();
    }

    public List<String> logsWithMatch(String containerName, String match, String clearMatch) {
        ProcessResult result = ProcessHandler.matchCommand(match, clearMatch, this.docker, "logs", containerName);
        return result.getOutLines();
    }

    public List<String> logs(String containerName) {
        ProcessResult result = ProcessHandler.command(this.docker, "logs", containerName);
        return result.getOutLines();
    }

    private List<String> running() {
        ProcessResult result = ProcessHandler.command(this.docker, "ps", "--format", "{{.Names}}");
        return result.getOutLines();
    }

    private List<String> registered() {
        ProcessResult result = ProcessHandler.command(this.docker, "ps", "-a", "--format", "{{.Names}}");
        return result.getOutLines();
    }

    public String registeredPortMatch(String containerName, String matchPort) {
        ProcessResult result = ProcessHandler.command(this.docker, "container", "inspect", containerName, "--format={{.HostConfig.PortBindings}}");
        List<String> outLines = result.getOutLines();
        for (String outLine : outLines) {
            if (!outLine.startsWith("map")) continue;
            if (outLine.contains("{ " + matchPort + "}")) {
                return null;
            }
            return outLine;
        }
        return null;
    }

    public boolean logsContain(String containerName, String logMessage, int tail) {
        List<String> lines = this.logs(containerName, tail);
        for (String line : lines) {
            if (!line.contains(logMessage)) continue;
            return true;
        }
        return false;
    }

    public List<String> logs(String containerName, int tail) {
        ProcessResult result = tail > 0 ? ProcessHandler.command(this.docker, "logs", "--tail", Integer.toString(tail), containerName) : ProcessHandler.command(this.docker, "logs", containerName);
        return result.getOutLines();
    }
}

