/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.BaseContainer;
import io.ebean.docker.commands.CommandException;
import io.ebean.docker.commands.DbConfig;
import io.ebean.docker.commands.process.ProcessHandler;
import io.ebean.docker.container.Container;
import java.io.File;
import java.net.URL;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;

abstract class DbContainer
extends BaseContainer
implements Container {
    final DbConfig dbConfig;
    Mode startMode;

    DbContainer(DbConfig config) {
        super(config);
        this.dbConfig = config;
    }

    @Override
    void logRunning() {
        log.info("Container {} running with {} mode:{} shutdown:{}", new Object[]{this.config.containerName(), this.dbConfig.summary(), this.startMode, this.logShutdown()});
    }

    @Override
    void logRun() {
        log.info("Run container {} with {} mode:{} shutdown:{}", new Object[]{this.config.containerName(), this.dbConfig.summary(), this.startMode, this.logShutdown()});
    }

    @Override
    void logStart() {
        log.info("Start container {} with {} mode:{} shutdown:{}", new Object[]{this.config.containerName(), this.dbConfig.summary(), this.startMode, this.logShutdown()});
    }

    private String logShutdown() {
        return this.dbConfig.shutdownMode == null ? "" : this.dbConfig.shutdownMode;
    }

    @Override
    public boolean start() {
        return this.shutdownHook(this.logStarted(this.startForMode()));
    }

    protected boolean startForMode() {
        String mode;
        switch (mode = this.config.getStartMode().toLowerCase().trim()) {
            case "create": {
                return this.startWithCreate();
            }
            case "dropcreate": {
                return this.startWithDropCreate();
            }
            case "container": {
                return this.startContainerOnly();
            }
        }
        return this.startWithCreate();
    }

    public boolean startWithCreate() {
        this.startMode = Mode.Create;
        return this.startWithConnectivity();
    }

    public boolean startWithDropCreate() {
        this.startMode = Mode.DropCreate;
        return this.startWithConnectivity();
    }

    public boolean startContainerOnly() {
        this.startMode = Mode.ContainerOnly;
        this.startIfNeeded();
        if (!this.waitForDatabaseReady()) {
            log.warn("Failed waitForDatabaseReady for container {}", (Object)this.config.containerName());
            return false;
        }
        if (!this.waitForConnectivity()) {
            log.warn("Failed waiting for connectivity for {}", (Object)this.config.containerName());
            return false;
        }
        return true;
    }

    protected boolean fastStart() {
        if (!this.dbConfig.isFastStartMode()) {
            return false;
        }
        try {
            return this.isFastStartDatabaseExists();
        }
        catch (CommandException e) {
            log.debug("failed fast start check - using normal startup");
            return false;
        }
    }

    protected boolean isFastStartDatabaseExists() {
        return false;
    }

    @Override
    protected abstract ProcessBuilder runProcess();

    protected abstract boolean isDatabaseReady();

    protected abstract boolean isDatabaseAdminReady();

    protected void executeSqlFile(String dbUser, String dbName, String containerFilePath) {
        throw new RuntimeException("executeSqlFile is Not implemented for this platform - Postgres only at this stage");
    }

    public boolean waitForDatabaseReady() {
        return this.conditionLoop(this::isDatabaseReady) && this.conditionLoop(this::isDatabaseAdminReady);
    }

    private boolean conditionLoop(BooleanSupplier condition) {
        for (int i = 0; i < this.config.getMaxReadyAttempts(); ++i) {
            try {
                if (condition.getAsBoolean()) {
                    return true;
                }
                this.pause();
                continue;
            }
            catch (CommandException e) {
                this.pause();
            }
        }
        return false;
    }

    private void pause() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    boolean checkConnectivity() {
        return this.checkConnectivity(false);
    }

    boolean checkConnectivity(boolean useAdmin) {
        try {
            log.debug("checkConnectivity on {} ... ", (Object)this.config.containerName);
            Connection connection = useAdmin ? this.config.createAdminConnection() : this.config.createConnection();
            connection.close();
            log.debug("connectivity confirmed for {}", (Object)this.config.containerName);
            return true;
        }
        catch (SQLException e) {
            log.trace("connection failed: " + e.getMessage());
            return false;
        }
    }

    boolean defined(String val) {
        return val != null && !val.trim().isEmpty();
    }

    void runDbSqlFile(String dbName, String dbUser, String sqlFile) {
        File file;
        if (this.defined(sqlFile) && (file = this.getResourceOrFile(sqlFile)) != null) {
            this.runSqlFile(file, dbUser, dbName);
        }
    }

    void runSqlFile(File file, String dbUser, String dbName) {
        if (this.copyFileToContainer(file)) {
            String containerFilePath = "/tmp/" + file.getName();
            this.executeSqlFile(dbUser, dbName, containerFilePath);
        }
    }

    File getResourceOrFile(String sqlFile) {
        File file = new File(sqlFile);
        if (!file.exists()) {
            file = this.checkFileResource(sqlFile);
        }
        if (file == null) {
            log.error("Could not find SQL file. No file exists at location or resource path for: " + sqlFile);
        }
        return file;
    }

    private File checkFileResource(String sqlFile) {
        try {
            File file;
            URL resource;
            if (!sqlFile.startsWith("/")) {
                sqlFile = "/" + sqlFile;
            }
            if ((resource = this.getClass().getResource(sqlFile)) != null && (file = Paths.get(resource.toURI()).toFile()).exists()) {
                return file;
            }
        }
        catch (Exception e) {
            log.error("Failed to obtain File from resource for init SQL file: " + sqlFile, (Throwable)e);
        }
        return null;
    }

    boolean copyFileToContainer(File sourceFile) {
        ProcessBuilder pb = this.copyFileToContainerProcess(sourceFile);
        return this.execute(pb, "Failed to copy file " + sourceFile.getAbsolutePath() + " to container");
    }

    private ProcessBuilder copyFileToContainerProcess(File sourceFile) {
        String dest = this.config.containerName() + ":/tmp/" + sourceFile.getName();
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker);
        args.add("cp");
        args.add(sourceFile.getAbsolutePath());
        args.add(dest);
        return this.createProcessBuilder(args);
    }

    boolean execute(String expectedLine, ProcessBuilder pb) {
        return this.execute(expectedLine, pb, null);
    }

    boolean execute(String expectedLine, ProcessBuilder pb, String errorMessage) {
        List<String> outLines = ProcessHandler.process(pb).getOutLines();
        if (!this.stdoutContains(outLines, expectedLine)) {
            if (errorMessage != null) {
                log.error(errorMessage + " stdOut:" + outLines + " Expected message:" + expectedLine);
            }
            return false;
        }
        return true;
    }

    boolean executeWithout(String errorMatch, ProcessBuilder pb, String errorMessage) {
        List<String> outLines = ProcessHandler.process(pb).getOutLines();
        if (this.stdoutContains(outLines, errorMatch)) {
            log.error(errorMessage + " stdOut:" + outLines);
            return false;
        }
        return true;
    }

    boolean stdoutContains(List<String> outLines, String expectedLine) {
        for (String outLine : outLines) {
            if (!outLine.contains(expectedLine)) continue;
            return true;
        }
        return false;
    }

    boolean execute(ProcessBuilder pb, String errorMessage) {
        List<String> outLines = ProcessHandler.process(pb).getOutLines();
        if (!outLines.isEmpty()) {
            log.error(errorMessage + " stdOut:" + outLines);
            return false;
        }
        return true;
    }

    static enum Mode {
        Create,
        DropCreate,
        ContainerOnly;

    }
}

