/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.Commands;
import io.ebean.docker.commands.DbContainer;
import io.ebean.docker.commands.HanaConfig;
import io.ebean.docker.container.Container;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HanaContainer
extends DbContainer
implements Container {
    private static final Logger log = LoggerFactory.getLogger(Commands.class);
    private final HanaConfig hanaConfig;

    public static HanaContainer create(String version, Properties properties) {
        return new HanaContainer(new HanaConfig(version, properties));
    }

    public HanaContainer(HanaConfig config) {
        super(config);
        this.hanaConfig = config;
        String osName = System.getProperty("os.name").toLowerCase();
        if (!osName.contains("linux")) {
            throw new IllegalStateException("The HANA docker image requires a Linux operating system");
        }
        if (!this.hanaConfig.isAgreeToSapLicense()) {
            throw new IllegalStateException("You must agree to the SAP license (https://www.sap.com/docs/download/cmp/2016/06/sap-hana-express-dev-agmt-and-exhibit.pdf) by setting the property 'hana.agreeToSapLicense' to 'true'");
        }
    }

    @Override
    protected boolean isDatabaseAdminReady() {
        return this.isDatabaseReady();
    }

    @Override
    protected boolean isDatabaseReady() {
        return this.commands.logsContain(this.config.containerName(), "Startup finished!");
    }

    @Override
    public boolean startWithCreate() {
        this.startMode = DbContainer.Mode.Create;
        this.startIfNeeded();
        if (!this.waitForDatabaseReady()) {
            log.warn("Failed waitForDatabaseReady for container {}", (Object)this.config.containerName());
            return false;
        }
        if (!this.createUserIfNotExists()) {
            return false;
        }
        if (!this.waitForConnectivity()) {
            log.warn("Failed waiting for connectivity");
            return false;
        }
        return true;
    }

    @Override
    public boolean startWithDropCreate() {
        this.startMode = DbContainer.Mode.DropCreate;
        this.startIfNeeded();
        if (!this.waitForDatabaseReady()) {
            log.warn("Failed waitForDatabaseReady for container {}", (Object)this.config.containerName());
            return false;
        }
        this.dropUserIfExists();
        if (!this.createUserIfNotExists()) {
            return false;
        }
        if (!this.waitForConnectivity()) {
            log.warn("Failed waiting for connectivity");
            return false;
        }
        return true;
    }

    @Override
    protected ProcessBuilder runProcess() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker);
        args.add("run");
        args.add("-d");
        args.add("-p");
        args.add("3" + this.hanaConfig.getInstanceNumber() + "13:39013");
        args.add("-p");
        args.add(this.config.getPort() + ":" + this.config.getInternalPort());
        args.add("-p");
        args.add("3" + this.hanaConfig.getInstanceNumber() + "41-3" + this.hanaConfig.getInstanceNumber() + "45:39041-39045");
        args.add("-v");
        args.add(this.hanaConfig.getMountsDirectory() + ":/hana/mounts");
        args.add("--ulimit");
        args.add("nofile=1048576:1048576");
        args.add("--sysctl");
        args.add("kernel.shmmax=1073741824");
        args.add("--sysctl");
        args.add("kernel.shmmni=524288");
        args.add("--sysctl");
        args.add("kernel.shmall=8388608");
        args.add("--name");
        args.add(this.config.containerName());
        args.add(this.config.getImage());
        args.add("--passwords-url");
        args.add(this.hanaConfig.getPasswordsUrl().toString());
        if (this.hanaConfig.isAgreeToSapLicense()) {
            args.add("--agree-to-sap-license");
        }
        return this.createProcessBuilder(args);
    }

    private boolean dropUserIfExists() {
        log.info("Drop database user {} if exists", (Object)this.dbConfig.getUsername());
        this.sqlProcess(connection -> {
            if (this.userExists((Connection)connection)) {
                this.runSql((Connection)connection, "drop user " + this.dbConfig.getUsername() + " cascade");
            }
        });
        return true;
    }

    private boolean createUserIfNotExists() {
        log.info("Create database user {} if not exists", (Object)this.dbConfig.getUsername());
        this.sqlProcess(connection -> {
            if (!this.userExists((Connection)connection)) {
                this.runSql((Connection)connection, "create user " + this.dbConfig.getUsername() + " password " + this.dbConfig.getPassword() + " no force_first_password_change");
            }
        });
        return true;
    }

    /*
     * Exception decompiling
     */
    private boolean userExists(Connection connection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean sqlProcess(Consumer<Connection> runner) {
        try (Connection connection = this.config.createAdminConnection();){
            runner.accept(connection);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            log.error("Failed to execute sql", (Throwable)e);
            return false;
        }
    }

    private void runSql(Connection connection, String sql) {
        try (Statement statement = connection.createStatement();){
            log.debug("execute: " + sql);
            statement.execute(sql);
        }
        catch (SQLException e) {
            this.sneakyThrow(e);
        }
    }

    private <E extends Throwable> void sneakyThrow(Throwable t) throws E {
        throw t;
    }
}

