/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.DbContainer;
import io.ebean.docker.commands.MySqlConfig;
import io.ebean.docker.commands.process.ProcessHandler;
import io.ebean.docker.container.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class MySqlContainer
extends DbContainer
implements Container {
    public static MySqlContainer create(String mysqlVersion, Properties properties) {
        return new MySqlContainer(new MySqlConfig(mysqlVersion, properties));
    }

    public MySqlContainer(MySqlConfig config) {
        super(config);
    }

    @Override
    protected boolean isDatabaseReady() {
        return this.commands.logsContain(this.config.containerName(), "mysqld: ready for connections", "Shutting down");
    }

    @Override
    protected boolean isDatabaseAdminReady() {
        return this.execute("Database", this.showDatabases());
    }

    @Override
    public boolean startWithCreate() {
        this.startMode = DbContainer.Mode.Create;
        if (this.startIfNeeded() && this.fastStart()) {
            return true;
        }
        if (!this.waitForDatabaseReady()) {
            log.warn("Failed waitForDatabaseReady for container {}", (Object)this.config.containerName());
            return false;
        }
        this.createDatabase(true);
        this.createUser(true);
        if (!this.waitForConnectivity()) {
            log.warn("Failed waiting for connectivity");
            return false;
        }
        return true;
    }

    @Override
    public boolean startWithDropCreate() {
        this.startMode = DbContainer.Mode.DropCreate;
        this.startIfNeeded();
        if (!this.waitForDatabaseReady()) {
            log.warn("Failed waitForDatabaseReady for container {}", (Object)this.config.containerName());
            return false;
        }
        this.dropDatabaseIfExists();
        this.dropUserIfExists();
        this.createDatabase(true);
        this.createUser(true);
        if (!this.waitForConnectivity()) {
            log.warn("Failed waiting for connectivity");
            return false;
        }
        return true;
    }

    @Override
    protected boolean isFastStartDatabaseExists() {
        return this.databaseExists();
    }

    private void dropDatabaseIfExists() {
        if (this.databaseExists()) {
            log.debug("drop database {}", (Object)this.dbConfig.getDbName());
            this.exec(this.sqlProcess("drop database " + this.dbConfig.getDbName(), false), "Failed to drop database");
        }
    }

    private void dropUserIfExists() {
        if (this.userExists()) {
            log.debug("drop user {}", (Object)this.dbConfig.getUsername());
            this.exec(this.sqlProcess("drop user '" + this.dbConfig.getUsername() + "'@'%'", false), "Failed to drop user");
        }
    }

    public boolean createUser(boolean checkExists) {
        if (checkExists && this.userExists()) {
            return true;
        }
        log.debug("create user {}", (Object)this.dbConfig.getUsername());
        this.createUser(this.dbConfig.getUsername(), this.dbConfig.getPassword());
        return true;
    }

    private void createUser(String dbUser, String dbPassword) {
        ProcessBuilder pb = this.sqlProcess("create user '" + dbUser + "'@'%' identified by '" + dbPassword + "'", false);
        this.exec(pb, "Failed to create user");
        pb = this.sqlProcess("grant all on " + this.dbConfig.getDbName() + ".* to '" + dbUser + "'@'%'", false);
        this.exec(pb, "Failed to create user");
    }

    private void createDatabase(boolean checkExists) {
        if (checkExists && this.databaseExists()) {
            return;
        }
        log.debug("create database {}", (Object)this.dbConfig.getDbName());
        this.exec(this.createDatabase(this.dbConfig.getDbName()), "Failed to create database");
    }

    private void exec(ProcessBuilder pb, String message) {
        this.executeWithout("ERROR", pb, message);
    }

    private boolean userExists() {
        return this.contains(this.dbUserExists(this.dbConfig.getUsername()), this.dbConfig.getUsername());
    }

    private boolean databaseExists() {
        return this.contains(this.dbExists(this.dbConfig.getDbName()), this.dbConfig.getDbName());
    }

    private boolean contains(ProcessBuilder pb, String match) {
        List<String> outLines = ProcessHandler.process(pb).getOutLines();
        return this.stdoutContains(outLines, match);
    }

    private ProcessBuilder createDatabase(String dbName) {
        return this.sqlProcess("create database " + dbName, false);
    }

    private ProcessBuilder showDatabases() {
        return this.sqlProcess("show databases", false);
    }

    private ProcessBuilder dbExists(String dbName) {
        return this.sqlProcess("show databases like '" + dbName + "'", false);
    }

    private ProcessBuilder dbUserExists(String dbUser) {
        return this.sqlProcess("select User from user where User = '" + dbUser + "'", true);
    }

    private ProcessBuilder sqlProcess(String sql, boolean withMysql) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker);
        args.add("exec");
        args.add("-i");
        args.add(this.config.containerName());
        args.add("mysql");
        args.add("-uroot");
        args.add("-p" + this.dbConfig.getAdminPassword());
        if (withMysql) {
            args.add("mysql");
        }
        args.add("-e");
        args.add(sql);
        return this.createProcessBuilder(args);
    }

    @Override
    protected ProcessBuilder runProcess() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker);
        args.add("run");
        args.add("-d");
        args.add("--name");
        args.add(this.config.containerName());
        args.add("-p");
        args.add(this.config.getPort() + ":" + this.config.getInternalPort());
        if (this.defined(this.dbConfig.getAdminPassword())) {
            args.add("-e");
            args.add("MYSQL_ROOT_PASSWORD=" + this.dbConfig.getAdminPassword());
        }
        args.add(this.config.getImage());
        if (!this.config.isDefaultCollation()) {
            if (this.config.isExplicitCollation()) {
                String collation;
                String characterSet = this.config.getCharacterSet();
                if (characterSet != null) {
                    args.add("--character-set-server=" + characterSet);
                }
                if ((collation = this.config.getCollation()) != null) {
                    args.add("--collation-server=" + collation);
                }
            } else {
                args.add("--character-set-server=utf8mb4");
                args.add("--collation-server=utf8mb4_bin");
            }
        }
        return this.createProcessBuilder(args);
    }
}

