/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.Commands;
import io.ebean.docker.commands.DbContainer;
import io.ebean.docker.commands.OracleConfig;
import io.ebean.docker.commands.process.ProcessHandler;
import io.ebean.docker.container.Container;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleContainer
extends DbContainer
implements Container {
    private static final Logger log = LoggerFactory.getLogger(Commands.class);
    private final OracleConfig oracleConfig;
    private int logPosition;

    public static OracleContainer create(String version, Properties properties) {
        return new OracleContainer(new OracleConfig(version, properties));
    }

    public OracleContainer(OracleConfig config) {
        super(config);
        this.oracleConfig = config;
    }

    @Override
    protected ProcessBuilder runProcess() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker);
        args.add("run");
        args.add("-d");
        args.add("--name");
        args.add(this.config.containerName());
        args.add("-p");
        args.add(this.config.getPort() + ":" + this.config.getInternalPort());
        args.add("-p");
        args.add(this.oracleConfig.getApexPort() + ":" + this.oracleConfig.getInternalApexPort());
        args.add(this.config.getImage());
        return this.createProcessBuilder(args);
    }

    @Override
    protected boolean isDatabaseAdminReady() {
        return true;
    }

    @Override
    boolean checkConnectivity() {
        return this.checkConnectivity(true);
    }

    @Override
    void runContainer() {
        log.info("Starting Oracle container, this will take some time ...");
        ProcessHandler.process(this.runProcess());
        this.waitForOracle();
    }

    private void waitForOracle() {
        int totalWaitCount = this.oracleConfig.getStartupWaitMinutes() * 10 * 60;
        for (int i = 0; i < totalWaitCount; ++i) {
            if (this.isOracleReadyViaContainerLogs()) {
                return;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Interrupted - oracle probably not started");
            }
        }
        log.error("Ran out of time waiting for Oracle Database ready - probably not started.  Check via:  docker logs -f ut_oracle");
    }

    private boolean isOracleReadyViaContainerLogs() {
        List<String> currentLogs = this.logs();
        if (!currentLogs.isEmpty()) {
            List<String> extraLogs = currentLogs.subList(this.logPosition, currentLogs.size());
            for (String extraLog : extraLogs) {
                log.info("oracle container> " + extraLog);
                if (!extraLog.contains("Database ready to use.")) continue;
                return true;
            }
            this.logPosition = currentLogs.size();
        }
        return false;
    }

    @Override
    protected boolean isDatabaseReady() {
        return this.logsContain("Database ready to use.", "Database closed");
    }

    @Override
    public boolean startWithCreate() {
        this.startMode = DbContainer.Mode.Create;
        this.startIfNeeded();
        if (!this.waitForDatabaseReady()) {
            log.warn("Failed waitForDatabaseReady for container {}", (Object)this.config.containerName());
            return false;
        }
        if (!this.waitForConnectivity()) {
            log.warn("Failed waiting for connectivity");
            return false;
        }
        return this.createUserIfNeeded();
    }

    @Override
    public boolean startWithDropCreate() {
        this.startMode = DbContainer.Mode.DropCreate;
        this.startIfNeeded();
        if (!this.waitForDatabaseReady()) {
            log.warn("Failed waitForDatabaseReady for container {}", (Object)this.config.containerName());
            return false;
        }
        if (!this.waitForConnectivity()) {
            log.warn("Failed waiting for connectivity");
            return false;
        }
        return this.dropCreateUser();
    }

    private boolean dropCreateUser() {
        log.info("Drop and create database user {}", (Object)this.dbConfig.getUsername());
        this.sqlProcess(connection -> {
            if (this.userExists((Connection)connection)) {
                this.runSql((Connection)connection, "drop user " + this.dbConfig.getUsername() + " cascade");
            }
            this.runSql((Connection)connection, "create user " + this.dbConfig.getUsername() + " identified by " + this.dbConfig.getPassword());
            this.runSql((Connection)connection, "grant connect, resource,  create view, unlimited tablespace to " + this.dbConfig.getUsername());
        });
        return true;
    }

    public boolean createUserIfNeeded() {
        log.info("Create database user {} if not exists", (Object)this.dbConfig.getUsername());
        this.sqlProcess(connection -> {
            if (!this.userExists((Connection)connection)) {
                this.runSql((Connection)connection, "create user " + this.dbConfig.getUsername() + " identified by " + this.dbConfig.getPassword());
                this.runSql((Connection)connection, "grant connect, resource, create view, unlimited tablespace to " + this.dbConfig.getUsername());
            }
        });
        return true;
    }

    private boolean userExists(Connection connection) {
        ResultSet resultSet;
        PreparedStatement statement;
        block5: {
            statement = null;
            resultSet = null;
            String sql = "select count(*) from dba_users where lower(username) = ?";
            log.debug("execute: " + sql);
            statement = connection.prepareStatement(sql);
            statement.setString(1, this.dbConfig.getUsername().toLowerCase());
            resultSet = statement.executeQuery();
            if (!resultSet.next()) break block5;
            int count = resultSet.getInt(1);
            boolean bl = count == 1;
            this.close(resultSet);
            this.close(statement);
            return bl;
        }
        try {
            boolean bl = false;
            this.close(resultSet);
            this.close(statement);
            return bl;
        }
        catch (SQLException e) {
            try {
                throw new IllegalStateException("Failed to execute sql to check if user exists", e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(statement);
                throw throwable;
            }
        }
    }

    private boolean sqlProcess(Consumer<Connection> runner) {
        Connection connection = null;
        try {
            connection = this.config.createAdminConnection();
            runner.accept(connection);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to execute sql", e);
        }
        finally {
            this.close(connection);
        }
    }

    private void runSql(Connection connection, String sql) {
        Statement statement = null;
        try {
            log.debug("execute: " + sql);
            statement = connection.createStatement();
            statement.execute(sql);
            this.close(statement);
        }
        catch (SQLException e) {
            try {
                throw new IllegalStateException("Failed to execute sql", e);
            }
            catch (Throwable throwable) {
                this.close(statement);
                throw throwable;
            }
        }
    }

    private void close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                log.warn("Error closing resultSet", (Throwable)e);
            }
        }
    }

    private void close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                log.warn("Error closing statement", (Throwable)e);
            }
        }
    }

    private void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.warn("Error closing connection", (Throwable)e);
            }
        }
    }
}

