/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.BaseDbContainer;
import io.ebean.docker.commands.PostgresConfig;
import io.ebean.docker.commands.process.ProcessHandler;
import io.ebean.docker.container.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class PostgresContainer
extends BaseDbContainer
implements Container {
    public static PostgresContainer create(String pgVersion, Properties properties) {
        return new PostgresContainer(new PostgresConfig(pgVersion, properties));
    }

    public PostgresContainer(PostgresConfig config) {
        super(config);
    }

    @Override
    protected boolean isDatabaseAdminReady() {
        return this.execute("datname", this.showDatabases());
    }

    @Override
    protected boolean isFastStartDatabaseExists() {
        return this.databaseExists(this.dbConfig.getDbName());
    }

    @Override
    public boolean databaseExists(String dbName) {
        return !this.hasZeroRows(this.databaseExistsFor(dbName));
    }

    @Override
    public boolean userExists(String dbUser) {
        return !this.hasZeroRows(this.roleExistsFor(dbUser));
    }

    @Override
    protected boolean createUser(String user, String pwd) {
        ProcessBuilder pb = this.createRole(user, pwd);
        return this.execute("CREATE ROLE", pb, "Failed to create database user");
    }

    @Override
    protected void executeSqlFile(String dbUser, String dbName, String containerFilePath) {
        ProcessBuilder pb = this.sqlFileProcess(dbUser, dbName, containerFilePath);
        this.executeWithout("ERROR", pb, "Error executing init sql file: " + containerFilePath);
    }

    private ProcessBuilder sqlFileProcess(String dbUser, String dbName, String containerFilePath) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker);
        args.add("exec");
        args.add("-i");
        args.add(this.config.containerName());
        args.add("psql");
        args.add("-U");
        args.add(dbUser);
        args.add("-d");
        args.add(dbName);
        args.add("-f");
        args.add(containerFilePath);
        return this.createProcessBuilder(args);
    }

    @Override
    protected boolean createDatabase(String dbName, String dbUser, String initSqlFile, String seedSqlFile) {
        ProcessBuilder pb = this.createDb(dbName, dbUser);
        if (this.execute("CREATE DATABASE", pb, "Failed to create database with owner")) {
            this.runDbSqlFile(dbName, dbUser, initSqlFile);
            this.runDbSqlFile(dbName, dbUser, seedSqlFile);
            return true;
        }
        return false;
    }

    private String getWithDefault(String value, String defaultValue) {
        return value == null ? defaultValue : value;
    }

    @Override
    protected void createDatabaseExtensionsFor(String dbExtn, String dbName) {
        ArrayList<String> extensions = new ArrayList<String>();
        for (String extension : dbExtn.split(",")) {
            if ((extension = extension.trim()).isEmpty()) continue;
            extensions.add(extension);
        }
        if (!extensions.isEmpty()) {
            ProcessHandler.process(this.createDatabaseExtension(extensions, dbName));
        }
    }

    private ProcessBuilder createDatabaseExtension(List<String> extensions, String dbName) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker);
        args.add("exec");
        args.add("-i");
        args.add(this.config.containerName());
        args.add("psql");
        args.add("-U");
        args.add("postgres");
        args.add("-d");
        args.add(dbName);
        for (String extension : extensions) {
            args.add("-c");
            args.add("create extension if not exists " + extension);
        }
        return this.createProcessBuilder(args);
    }

    @Override
    protected boolean dropDatabase(String dbName) {
        ProcessBuilder pb = this.sqlProcess("drop database if exists " + dbName);
        return this.execute("DROP DATABASE", pb, "Failed to drop database");
    }

    @Override
    protected boolean dropUser(String dbUser) {
        ProcessBuilder pb = this.sqlProcess("drop role if exists " + dbUser);
        return this.execute("DROP ROLE", pb, "Failed to drop database user");
    }

    @Override
    public boolean isDatabaseReady() {
        try {
            return ProcessHandler.process(this.pgIsReady()).success();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private boolean hasZeroRows(ProcessBuilder pb) {
        return this.hasZeroRows(ProcessHandler.process(pb).getOutLines());
    }

    private ProcessBuilder createDb(String dbName, String roleName) {
        return this.sqlProcess("create database " + dbName + " with owner " + roleName);
    }

    private ProcessBuilder createRole(String roleName, String pass) {
        return this.sqlProcess("create role " + roleName + " password '" + pass + "' login createrole");
    }

    private ProcessBuilder roleExistsFor(String roleName) {
        return this.sqlProcess("select rolname from pg_roles where rolname = '" + roleName + "'");
    }

    private ProcessBuilder databaseExistsFor(String dbName) {
        return this.sqlProcess("select 1 from pg_database where datname = '" + dbName + "'");
    }

    private ProcessBuilder showDatabases() {
        return this.sqlProcess("select datname from pg_database");
    }

    private ProcessBuilder sqlProcess(String sql) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker);
        args.add("exec");
        args.add("-i");
        args.add(this.config.containerName());
        args.add("psql");
        args.add("-U");
        args.add("postgres");
        args.add("-c");
        args.add(sql);
        return this.createProcessBuilder(args);
    }

    @Override
    protected ProcessBuilder runProcess() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker);
        args.add("run");
        args.add("-d");
        args.add("--name");
        args.add(this.config.containerName());
        args.add("-p");
        args.add(this.config.getPort() + ":" + this.config.getInternalPort());
        if (this.dbConfig.isInMemory() && this.dbConfig.getTmpfs() != null) {
            args.add("--tmpfs");
            args.add(this.dbConfig.getTmpfs());
        }
        args.add("-e");
        args.add(this.dbConfig.getAdminPassword());
        args.add(this.config.getImage());
        return this.createProcessBuilder(args);
    }

    private ProcessBuilder pgIsReady() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker);
        args.add("exec");
        args.add("-i");
        args.add(this.config.containerName());
        args.add("pg_isready");
        args.add("-h");
        args.add("localhost");
        args.add("-p");
        args.add(this.config.getInternalPort());
        return this.createProcessBuilder(args);
    }

    private boolean hasZeroRows(List<String> stdOutLines) {
        return this.stdoutContains(stdOutLines, "(0 rows)");
    }
}

