/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.Commands;
import io.ebean.docker.commands.DbContainer;
import io.ebean.docker.commands.SqlServerConfig;
import io.ebean.docker.commands.process.ProcessHandler;
import io.ebean.docker.container.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerContainer
extends DbContainer
implements Container {
    private static final Logger log = LoggerFactory.getLogger(Commands.class);

    public static SqlServerContainer create(String version, Properties properties) {
        return new SqlServerContainer(new SqlServerConfig(version, properties));
    }

    public SqlServerContainer(SqlServerConfig config) {
        super(config);
    }

    @Override
    protected boolean isDatabaseAdminReady() {
        return this.hasOneRows(this.countDatabases());
    }

    @Override
    public boolean startWithCreate() {
        this.startMode = DbContainer.Mode.Create;
        if (this.startIfNeeded() && this.fastStart()) {
            return true;
        }
        if (!this.waitForDatabaseReady()) {
            log.warn("Failed waitForDatabaseReady for container {}", (Object)this.config.containerName());
            return false;
        }
        if (!this.createDatabase(true)) {
            return false;
        }
        if (!this.createLogin(true)) {
            return false;
        }
        if (!this.createUser(true)) {
            return false;
        }
        if (!this.waitForConnectivity()) {
            log.warn("Failed waiting for connectivity");
            return false;
        }
        return true;
    }

    @Override
    public boolean startWithDropCreate() {
        this.startMode = DbContainer.Mode.DropCreate;
        this.startIfNeeded();
        if (!this.waitForDatabaseReady()) {
            log.warn("Failed waitForDatabaseReady for container {}", (Object)this.config.containerName());
            return false;
        }
        this.dropDatabaseIfExists();
        this.dropLoginIfExists();
        if (!this.createDatabase(false)) {
            return false;
        }
        if (!this.createLogin(false)) {
            return false;
        }
        if (!this.createUser(false)) {
            return false;
        }
        if (!this.waitForConnectivity()) {
            log.warn("Failed waiting for connectivity");
            return false;
        }
        return true;
    }

    @Override
    public boolean isFastStartDatabaseExists() {
        return this.databaseExists();
    }

    public boolean databaseExists() {
        return !this.hasZeroRows(this.databaseExists(this.dbConfig.getDbName()));
    }

    public boolean loginExists() {
        return !this.hasZeroRows(this.loginExists(this.dbConfig.getUsername()));
    }

    public boolean userExists() {
        return !this.hasZeroRows(this.userExists(this.dbConfig.getUsername(), this.dbConfig.getDbName()));
    }

    public boolean createLogin(boolean checkExists) {
        if (checkExists && this.loginExists()) {
            return true;
        }
        log.debug("create login {}", (Object)this.dbConfig.getUsername());
        return this.execute(this.createLogin(this.dbConfig.getUsername(), this.dbConfig.getPassword()), "Failed to create DB login");
    }

    public boolean createUser(boolean checkExists) {
        if (checkExists && this.userExists()) {
            return true;
        }
        log.debug("create user {}", (Object)this.dbConfig.getUsername());
        boolean success = this.execute(this.createUser(this.dbConfig.getUsername(), this.dbConfig.getUsername(), this.dbConfig.getDbName()), "Failed to create DB user");
        if (success) {
            success = this.execute(this.grantDbOwner(this.dbConfig.getUsername(), this.dbConfig.getDbName()), "Failed to grant DB owner to user");
        }
        return success;
    }

    public boolean createDatabase(boolean checkExists) {
        if (checkExists && this.databaseExists()) {
            return true;
        }
        log.debug("create database {}", (Object)this.dbConfig.getDbName());
        return this.execute(this.createDatabase(this.dbConfig.getDbName()), "Failed to create DB");
    }

    public boolean dropDatabaseIfExists() {
        if (!this.databaseExists()) {
            return true;
        }
        log.debug("drop database {}", (Object)this.dbConfig.getDbName());
        return this.execute(this.dropDatabase(this.dbConfig.getDbName()), "Failed to drop DB");
    }

    public boolean dropLoginIfExists() {
        if (!this.loginExists()) {
            return true;
        }
        log.debug("drop login {}", (Object)this.dbConfig.getUsername());
        return this.execute(this.dropLogin(this.dbConfig.getUsername()), "Failed to drop DB login");
    }

    @Override
    protected boolean isDatabaseReady() {
        return this.commands.logsContain(this.config.containerName(), "SQL Server is now ready", "Microsoft SQL Server");
    }

    private ProcessBuilder dropDatabase(String dbName) {
        return this.sqlProcess("drop database " + dbName);
    }

    private ProcessBuilder dropUser(String dbUser, String withDb) {
        return this.sqlProcess("drop user " + dbUser, withDb);
    }

    private ProcessBuilder dropLogin(String dbLogin) {
        return this.sqlProcess("drop login " + dbLogin);
    }

    private ProcessBuilder createDatabase(String dbName) {
        return this.sqlProcess("create database " + dbName);
    }

    private ProcessBuilder createLogin(String login, String pass) {
        return this.sqlProcess("create login " + login + " with password = '" + pass + "'");
    }

    private ProcessBuilder createUser(String roleName, String login, String withDb) {
        return this.sqlProcess("create user " + roleName + " for login " + login, withDb);
    }

    private ProcessBuilder grantDbOwner(String roleName, String withDb) {
        return this.sqlProcess("EXEC sp_addrolemember 'db_owner', " + roleName, withDb);
    }

    private ProcessBuilder userExists(String userName, String withDb) {
        return this.sqlProcess("select 1 from sys.database_principals where name = '" + userName + "'", withDb);
    }

    private ProcessBuilder loginExists(String roleName) {
        return this.sqlProcess("select 1 from master.dbo.syslogins where loginname = '" + roleName + "'");
    }

    private ProcessBuilder databaseExists(String dbName) {
        return this.sqlProcess("select 1 from sys.databases where name='" + dbName + "'");
    }

    private ProcessBuilder countDatabases() {
        return this.sqlProcess("select count(*) from sys.databases");
    }

    private ProcessBuilder sqlProcess(String sql) {
        return this.sqlProcess(sql, null);
    }

    private ProcessBuilder sqlProcess(String sql, String withDb) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker);
        args.add("exec");
        args.add("-i");
        args.add(this.config.containerName());
        args.add("/opt/mssql-tools/bin/sqlcmd");
        if (withDb != null) {
            args.add("-d");
            args.add(withDb);
        }
        args.add("-U");
        args.add("sa");
        args.add("-P");
        args.add(this.dbConfig.getAdminPassword());
        args.add("-Q");
        args.add(sql);
        return this.createProcessBuilder(args);
    }

    @Override
    protected ProcessBuilder runProcess() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker);
        args.add("run");
        args.add("-d");
        args.add("--name");
        args.add(this.config.containerName());
        args.add("-p");
        args.add(this.config.getPort() + ":" + this.config.getInternalPort());
        args.add("-e");
        args.add("ACCEPT_EULA=Y");
        args.add("-e");
        args.add("SA_PASSWORD=" + this.dbConfig.getAdminPassword());
        if (!this.config.isDefaultCollation()) {
            if (this.config.isExplicitCollation()) {
                args.add("-e");
                args.add("MSSQL_COLLATION=" + this.dbConfig.getCollation());
            } else {
                args.add("-e");
                args.add("MSSQL_COLLATION=Latin1_General_100_BIN2");
            }
        }
        args.add(this.config.getImage());
        return this.createProcessBuilder(args);
    }

    private boolean hasZeroRows(ProcessBuilder pb) {
        return this.hasZeroRows(ProcessHandler.process(pb).getOutLines());
    }

    private boolean hasOneRows(ProcessBuilder pb) {
        return this.hasOneRows(ProcessHandler.process(pb).getOutLines());
    }

    private boolean hasZeroRows(List<String> stdOutLines) {
        return this.stdoutContains(stdOutLines, "(0 rows affected)");
    }

    private boolean hasOneRows(List<String> stdOutLines) {
        return this.stdoutContains(stdOutLines, "(1 rows affected)");
    }
}

