/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.Commands;
import io.ebean.docker.commands.JdbcBaseDbContainer;
import io.ebean.docker.commands.OracleConfig;
import io.ebean.docker.container.Container;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleContainer
extends JdbcBaseDbContainer
implements Container {
    private static final Logger log = LoggerFactory.getLogger(Commands.class);
    private final OracleConfig oracleConfig;

    public static OracleContainer create(String version, Properties properties) {
        return new OracleContainer(new OracleConfig(version, properties));
    }

    public OracleContainer(OracleConfig config) {
        super(config);
        this.oracleConfig = config;
        this.checkConnectivityUsingAdmin = true;
    }

    @Override
    void createDatabase() {
        this.createRoleAndDatabase(false);
    }

    @Override
    void dropCreateDatabase() {
        this.createRoleAndDatabase(true);
    }

    private void createRoleAndDatabase(boolean withDrop) {
        try (Connection connection = this.config.createAdminConnection();){
            if (withDrop) {
                this.dropUser(connection);
            }
            this.createUser(connection, withDrop);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error when creating database and role", e);
        }
    }

    private void dropUser(Connection connection) {
        if (this.userExists(connection)) {
            this.sqlRun(connection, "alter session set \"_ORACLE_SCRIPT\"=true");
            this.sqlRun(connection, "drop user " + this.dbConfig.getUsername() + " cascade");
        }
    }

    private void createUser(Connection connection, boolean withDrop) {
        if (withDrop || !this.userExists(connection)) {
            if (!withDrop) {
                this.sqlRun(connection, "alter session set \"_ORACLE_SCRIPT\"=true");
            }
            this.sqlRun(connection, "create user " + this.dbConfig.getUsername() + " identified by " + this.dbConfig.getPassword());
            this.sqlRun(connection, "grant connect, resource,  create view, unlimited tablespace to " + this.dbConfig.getUsername());
        }
    }

    private boolean userExists(Connection connection) {
        String sql = "select 1 from dba_users where lower(username) = '" + this.dbConfig.getUsername().toLowerCase() + "'";
        return this.sqlHasRow(connection, sql);
    }

    @Override
    protected ProcessBuilder runProcess() {
        List<String> args = this.dockerRun();
        args.add("-p");
        args.add(this.oracleConfig.getApexPort() + ":" + this.oracleConfig.getInternalApexPort());
        args.add("-e");
        args.add("ORACLE_PWD=" + this.oracleConfig.getAdminPassword());
        args.add(this.config.getImage());
        return this.createProcessBuilder(args);
    }
}

