/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.typequery.generator;

import io.ebean.typequery.generator.GeneratorConfig;
import io.ebean.typequery.generator.asm.Type;
import io.ebean.typequery.generator.asm.tree.FieldNode;
import io.ebean.typequery.generator.read.EntityBeanPropertyReader;
import io.ebean.typequery.generator.write.PropertyType;
import io.ebean.typequery.generator.write.PropertyTypeAssoc;
import io.ebean.typequery.generator.write.PropertyTypeEnum;
import io.ebean.typequery.generator.write.PropertyTypeMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class GenerationMetaData {
    protected final PropertyTypeMap propertyMap = new PropertyTypeMap();
    protected final Map<String, EntityBeanPropertyReader> entityMap = new LinkedHashMap<String, EntityBeanPropertyReader>();
    protected final Map<String, EntityBeanPropertyReader> otherMap = new LinkedHashMap<String, EntityBeanPropertyReader>();
    protected final Map<String, EntityBeanPropertyReader> enumMap = new HashMap<String, EntityBeanPropertyReader>();
    protected final GeneratorConfig config;

    public GenerationMetaData(GeneratorConfig config) {
        this.config = config;
    }

    public Set<String> getLoadedEntities() {
        return this.entityMap.keySet();
    }

    public EntityBeanPropertyReader getSuperClass(String superClassName) {
        EntityBeanPropertyReader superMeta = this.otherMap.get(superClassName);
        if (superMeta == null) {
            superMeta = this.entityMap.get(superClassName);
        }
        return superMeta;
    }

    public PropertyType getPropertyType(FieldNode field, EntityBeanPropertyReader ownerClassMeta) {
        String fieldTypeClassName = Type.getType(field.desc).getClassName();
        PropertyType type = this.propertyMap.getType(fieldTypeClassName);
        if (type != null) {
            return type;
        }
        if (EntityBeanPropertyReader.dbJsonField(field)) {
            return this.propertyMap.getDbJsonType();
        }
        EntityBeanPropertyReader anEnum = this.enumMap.get(fieldTypeClassName);
        if (anEnum != null) {
            fieldTypeClassName = this.deriveClassNameWithInnerClass(fieldTypeClassName);
            return new PropertyTypeEnum(fieldTypeClassName, this.deriveShortName(fieldTypeClassName));
        }
        EntityBeanPropertyReader assocEntity = this.entityMap.get(fieldTypeClassName = this.deriveClassNameWithInnerClass(fieldTypeClassName));
        if (assocEntity != null) {
            String propertyName = "QAssoc" + this.deriveShortName(fieldTypeClassName);
            return new PropertyTypeAssoc(propertyName, this.config.getAssocPackage());
        }
        String collectParamType = this.deriveCollectionParameterType(field.signature);
        assocEntity = this.entityMap.get(collectParamType);
        if (assocEntity != null) {
            String propertyName = "QAssoc" + this.deriveShortName(collectParamType);
            return new PropertyTypeAssoc(propertyName, this.config.getAssocPackage());
        }
        return null;
    }

    protected String deriveCollectionParameterType(String signature) {
        if (signature == null) {
            return null;
        }
        int typeStart = signature.indexOf("<L");
        if (typeStart == -1) {
            return null;
        }
        return this.asDotNotation(signature.substring(typeStart + 2, signature.length() - 3));
    }

    protected String deriveClassNameWithInnerClass(String className) {
        return className.replace('$', '.');
    }

    protected String deriveShortName(String className) {
        int startPos = className.lastIndexOf(46);
        if (startPos == -1) {
            return className;
        }
        return className.substring(startPos + 1);
    }

    public void addAll(Collection<EntityBeanPropertyReader> classMetaData) {
        for (EntityBeanPropertyReader classMeta : classMetaData) {
            this.addClassMeta(classMeta);
        }
    }

    public void addClassMeta(EntityBeanPropertyReader classMeta) {
        String className = this.asDotNotation(classMeta.name);
        if (classMeta.isEnum()) {
            this.enumMap.put(className, classMeta);
        } else if (classMeta.isEntity() || classMeta.isEmbeddable()) {
            this.entityMap.put(className, classMeta);
        } else {
            this.otherMap.put(className, classMeta);
        }
    }

    protected String asDotNotation(String path) {
        return path.replace('/', '.');
    }

    protected Collection<EntityBeanPropertyReader> getAllEntities() {
        return this.entityMap.values();
    }
}

