/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.typequery.generator;

import io.ebean.typequery.generator.GenerationMetaData;
import io.ebean.typequery.generator.GeneratorConfig;
import io.ebean.typequery.generator.read.EntityBeanPropertyReader;
import io.ebean.typequery.generator.read.MetaReader;
import io.ebean.typequery.generator.write.SimpleFinderLinkWriter;
import io.ebean.typequery.generator.write.SimpleFinderWriter;
import io.ebean.typequery.generator.write.SimpleManifestWriter;
import io.ebean.typequery.generator.write.SimpleQueryBeanWriter;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Generator {
    private static final Logger logger = LoggerFactory.getLogger(Generator.class);
    public static final String EBEAN_MODEL = "io.ebean.Model";
    private final GeneratorConfig config;
    private final GenerationMetaData generationMetaData;
    private boolean loadedMetaData;
    private int queryBeanCount;
    private Set<String> finders = new LinkedHashSet<String>();
    private Set<String> finderLinks = new LinkedHashSet<String>();

    public Generator(GeneratorConfig config) {
        this.config = config;
        this.generationMetaData = new GenerationMetaData(config);
    }

    public Set<String> getLoadedEntities() {
        this.loadMetaData();
        return this.generationMetaData.getLoadedEntities();
    }

    public int getQueryBeanCount() {
        return this.queryBeanCount;
    }

    public Set<String> getFinders() {
        return this.finders;
    }

    public Set<String> getFinderLinks() {
        return this.finderLinks;
    }

    public void generateQueryBeans() throws IOException {
        this.generateBeans();
        this.generateManifest();
    }

    public void generateFinders() throws IOException {
        this.loadMetaData();
        for (EntityBeanPropertyReader classMeta : this.generationMetaData.getAllEntities()) {
            if (!classMeta.isEntity()) continue;
            this.generateFinder(classMeta);
        }
    }

    public void modifyEntityBeansAddFinderField() throws IOException {
        this.loadMetaData();
        for (EntityBeanPropertyReader classMeta : this.generationMetaData.getAllEntities()) {
            if (!classMeta.isEntity()) continue;
            this.linkFinder(classMeta);
        }
    }

    protected void generateFinder(EntityBeanPropertyReader classMeta) throws IOException {
        SimpleFinderWriter writer = new SimpleFinderWriter(this.config, classMeta, this.generationMetaData);
        if (writer.write()) {
            logger.debug("... generated finder for {}", (Object)classMeta.name);
            this.finders.add(classMeta.name);
        }
    }

    protected void linkFinder(EntityBeanPropertyReader classMeta) throws IOException {
        SimpleFinderLinkWriter writer = new SimpleFinderLinkWriter(this.config, classMeta);
        if (writer.write()) {
            logger.debug("... added link to finder for {}", (Object)classMeta.name);
            this.finderLinks.add(classMeta.name);
        }
    }

    protected void loadMetaData() {
        if (!this.loadedMetaData) {
            MetaReader reader = new MetaReader(this.config.getClassesDirectory());
            reader.process(this.config.getEntityBeanPackage());
            this.generationMetaData.addAll(reader.getClassMetaData());
            for (EntityBeanPropertyReader classMeta : this.generationMetaData.getAllEntities()) {
                if (classMeta.isEnum()) continue;
                this.loadMappedSuper(classMeta, reader);
            }
            this.loadedMetaData = true;
        }
    }

    protected void generateBeans() throws IOException {
        this.loadMetaData();
        for (EntityBeanPropertyReader classMeta : this.generationMetaData.getAllEntities()) {
            logger.info("generate for {}", (Object)classMeta.name);
            this.generateTypeQueryBeans(classMeta);
        }
    }

    private void loadMappedSuper(EntityBeanPropertyReader classMeta, MetaReader reader) {
        String superClassName = this.asDotNotation(classMeta.getSuperClass());
        if (!"java.lang.Object".equals(superClassName)) {
            EntityBeanPropertyReader superClass = this.generationMetaData.getSuperClass(superClassName);
            if (superClass == null) {
                superClass = this.readViaClassPath(superClassName, reader);
            }
            if (superClass != null) {
                this.loadMappedSuper(superClass, reader);
            }
        }
    }

    private EntityBeanPropertyReader readViaClassPath(String superClassName, MetaReader reader) {
        try {
            if (superClassName.equals(EBEAN_MODEL)) {
                return null;
            }
            EntityBeanPropertyReader classMeta = reader.readViaClassPath(superClassName);
            this.generationMetaData.addClassMeta(classMeta);
            return classMeta;
        }
        catch (IOException e) {
            logger.error("Error trying to read class metadata for " + superClassName, (Throwable)e);
            return null;
        }
    }

    protected String asDotNotation(String path) {
        return path.replace('/', '.');
    }

    protected void generateManifest() throws IOException {
        SimpleManifestWriter writer = new SimpleManifestWriter(this.config);
        writer.write();
    }

    protected void generateTypeQueryBeans(EntityBeanPropertyReader classMeta) throws IOException {
        SimpleQueryBeanWriter writer = new SimpleQueryBeanWriter(this.config, classMeta, this.generationMetaData);
        writer.writeRootBean();
        writer.writeAssocBean();
        ++this.queryBeanCount;
    }
}

