/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.typequery.generator;

import io.ebean.typequery.generator.write.JavaLangAdapter;
import io.ebean.typequery.generator.write.KotlinLangAdapter;
import io.ebean.typequery.generator.write.LangAdapter;
import java.io.IOException;
import java.io.Writer;

public class GeneratorConfig {
    String lang = "java";
    String classesDirectory = "target/classes";
    String entityBeanPackage;
    String destDirectory = "src/main/java";
    String destResourceDirectory = "src/main/resources";
    String destPackage;
    String destAssocPackage;
    String destFinderPackage;
    boolean addFinderWhereMethod = true;
    boolean addFinderTextMethod = true;
    boolean addFinderWherePublic;
    boolean overwriteExistingFinders;
    boolean aopStyle = true;
    int maxPathTraversalDepth = 4;
    LangAdapter languageAdapter = new JavaLangAdapter();

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
        this.languageAdapter = new KotlinLangAdapter();
    }

    public boolean isJava() {
        return "java".equals(this.lang);
    }

    public boolean isKotlin() {
        return "kt".equals(this.lang);
    }

    public String getClassesDirectory() {
        return this.classesDirectory;
    }

    public void setClassesDirectory(String classesDirectory) {
        this.classesDirectory = classesDirectory;
    }

    public String getEntityBeanPackage() {
        return this.entityBeanPackage;
    }

    public void setEntityBeanPackage(String entityBeanPackage) {
        this.entityBeanPackage = entityBeanPackage;
        if (this.destPackage == null) {
            this.setDestPackage(entityBeanPackage + ".query");
        }
    }

    public String getDestDirectory() {
        return this.destDirectory;
    }

    public void setDestDirectory(String destDirectory) {
        this.destDirectory = destDirectory;
    }

    public String getDestResourceDirectory() {
        return this.destResourceDirectory;
    }

    public void setDestResourceDirectory(String destResourceDirectory) {
        this.destResourceDirectory = destResourceDirectory;
    }

    public String getDestPackage() {
        return this.destPackage;
    }

    public void setDestPackage(String destPackage) {
        this.destPackage = destPackage;
        this.destAssocPackage = destPackage + ".assoc";
        if (this.destFinderPackage == null) {
            this.destFinderPackage = this.deriveFinderPackage(destPackage);
        }
    }

    private String deriveFinderPackage(String destPackage) {
        int lastDotPos = destPackage.lastIndexOf(46);
        if (lastDotPos == -1) {
            return destPackage + ".finder";
        }
        return destPackage.substring(0, lastDotPos) + ".finder";
    }

    public String getDestFinderPackage() {
        return this.destFinderPackage;
    }

    public void setDestFinderPackage(String destFinderPackage) {
        this.destFinderPackage = destFinderPackage;
    }

    public boolean isAddFinderWhereMethod() {
        return this.addFinderWhereMethod;
    }

    public void setAddFinderWhereMethod(boolean addFinderWhereMethod) {
        this.addFinderWhereMethod = addFinderWhereMethod;
    }

    public boolean isAddFinderTextMethod() {
        return this.addFinderTextMethod;
    }

    public void setAddFinderTextMethod(boolean addFinderTextMethod) {
        this.addFinderTextMethod = addFinderTextMethod;
    }

    public boolean isAddFinderWherePublic() {
        return this.addFinderWherePublic;
    }

    public void setAddFinderWherePublic(boolean addFinderWherePublic) {
        this.addFinderWherePublic = addFinderWherePublic;
    }

    public boolean isOverwriteExistingFinders() {
        return this.overwriteExistingFinders;
    }

    public void setOverwriteExistingFinders(boolean overwriteExistingFinders) {
        this.overwriteExistingFinders = overwriteExistingFinders;
    }

    public String getAssocPackage() {
        return this.destAssocPackage;
    }

    public int getMaxPathTraversalDepth() {
        return this.maxPathTraversalDepth;
    }

    public void setMaxPathTraversalDepth(int maxPathTraversalDepth) {
        this.maxPathTraversalDepth = maxPathTraversalDepth;
    }

    public boolean isAopStyle() {
        return this.aopStyle;
    }

    public void setAopStyle(boolean aopStyle) {
        this.aopStyle = aopStyle;
    }

    public void appendLangSemiColon(Writer writer) throws IOException {
        if (this.isJava()) {
            writer.append(";");
        }
    }

    public LangAdapter lang() {
        return this.languageAdapter;
    }
}

