/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.typequery.generator.asm.optimizer;

import io.ebean.typequery.generator.asm.AnnotationVisitor;
import io.ebean.typequery.generator.asm.Attribute;
import io.ebean.typequery.generator.asm.FieldVisitor;
import io.ebean.typequery.generator.asm.Label;
import io.ebean.typequery.generator.asm.MethodVisitor;
import io.ebean.typequery.generator.asm.Opcodes;
import io.ebean.typequery.generator.asm.Type;
import io.ebean.typequery.generator.asm.TypePath;
import io.ebean.typequery.generator.asm.commons.Remapper;
import io.ebean.typequery.generator.asm.commons.RemappingMethodAdapter;
import io.ebean.typequery.generator.asm.optimizer.ClassOptimizer;
import java.util.HashMap;

public class MethodOptimizer
extends RemappingMethodAdapter
implements Opcodes {
    private final ClassOptimizer classOptimizer;
    private static final HashMap<String, String[]> BOXING_MAP;

    public MethodOptimizer(ClassOptimizer classOptimizer, int access, String desc, MethodVisitor mv, Remapper remapper) {
        super(327680, access, desc, mv, remapper);
        this.classOptimizer = classOptimizer;
    }

    @Override
    public void visitParameter(String name, int access) {
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        return null;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        return null;
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        return null;
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
    }

    @Override
    public void visitLineNumber(int line, Label start) {
    }

    @Override
    public void visitFrame(int type, int local, Object[] local2, int stack, Object[] stack2) {
    }

    @Override
    public void visitAttribute(Attribute attr) {
    }

    @Override
    public void visitLdcInsn(Object cst) {
        if (!(cst instanceof Type)) {
            super.visitLdcInsn(cst);
            return;
        }
        String ldcName = ((Type)cst).getInternalName();
        String fieldName = "class$" + ldcName.replace('/', '$');
        if (!this.classOptimizer.syntheticClassFields.contains(ldcName)) {
            this.classOptimizer.syntheticClassFields.add(ldcName);
            FieldVisitor fv = this.classOptimizer.syntheticFieldVisitor(4104, fieldName, "Ljava/lang/Class;");
            fv.visitEnd();
        }
        String clsName = this.classOptimizer.clsName;
        this.mv.visitFieldInsn(178, clsName, fieldName, "Ljava/lang/Class;");
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        String[] constructorParams;
        if (opcode == 184 && name.equals("valueOf") && (constructorParams = BOXING_MAP.get(owner + desc)) != null) {
            String type = constructorParams[0];
            String initDesc = constructorParams[1];
            super.visitTypeInsn(187, type);
            super.visitInsn(89);
            super.visitInsn(initDesc == "(J)V" || initDesc == "(D)V" ? 94 : 93);
            super.visitInsn(88);
            super.visitMethodInsn(183, type, "<init>", initDesc, false);
            return;
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    static {
        String[][] boxingNames = new String[][]{{"java/lang/Byte", "(B)V"}, {"java/lang/Short", "(S)V"}, {"java/lang/Character", "(C)V"}, {"java/lang/Integer", "(I)V"}, {"java/lang/Long", "(J)V"}, {"java/lang/Float", "(F)V"}, {"java/lang/Double", "(D)V"}};
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (String[] boxingName : boxingNames) {
            String wrapper = boxingName[0];
            String desc = boxingName[1];
            String boxingMethod = wrapper + '(' + desc.charAt(1) + ")L" + wrapper + ';';
            map.put(boxingMethod, boxingName);
        }
        BOXING_MAP = map;
    }
}

