/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.typequery.generator.read;

import io.ebean.typequery.generator.GenerationMetaData;
import io.ebean.typequery.generator.asm.FieldVisitor;
import io.ebean.typequery.generator.asm.MethodVisitor;
import io.ebean.typequery.generator.asm.tree.AnnotationNode;
import io.ebean.typequery.generator.asm.tree.ClassNode;
import io.ebean.typequery.generator.asm.tree.FieldNode;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityBeanPropertyReader
extends ClassNode {
    protected static final Logger logger = LoggerFactory.getLogger(EntityBeanPropertyReader.class);
    public static final String MAPPEDSUPERCLASS_ANNOTATION = "Ljavax/persistence/MappedSuperclass;";
    public static final String EMBEDDABLE_ANNOTATION = "Ljavax/persistence/Embeddable;";
    public static final String ENTITY_ANNOTATION = "Ljavax/persistence/Entity;";
    public static final String TRANSIENT_ANNOTATION = "Ljavax/persistence/Transient;";
    public static final String DBJSONB_ANNOTATION = "Lio/ebean/annotation/DbJsonB;";
    public static final String DBJSON_ANNOTATION = "Lio/ebean/annotation/DbJson;";
    public static final String ID_ANNOTATION = "Ljavax/persistence/Id;";
    public static final String ENUM = "java/lang/Enum";
    private List<FieldNode> allFields;

    public EntityBeanPropertyReader() {
        super(327680);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.ignoreField(access, name)) {
            return null;
        }
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return null;
    }

    public FieldNode getIdProperty(GenerationMetaData generationMetaData) {
        List<FieldNode> allProperties = this.getAllProperties(generationMetaData);
        for (FieldNode field : allProperties) {
            if (!this.idField(field)) continue;
            return field;
        }
        return null;
    }

    public List<FieldNode> getAllProperties(GenerationMetaData generationMetaData) {
        if (this.allFields == null) {
            this.allFields = new ArrayList<FieldNode>();
            this.addClassProperties(this.allFields, generationMetaData);
        }
        return this.allFields;
    }

    protected void addClassProperties(List<FieldNode> allFields, GenerationMetaData generationMetaData) {
        String superClassName = this.asDotNotation(this.superName);
        if (!"java.lang.Object".equals(superClassName)) {
            EntityBeanPropertyReader superClass = generationMetaData.getSuperClass(superClassName);
            if (superClass == null) {
                if (!superClassName.equals("io.ebean.Model")) {
                    logger.warn("... missing super type {}", (Object)superClassName);
                }
            } else {
                logger.debug("... super type {}", (Object)superClassName);
                superClass.addClassProperties(allFields, generationMetaData);
            }
        }
        for (FieldNode field : this.fields) {
            if (!this.persistentField(field)) continue;
            allFields.add(field);
        }
    }

    protected String asDotNotation(String path) {
        return path.replace('/', '.');
    }

    public static boolean dbJsonField(FieldNode field) {
        return EntityBeanPropertyReader.hasAnnotation(field, DBJSONB_ANNOTATION) || EntityBeanPropertyReader.hasAnnotation(field, DBJSON_ANNOTATION);
    }

    protected boolean persistentField(FieldNode field) {
        return !EntityBeanPropertyReader.hasAnnotation(field, TRANSIENT_ANNOTATION);
    }

    protected boolean idField(FieldNode field) {
        return EntityBeanPropertyReader.hasAnnotation(field, ID_ANNOTATION);
    }

    protected static boolean hasAnnotation(FieldNode field, String annotationDesc) {
        if (field.visibleAnnotations != null) {
            for (AnnotationNode annotation : field.visibleAnnotations) {
                if (!annotation.desc.equals(annotationDesc)) continue;
                return true;
            }
        }
        return false;
    }

    public String getSuperClass() {
        return this.superName;
    }

    public boolean isEnum() {
        return ENUM.equals(this.superName);
    }

    public boolean isEmbeddable() {
        if (this.visibleAnnotations != null) {
            for (AnnotationNode annotation : this.visibleAnnotations) {
                if (!annotation.desc.equals(EMBEDDABLE_ANNOTATION)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEntity() {
        if (this.visibleAnnotations != null) {
            for (AnnotationNode annotation : this.visibleAnnotations) {
                if (!annotation.desc.equals(ENTITY_ANNOTATION)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInterestingClass() {
        if (this.isEnum()) {
            return true;
        }
        if (this.visibleAnnotations != null) {
            for (AnnotationNode annotation : this.visibleAnnotations) {
                if (!annotation.desc.equals(ENTITY_ANNOTATION) && !annotation.desc.equals(EMBEDDABLE_ANNOTATION) && !annotation.desc.equals(MAPPEDSUPERCLASS_ANNOTATION)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean ignoreField(int access, String name) {
        return this.isStaticOrTransient(access) || this.ignoreEbeanInternalFields(name);
    }

    private boolean ignoreEbeanInternalFields(String name) {
        return name.startsWith("_ebean") || name.startsWith("_EBEAN");
    }

    private boolean isStaticOrTransient(int access) {
        return (access & 8) != 0 || (access & 0x80) != 0;
    }
}

