/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.typequery.generator.read;

import io.ebean.typequery.generator.asm.ClassReader;
import io.ebean.typequery.generator.read.EntityBeanPropertyReader;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MetaClassFileReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityBeanPropertyReader readClassViaClassPath(String className) throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream is = classLoader.getResourceAsStream(className.replace('.', '/') + ".class");
        if (is == null) {
            throw new IOException("No resource for " + className);
        }
        try {
            ClassReader cr2 = new ClassReader(is);
            EntityBeanPropertyReader classNode = new EntityBeanPropertyReader();
            cr2.accept(classNode, 0);
            EntityBeanPropertyReader entityBeanPropertyReader = classNode;
            return entityBeanPropertyReader;
        }
        finally {
            is.close();
        }
    }

    public EntityBeanPropertyReader readClassFile(File classFile) throws IOException {
        byte[] classfileBuffer = this.readBytes(classFile);
        ClassReader cr2 = new ClassReader(classfileBuffer);
        EntityBeanPropertyReader classNode = new EntityBeanPropertyReader();
        cr2.accept(classNode, 0);
        return classNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readBytes(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] byArray = this.readBytes(fis);
            return byArray;
        }
    }

    private byte[] readBytes(InputStream is) throws IOException {
        int len;
        BufferedInputStream bis = new BufferedInputStream(is);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        byte[] buf = new byte[1028];
        while ((len = bis.read(buf, 0, buf.length)) > -1) {
            baos.write(buf, 0, len);
        }
        baos.flush();
        baos.close();
        return baos.toByteArray();
    }
}

