/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.typequery.generator.read;

import io.ebean.typequery.generator.read.EntityBeanPropertyReader;
import io.ebean.typequery.generator.read.MetaClassFileReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaReader {
    private static final Logger logger = LoggerFactory.getLogger(MetaReader.class);
    private final MetaClassFileReader classFileReader = new MetaClassFileReader();
    private final List<EntityBeanPropertyReader> classMetaData = new ArrayList<EntityBeanPropertyReader>();
    private final String sourceDirectory;

    public MetaReader(String sourceDirectory) {
        this.sourceDirectory = this.trimSlash(sourceDirectory);
    }

    public List<EntityBeanPropertyReader> getClassMetaData() {
        return this.classMetaData;
    }

    public void process(String packageNames) {
        if (packageNames == null) {
            this.processPackage("", true);
            return;
        }
        for (String pkgName : packageNames.split(",")) {
            String pkg = pkgName.trim().replace('.', '/');
            boolean recurse = false;
            if (pkg.endsWith("**")) {
                recurse = true;
                pkg = pkg.substring(0, pkg.length() - 2);
            } else if (pkg.endsWith("*")) {
                recurse = true;
                pkg = pkg.substring(0, pkg.length() - 1);
            }
            this.processPackage(this.trimSlash(pkg), recurse);
        }
    }

    private void processPackage(String dir, boolean recurse) {
        String dirPath = this.sourceDirectory + "/" + dir;
        File directory = new File(dirPath);
        if (!directory.exists()) {
            File currentDir = new File(".");
            String m = "File not found " + dirPath + "  currentDir:" + currentDir.getAbsolutePath();
            throw new RuntimeException(m);
        }
        this.readDirectory(dir, recurse, directory.listFiles());
    }

    private void readDirectory(String dir, boolean recurse, File[] files) {
        for (File file : files) {
            if (file.isDirectory()) {
                if (!recurse) continue;
                this.processPackage(dir + "/" + file.getName(), true);
                continue;
            }
            if (file.getName().endsWith(".class")) {
                this.readClassMeta(file);
                continue;
            }
            logger.warn("Expecting a .class file but got " + file.getAbsolutePath() + " ... ignoring");
        }
    }

    public EntityBeanPropertyReader readViaClassPath(String superClassName) throws IOException {
        String localClassFile = this.sourceDirectory + "/" + superClassName.replace('.', '/') + ".class";
        File classFile = new File(localClassFile);
        if (classFile.exists()) {
            return this.classFileReader.readClassFile(classFile);
        }
        return this.classFileReader.readClassViaClassPath(superClassName);
    }

    private void readClassMeta(File classFile) {
        try {
            EntityBeanPropertyReader classMeta = this.classFileReader.readClassFile(classFile);
            if (classMeta.isInterestingClass()) {
                logger.info("read class meta data for {}", (Object)classMeta.name);
                this.classMetaData.add(classMeta);
            } else {
                logger.debug("... ignoring class {}", (Object)classMeta.name);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error transforming file " + classFile.getAbsolutePath(), e);
        }
    }

    private String trimSlash(String dir) {
        if (dir.endsWith("/")) {
            return dir.substring(0, dir.length() - 1);
        }
        return dir;
    }
}

