/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.typequery.generator.write;

import io.ebean.typequery.generator.GeneratorConfig;
import io.ebean.typequery.generator.read.EntityBeanPropertyReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFinderLinkWriter {
    protected static final Logger logger = LoggerFactory.getLogger(SimpleFinderLinkWriter.class);
    protected final GeneratorConfig config;
    protected final EntityBeanPropertyReader classMeta;
    protected final String entityBeanPackage;
    protected String finderPackage;
    protected String shortName;
    protected List<String> existingSource = new ArrayList<String>(300);
    protected String newLine = "\n";
    private final String classDefnSpace;
    private final String classDefnBracket;

    public SimpleFinderLinkWriter(GeneratorConfig config, EntityBeanPropertyReader classMeta) {
        this.config = config;
        this.classMeta = classMeta;
        this.entityBeanPackage = config.getEntityBeanPackage();
        this.finderPackage = config.getDestFinderPackage();
        this.shortName = this.deriveShortName(classMeta.name);
        this.classDefnSpace = "class " + this.shortName + " ";
        this.classDefnBracket = "class " + this.shortName + "(";
    }

    public boolean write() throws IOException {
        File file = this.getEntitySourceFile();
        if (!file.exists()) {
            logger.warn("Could not find entity bean source java file {}", (Object)file.getAbsoluteFile());
            return false;
        }
        String searchDefn = this.shortName + "Finder()";
        String finderDefn = this.config.lang().finderDefn(this.shortName);
        if (this.checkForExistingFinder(file, searchDefn)) {
            logger.debug("... existing find field on entity {}", (Object)this.shortName);
            return false;
        }
        FileWriter writer = new FileWriter(file, false);
        boolean addedImport = false;
        boolean addedField = false;
        boolean javaLang = this.config.isJava();
        int size = this.existingSource.size();
        for (int i = 0; i < size; ++i) {
            String sourceLine = this.existingSource.get(i);
            if (!addedImport && sourceLine.startsWith("import ")) {
                writer.append("import ").append(this.finderPackage).append(".").append(this.shortName).append("Finder");
                this.config.appendLangSemiColon(writer);
                writer.append(this.newLine);
                addedImport = true;
            }
            writer.append(sourceLine).append(this.newLine);
            if (addedField || !this.sourceLineContainsClassDefn(sourceLine)) continue;
            writer.append(this.newLine);
            if (javaLang) {
                writer.append("  public static final ").append(finderDefn).append(this.newLine);
            } else {
                writer.append("  ").append(finderDefn).append(this.newLine);
            }
            addedField = true;
        }
        writer.flush();
        writer.close();
        return true;
    }

    boolean sourceLineContainsClassDefn(String sourceLine) {
        return sourceLine.contains(this.classDefnBracket) || sourceLine.contains(this.classDefnSpace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkForExistingFinder(File file, String finderDefn) throws IOException {
        try (FileReader reader = new FileReader(file);){
            if (this.hasExistingFinder(reader, finderDefn)) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    protected boolean hasExistingFinder(Reader reader, String finderDefn) throws IOException {
        String line;
        LineNumberReader lineReader = new LineNumberReader(reader);
        while ((line = lineReader.readLine()) != null) {
            if (line.contains(finderDefn)) {
                return true;
            }
            this.existingSource.add(line);
        }
        return false;
    }

    protected File getEntitySourceFile() throws IOException {
        String destDirectory = this.config.getDestDirectory();
        File destDir = new File(destDirectory);
        String packageAsDir = this.asSlashNotation(this.entityBeanPackage);
        File packageDir = new File(destDir, packageAsDir);
        String fileName = this.shortName + "." + this.config.getLang();
        return new File(packageDir, fileName);
    }

    protected String asSlashNotation(String path) {
        return path.replace('.', '/');
    }

    protected String deriveShortName(String name) {
        int startPos = name.lastIndexOf(47);
        if (startPos == -1) {
            return name;
        }
        return name.substring(startPos + 1);
    }
}

