/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.typequery.generator.write;

import io.ebean.typequery.generator.GenerationMetaData;
import io.ebean.typequery.generator.GeneratorConfig;
import io.ebean.typequery.generator.asm.Type;
import io.ebean.typequery.generator.asm.tree.FieldNode;
import io.ebean.typequery.generator.read.EntityBeanPropertyReader;
import io.ebean.typequery.generator.write.PrimitiveHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFinderWriter {
    protected static final Logger logger = LoggerFactory.getLogger(SimpleFinderWriter.class);
    public static final String NEWLINE = "\n";
    protected final GeneratorConfig config;
    protected final EntityBeanPropertyReader classMeta;
    protected final GenerationMetaData generationMetaData;
    protected String finderPackage;
    protected String shortName;
    protected String idTypeShortName;
    protected FileWriter writer;
    protected Set<String> importTypes = new TreeSet<String>();
    protected boolean addWhereMethod;
    protected boolean addTextMethod;
    protected boolean addPublicMethods;

    public SimpleFinderWriter(GeneratorConfig config, EntityBeanPropertyReader classMeta, GenerationMetaData generationMetaData) {
        this.config = config;
        this.classMeta = classMeta;
        this.generationMetaData = generationMetaData;
        this.finderPackage = config.getDestFinderPackage();
        this.addWhereMethod = config.isAddFinderWhereMethod();
        this.addTextMethod = config.isAddFinderTextMethod();
        this.addPublicMethods = config.isAddFinderWherePublic();
        this.shortName = this.deriveShortName(classMeta.name);
    }

    public boolean write() throws IOException {
        File file = this.createFile();
        if (file.exists() && !this.config.isOverwriteExistingFinders()) {
            logger.debug("... skip existing finder - {}", (Object)file.getAbsoluteFile());
            return false;
        }
        FieldNode idProperty = this.classMeta.getIdProperty(this.generationMetaData);
        if (idProperty == null) {
            return false;
        }
        Type idType = this.idObjectType(idProperty.desc);
        String className = idType.getClassName();
        if (!className.startsWith("java.lang.")) {
            this.importTypes.add(className);
        }
        this.idTypeShortName = this.getShortName(className);
        this.importTypes.add(this.asDotNotation(this.classMeta.name));
        this.importTypes.add("io.ebean.Finder");
        if (this.addWhereMethod) {
            String queryBean = this.config.getDestPackage() + ".Q" + this.shortName;
            this.importTypes.add(queryBean);
        }
        this.writer = this.createFileWriter(file);
        this.writePackage();
        this.writeImports();
        this.writeClass();
        this.writeConstructors();
        this.writeMethods();
        this.writeClassEnd();
        this.writer.flush();
        this.writer.close();
        return true;
    }

    private Type idObjectType(String desc) {
        if (desc.length() == 1) {
            Type primitiveType = Type.getType(desc);
            return PrimitiveHelper.getObjectWrapper(primitiveType);
        }
        return Type.getObjectType(desc.substring(1, desc.length() - 1));
    }

    protected void writeConstructors() throws IOException {
        this.config.lang().finderConstructors(this.writer, this.shortName);
    }

    private String getShortName(String className) {
        int pos = className.lastIndexOf(46);
        return pos == -1 ? className : className.substring(pos + 1);
    }

    protected void writeMethods() throws IOException {
        String modifier = this.getModifier();
        if (this.addWhereMethod) {
            this.config.lang().finderWhere(this.writer, this.shortName, modifier);
            if (this.addTextMethod) {
                this.config.lang().finderText(this.writer, this.shortName, modifier);
            }
        }
    }

    protected String getModifier() {
        return this.addPublicMethods ? "public" : "protected";
    }

    protected void writeClass() throws IOException {
        this.config.lang().finderClass(this.writer, this.shortName, this.idTypeShortName);
        this.writer.append(NEWLINE);
    }

    protected void writeClassEnd() throws IOException {
        this.writer.append("}").append(NEWLINE);
    }

    protected void writeImports() throws IOException {
        for (String importType : this.importTypes) {
            this.writer.append("import ").append(importType);
            this.config.appendLangSemiColon(this.writer);
            this.writer.append(NEWLINE);
        }
        this.writer.append(NEWLINE);
    }

    protected void writePackage() throws IOException {
        this.writer.append("package ").append(this.finderPackage);
        this.config.appendLangSemiColon(this.writer);
        this.writer.append(NEWLINE).append(NEWLINE);
    }

    protected File createFile() throws IOException {
        String packageAsDir;
        String destDirectory = this.config.getDestDirectory();
        File destDir = new File(destDirectory);
        File packageDir = new File(destDir, packageAsDir = this.asSlashNotation(this.finderPackage));
        if (!packageDir.exists() && !packageDir.mkdirs()) {
            logger.error("Failed to create directory [{}] for generated code", (Object)packageDir.getAbsoluteFile());
        }
        String fileName = this.shortName + "Finder." + this.config.getLang();
        return new File(packageDir, fileName);
    }

    protected FileWriter createFileWriter(File dest) throws IOException {
        logger.info("writing {}", (Object)dest.getAbsolutePath());
        return new FileWriter(dest);
    }

    protected String asDotNotation(String path) {
        return path.replace('/', '.');
    }

    protected String asSlashNotation(String path) {
        return path.replace('.', '/');
    }

    protected String deriveShortName(String name) {
        int startPos = name.lastIndexOf(47);
        if (startPos == -1) {
            return name;
        }
        return name.substring(startPos + 1);
    }
}

