/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.typequery.generator.write;

import io.ebean.typequery.generator.GeneratorConfig;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleManifestWriter {
    protected static final Logger logger = LoggerFactory.getLogger(SimpleManifestWriter.class);
    public static final String NEWLINE = "\n";
    public static final String EBEAN_TYPEQUERY_MF = "ebean-typequery.mf";
    public static final String META_INF = "META-INF";
    protected final GeneratorConfig config;

    public SimpleManifestWriter(GeneratorConfig config) {
        this.config = config;
    }

    public void write() throws IOException {
        FileWriter writer = this.createFileWriter();
        writer.append("packages: ");
        writer.append(this.config.getDestPackage());
        writer.append(NEWLINE).append(NEWLINE);
        writer.flush();
        writer.close();
    }

    protected FileWriter createFileWriter() throws IOException {
        String destDirectory = this.config.getDestResourceDirectory();
        File destDir = new File(destDirectory);
        File packageDir = new File(destDir, META_INF);
        if (!packageDir.exists() && !packageDir.mkdirs()) {
            logger.error("Failed to create directory [{}] for ebean-typequery.mf", (Object)packageDir.getAbsoluteFile());
        }
        File dest = new File(packageDir, EBEAN_TYPEQUERY_MF);
        logger.info("writing {}", (Object)dest.getAbsolutePath());
        return new FileWriter(dest, false);
    }
}

