/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.typequery.generator.write;

import io.ebean.typequery.generator.GenerationMetaData;
import io.ebean.typequery.generator.GeneratorConfig;
import io.ebean.typequery.generator.asm.tree.FieldNode;
import io.ebean.typequery.generator.read.EntityBeanPropertyReader;
import io.ebean.typequery.generator.write.PropertyMeta;
import io.ebean.typequery.generator.write.PropertyType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleQueryBeanWriter {
    protected static final Logger logger = LoggerFactory.getLogger(SimpleQueryBeanWriter.class);
    public static final String NEWLINE = "\n";
    protected final GeneratorConfig config;
    protected final EntityBeanPropertyReader classMeta;
    protected final GenerationMetaData generationMetaData;
    protected boolean writingAssocBean;
    protected String destPackage;
    protected String origDestPackage;
    protected String shortName;
    protected String origShortName;
    protected FileWriter writer;
    protected Set<String> importTypes = new TreeSet<String>();
    protected List<PropertyMeta> properties = new ArrayList<PropertyMeta>();

    public SimpleQueryBeanWriter(GeneratorConfig config, EntityBeanPropertyReader classMeta, GenerationMetaData generationMetaData) {
        this.config = config;
        this.classMeta = classMeta;
        this.generationMetaData = generationMetaData;
        this.destPackage = config.getDestPackage();
        this.shortName = this.deriveShortName(classMeta.name);
    }

    protected void gatherPropertyDetails() {
        this.importTypes.add(this.asDotNotation(this.classMeta.name));
        this.importTypes.add("io.ebean.typequery.TQRootBean");
        this.importTypes.add("io.ebean.typequery.TypeQueryBean");
        this.importTypes.add("io.ebean.EbeanServer");
        this.addClassProperties(this.classMeta);
    }

    protected void addClassProperties(EntityBeanPropertyReader classMetaData) {
        List<FieldNode> allProperties = classMetaData.getAllProperties(this.generationMetaData);
        for (FieldNode field : allProperties) {
            PropertyType type = this.generationMetaData.getPropertyType(field, this.classMeta);
            if (type == null) {
                logger.warn("No support for field [" + field.name + "] desc[" + field.desc + "] signature [" + field.signature + "]");
                continue;
            }
            type.addImports(this.importTypes);
            this.properties.add(new PropertyMeta(field.name, type));
        }
    }

    public void writeRootBean() throws IOException {
        this.gatherPropertyDetails();
        if (this.classMeta.isEntity()) {
            this.writer = this.createFileWriter();
            this.writePackage();
            this.writeImports();
            this.writeClass();
            this.writeAlias();
            this.writeFields();
            this.writeConstructors();
            this.writeClassEnd();
            this.writer.flush();
            this.writer.close();
        }
    }

    public void writeAssocBean() throws IOException {
        this.writingAssocBean = true;
        this.origDestPackage = this.destPackage;
        this.destPackage = this.destPackage + ".assoc";
        this.origShortName = this.shortName;
        this.shortName = "Assoc" + this.shortName;
        this.prepareAssocBeanImports();
        this.writer = this.createFileWriter();
        this.writePackage();
        this.writeImports();
        this.writeClass();
        this.writeFields();
        this.writeConstructors();
        this.writeClassEnd();
        this.writer.flush();
        this.writer.close();
    }

    protected void prepareAssocBeanImports() {
        this.importTypes.remove("io.ebean.typequery.TQRootBean");
        this.importTypes.remove("io.ebean.EbeanServer");
        this.importTypes.add("io.ebean.typequery.TQAssocBean");
        if (this.classMeta.isEntity()) {
            this.importTypes.add("io.ebean.typequery.TQProperty");
            this.importTypes.add(this.origDestPackage + ".Q" + this.origShortName);
        }
        if (!this.config.isAopStyle()) {
            this.importTypes.add("io.ebean.typequery.TQPath");
        }
        Iterator<String> importsIterator = this.importTypes.iterator();
        while (importsIterator.hasNext()) {
            String importType = importsIterator.next();
            if (!importType.startsWith(this.destPackage)) continue;
            importsIterator.remove();
        }
    }

    protected void writeConstructors() throws IOException {
        if (this.writingAssocBean) {
            this.writeAssocBeanFetch();
            this.writeAssocBeanConstructor();
        } else {
            this.writeRootBeanConstructor();
        }
    }

    protected void writeRootBeanConstructor() throws IOException {
        this.config.lang().rootBeanConstructor(this.writer, this.shortName);
    }

    protected void writeAssocBeanFetch() throws IOException {
        if (this.classMeta.isEntity()) {
            this.config.lang().fetch(this.writer, this.origShortName);
        }
    }

    protected void writeAssocBeanConstructor() throws IOException {
        this.config.lang().assocBeanConstructor(this.writer, this.shortName);
    }

    protected boolean hasAssocProperties() {
        for (PropertyMeta property : this.properties) {
            if (!property.isAssociation()) continue;
            return true;
        }
        return false;
    }

    protected void writeFields() throws IOException {
        for (PropertyMeta property : this.properties) {
            String typeDefn = property.getTypeDefn(this.shortName, this.writingAssocBean);
            this.config.lang().fieldDefn(this.writer, property.getName(), typeDefn);
            this.writer.append(NEWLINE);
        }
        this.writer.append(NEWLINE);
    }

    protected void writeClass() throws IOException {
        if (this.writingAssocBean) {
            this.writer.append("/**").append(NEWLINE);
            this.writer.append(" * Association query bean for ").append(this.shortName).append(".").append(NEWLINE);
            this.writer.append(" * ").append(NEWLINE);
            this.writer.append(" * THIS IS A GENERATED OBJECT, DO NOT MODIFY THIS CLASS.").append(NEWLINE);
            this.writer.append(" */").append(NEWLINE);
            this.writer.append("@TypeQueryBean").append(NEWLINE);
            this.config.lang().beginAssocClass(this.writer, this.shortName, this.origShortName);
        } else {
            this.writer.append("/**").append(NEWLINE);
            this.writer.append(" * Query bean for ").append(this.shortName).append(".").append(NEWLINE);
            this.writer.append(" * ").append(NEWLINE);
            this.writer.append(" * THIS IS A GENERATED OBJECT, DO NOT MODIFY THIS CLASS.").append(NEWLINE);
            this.writer.append(" */").append(NEWLINE);
            this.writer.append("@TypeQueryBean").append(NEWLINE);
            this.config.lang().beginClass(this.writer, this.shortName);
        }
        this.writer.append(NEWLINE);
    }

    protected void writeAlias() throws IOException {
        if (!this.writingAssocBean) {
            this.config.lang().alias(this.writer, this.shortName);
        }
    }

    protected void writeClassEnd() throws IOException {
        this.writer.append("}").append(NEWLINE);
    }

    protected void writeImports() throws IOException {
        for (String importType : this.importTypes) {
            this.writer.append("import ").append(importType);
            this.config.appendLangSemiColon(this.writer);
            this.writer.append(NEWLINE);
        }
        this.writer.append(NEWLINE);
    }

    protected void writePackage() throws IOException {
        this.writer.append("package ").append(this.destPackage);
        this.config.appendLangSemiColon(this.writer);
        this.writer.append(NEWLINE).append(NEWLINE);
    }

    protected FileWriter createFileWriter() throws IOException {
        String packageAsDir;
        String destDirectory = this.config.getDestDirectory();
        File destDir = new File(destDirectory);
        File packageDir = new File(destDir, packageAsDir = this.asSlashNotation(this.destPackage));
        if (!packageDir.exists() && !packageDir.mkdirs()) {
            logger.error("Failed to create directory [{}] for generated code", (Object)packageDir.getAbsoluteFile());
        }
        String fileName = "Q" + this.shortName + "." + this.config.getLang();
        File dest = new File(packageDir, fileName);
        logger.info("writing {}", (Object)dest.getAbsolutePath());
        return new FileWriter(dest);
    }

    protected String asDotNotation(String path) {
        return path.replace('/', '.');
    }

    protected String asSlashNotation(String path) {
        return path.replace('.', '/');
    }

    protected String deriveShortName(String name) {
        int startPos = name.lastIndexOf(47);
        if (startPos == -1) {
            return name;
        }
        return name.substring(startPos + 1);
    }
}

