/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.schedule;

import io.edurt.datacap.schedule.ScheduledRunnable;
import io.edurt.datacap.schedule.ScheduledTask;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.config.CronTask;
import org.springframework.stereotype.Component;

@Component
public class ScheduledCronRegistrar
implements DisposableBean {
    private final Map<Runnable, ScheduledTask> scheduledTasks = new ConcurrentHashMap<Runnable, ScheduledTask>(16);
    private final TaskScheduler taskScheduler;

    public ScheduledCronRegistrar(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    public TaskScheduler getScheduler() {
        return this.taskScheduler;
    }

    public void addCronTask(Runnable task, String cronExpression) {
        this.addCronTask(new CronTask(task, cronExpression));
    }

    public void addCronTask(CronTask cronTask) {
        if (ObjectUtils.isNotEmpty((Object)cronTask)) {
            Runnable task = cronTask.getRunnable();
            if (this.scheduledTasks.containsKey(task)) {
                this.removeCronTask(task);
            }
            this.scheduledTasks.put(task, this.scheduleCronTask(cronTask));
        }
    }

    public void removeCronTask(Runnable task) {
        ScheduledRunnable sourceScheduledRunnable = (ScheduledRunnable)task;
        Optional<Map.Entry> findScheduledRunnable = this.scheduledTasks.entrySet().stream().filter(v -> {
            ScheduledRunnable targetScheduledRunnable = (ScheduledRunnable)v.getKey();
            return targetScheduledRunnable.getName().equals(sourceScheduledRunnable.getName());
        }).findFirst();
        if (findScheduledRunnable.isPresent()) {
            ((ScheduledTask)findScheduledRunnable.get().getValue()).cancel();
            this.scheduledTasks.remove(findScheduledRunnable.get().getKey());
        }
    }

    public ScheduledTask scheduleCronTask(CronTask cronTask) {
        ScheduledTask scheduledTask = new ScheduledTask();
        scheduledTask.future = this.taskScheduler.schedule(cronTask.getRunnable(), cronTask.getTrigger());
        return scheduledTask;
    }

    public void destroy() {
        for (ScheduledTask task : this.scheduledTasks.values()) {
            task.cancel();
        }
        this.scheduledTasks.clear();
    }
}

