/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.pool2.ObjectPool;
import org.apache.omid.metrics.Meter;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.proto.TSOProto;
import org.apache.omid.tso.Batch;
import org.apache.omid.tso.FatalExceptionHandler;
import org.apache.omid.tso.LowWatermarkWriter;
import org.apache.omid.tso.MonitoringContext;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.PersistEvent;
import org.apache.omid.tso.ReplyProcessor;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReplyProcessorImpl
implements EventHandler<ReplyBatchEvent>,
ReplyProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ReplyProcessorImpl.class);
    private final ExecutorService disruptorExec;
    private final Disruptor<ReplyBatchEvent> disruptor;
    private final RingBuffer<ReplyBatchEvent> replyRing;
    private final ObjectPool<Batch> batchPool;
    @VisibleForTesting
    AtomicLong nextIDToHandle = new AtomicLong();
    @VisibleForTesting
    PriorityQueue<ReplyBatchEvent> futureEvents;
    private final Meter abortMeter;
    private final Meter commitMeter;
    private final Meter timestampMeter;
    private final Meter fenceMeter;
    private final LowWatermarkWriter lowWatermarkWriter;
    private long highestLowWaterMarkSeen;

    @Inject
    ReplyProcessorImpl(@Named(value="ReplyStrategy") WaitStrategy strategy, MetricsRegistry metrics, Panicker panicker, ObjectPool<Batch> batchPool, LowWatermarkWriter lowWatermarkWriter) {
        this.lowWatermarkWriter = lowWatermarkWriter;
        ThreadFactoryBuilder threadFactory = new ThreadFactoryBuilder().setNameFormat("reply-%d");
        this.disruptorExec = Executors.newSingleThreadExecutor(threadFactory.build());
        this.disruptor = new Disruptor(ReplyBatchEvent.EVENT_FACTORY, 4096, (Executor)this.disruptorExec, ProducerType.MULTI, strategy);
        this.disruptor.handleExceptionsWith((ExceptionHandler)new FatalExceptionHandler(panicker));
        this.disruptor.handleEventsWith(new EventHandler[]{this});
        this.replyRing = this.disruptor.start();
        this.batchPool = batchPool;
        this.nextIDToHandle.set(0L);
        this.futureEvents = new PriorityQueue<ReplyBatchEvent>(10, new Comparator<ReplyBatchEvent>(){

            @Override
            public int compare(ReplyBatchEvent replyBatchEvent1, ReplyBatchEvent replyBatchEvent2) {
                return Long.compare(replyBatchEvent1.getBatchSequence(), replyBatchEvent2.getBatchSequence());
            }
        });
        this.abortMeter = metrics.meter(MetricRegistry.name((String)"tso", (String[])new String[]{"aborts"}));
        this.commitMeter = metrics.meter(MetricRegistry.name((String)"tso", (String[])new String[]{"commits"}));
        this.timestampMeter = metrics.meter(MetricRegistry.name((String)"tso", (String[])new String[]{"timestampAllocation"}));
        this.fenceMeter = metrics.meter(MetricRegistry.name((String)"tso", (String[])new String[]{"fences"}));
        LOG.info("ReplyProcessor initialized");
        this.highestLowWaterMarkSeen = -1L;
    }

    @VisibleForTesting
    void handleReplyBatchEvent(ReplyBatchEvent replyBatchEvent) throws Exception {
        Batch batch = replyBatchEvent.getBatch();
        for (int i = 0; i < batch.getNumEvents(); ++i) {
            PersistEvent event = batch.get(i);
            switch (event.getType()) {
                case COMMIT: {
                    this.sendCommitResponse(event.getStartTimestamp(), event.getCommitTimestamp(), event.getChannel(), event.getMonCtx(), event.getNewLowWatermark());
                    break;
                }
                case ABORT: {
                    this.sendAbortResponse(event.getStartTimestamp(), event.getChannel(), event.getMonCtx());
                    break;
                }
                case TIMESTAMP: {
                    this.sendTimestampResponse(event.getStartTimestamp(), event.getChannel(), event.getMonCtx());
                    break;
                }
                case FENCE: {
                    this.sendFenceResponse(event.getStartTimestamp(), event.getCommitTimestamp(), event.getChannel(), event.getMonCtx());
                    break;
                }
                case COMMIT_RETRY: {
                    throw new IllegalStateException("COMMIT_RETRY events must be filtered before this step: " + event);
                }
                default: {
                    throw new IllegalStateException("Event not allowed in Persistent Processor Handler: " + event);
                }
            }
            event.getMonCtx().publish();
        }
        this.batchPool.returnObject((Object)batch);
    }

    private void processWaitingEvents() throws Exception {
        while (!this.futureEvents.isEmpty() && this.futureEvents.peek().getBatchSequence() == this.nextIDToHandle.get()) {
            ReplyBatchEvent e = this.futureEvents.poll();
            this.handleReplyBatchEvent(e);
            this.nextIDToHandle.incrementAndGet();
        }
    }

    public void onEvent(ReplyBatchEvent event, long sequence, boolean endOfBatch) throws Exception {
        if (event.getBatchSequence() > this.nextIDToHandle.get()) {
            this.futureEvents.add(event);
            return;
        }
        this.handleReplyBatchEvent(event);
        this.nextIDToHandle.incrementAndGet();
        this.processWaitingEvents();
    }

    @Override
    public void manageResponsesBatch(long batchSequence, Batch batch) {
        long seq = this.replyRing.next();
        ReplyBatchEvent e = (ReplyBatchEvent)this.replyRing.get(seq);
        ReplyBatchEvent.makeReplyBatch(e, batch, batchSequence);
        this.replyRing.publish(seq);
    }

    @VisibleForTesting
    void updateLowWatermark(Optional<Long> newLowwatermark) {
        if (newLowwatermark.isPresent() && (Long)newLowwatermark.get() > this.highestLowWaterMarkSeen) {
            this.highestLowWaterMarkSeen = (Long)newLowwatermark.get();
            this.lowWatermarkWriter.persistLowWatermark(this.highestLowWaterMarkSeen);
        }
    }

    @Override
    public void sendCommitResponse(long startTimestamp, long commitTimestamp, Channel c, MonitoringContext monCtx, Optional<Long> newLowWatermark) {
        this.updateLowWatermark(newLowWatermark);
        TSOProto.Response.Builder builder = TSOProto.Response.newBuilder();
        TSOProto.CommitResponse.Builder commitBuilder = TSOProto.CommitResponse.newBuilder();
        commitBuilder.setAborted(false).setStartTimestamp(startTimestamp).setCommitTimestamp(commitTimestamp);
        builder.setCommitResponse(commitBuilder.build());
        c.write((Object)builder.build());
        this.commitMeter.mark();
        monCtx.timerStop("reply.processor.commit.latency");
    }

    @Override
    public void sendAbortResponse(long startTimestamp, Channel c, MonitoringContext monCtx) {
        TSOProto.Response.Builder builder = TSOProto.Response.newBuilder();
        TSOProto.CommitResponse.Builder commitBuilder = TSOProto.CommitResponse.newBuilder();
        commitBuilder.setAborted(true);
        commitBuilder.setStartTimestamp(startTimestamp);
        builder.setCommitResponse(commitBuilder.build());
        c.write((Object)builder.build());
        this.abortMeter.mark();
        monCtx.timerStop("reply.processor.abort.latency");
    }

    @Override
    public void sendTimestampResponse(long startTimestamp, Channel c, MonitoringContext monCtx) {
        TSOProto.Response.Builder builder = TSOProto.Response.newBuilder();
        TSOProto.TimestampResponse.Builder respBuilder = TSOProto.TimestampResponse.newBuilder();
        respBuilder.setStartTimestamp(startTimestamp);
        builder.setTimestampResponse(respBuilder.build());
        c.write((Object)builder.build());
        this.timestampMeter.mark();
        monCtx.timerStop("reply.processor.timestamp.latency");
    }

    @Override
    public void sendFenceResponse(long tableID, long fenceTimestamp, Channel c, MonitoringContext monCtx) {
        TSOProto.Response.Builder builder = TSOProto.Response.newBuilder();
        TSOProto.FenceResponse.Builder fenceBuilder = TSOProto.FenceResponse.newBuilder();
        fenceBuilder.setTableId(tableID);
        fenceBuilder.setFenceId(fenceTimestamp);
        builder.setFenceResponse(fenceBuilder.build());
        c.write((Object)builder.build());
        monCtx.timerStop("reply.processor.fence.latency");
        this.fenceMeter.mark();
    }

    @Override
    public void close() {
        LOG.info("Terminating Reply Processor...");
        this.disruptor.halt();
        this.disruptor.shutdown();
        LOG.info("\tReply Processor Disruptor shutdown");
        this.disruptorExec.shutdownNow();
        try {
            this.disruptorExec.awaitTermination(3L, TimeUnit.SECONDS);
            LOG.info("\tReply Processor Disruptor executor shutdown");
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted whilst finishing Reply Processor Disruptor executor");
            Thread.currentThread().interrupt();
        }
        LOG.info("Reply Processor terminated");
    }

    static final class ReplyBatchEvent {
        private Batch batch;
        private long batchSequence;
        static final EventFactory<ReplyBatchEvent> EVENT_FACTORY = new EventFactory<ReplyBatchEvent>(){

            public ReplyBatchEvent newInstance() {
                return new ReplyBatchEvent();
            }
        };

        ReplyBatchEvent() {
        }

        static void makeReplyBatch(ReplyBatchEvent e, Batch batch, long batchSequence) {
            e.batch = batch;
            e.batchSequence = batchSequence;
        }

        Batch getBatch() {
            return this.batch;
        }

        long getBatchSequence() {
            return this.batchSequence;
        }
    }
}

