/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.security;

import java.io.Closeable;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.yarn.server.timeline.security.TimelineAuthenticationFilter;

public class TimelineAuthenticationFilterInitializer
extends FilterInitializer {
    public static final String PREFIX = "yarn.timeline-service.http.authentication.";
    private static final String SIGNATURE_SECRET_FILE = "signature.secret.file";

    public void initFilter(FilterContainer container, Configuration conf) {
        HashMap<String, String> filterConfig = new HashMap<String, String>();
        filterConfig.put("cookie.path", "/");
        for (Map.Entry entry : conf) {
            String name = (String)entry.getKey();
            if (!name.startsWith(PREFIX)) continue;
            String value = conf.get(name);
            name = name.substring(PREFIX.length());
            filterConfig.put(name, value);
        }
        String signatureSecretFile = (String)filterConfig.get(SIGNATURE_SECRET_FILE);
        if (signatureSecretFile != null) {
            FileReader reader = null;
            try {
                StringBuilder secret = new StringBuilder();
                reader = new FileReader(signatureSecretFile);
                int c = ((Reader)reader).read();
                while (c > -1) {
                    secret.append((char)c);
                    c = ((Reader)reader).read();
                }
                filterConfig.put("signature.secret", secret.toString());
            }
            catch (IOException ex) {
                try {
                    throw new RuntimeException("Could not read HTTP signature secret file: " + signatureSecretFile);
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(reader);
                    throw throwable;
                }
            }
            IOUtils.closeStream((Closeable)reader);
        }
        String bindAddress = conf.get("bind.address");
        String principal = (String)filterConfig.get("kerberos.principal");
        if (principal != null) {
            try {
                principal = SecurityUtil.getServerPrincipal((String)principal, (String)bindAddress);
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not resolve Kerberos principal name: " + ex.toString(), ex);
            }
            filterConfig.put("kerberos.principal", principal);
        }
        container.addGlobalFilter("Timeline Authentication Filter", TimelineAuthenticationFilter.class.getName(), filterConfig);
    }
}

