/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.server.audit;

import io.edurt.datacap.server.audit.AuditPlugin;
import io.edurt.datacap.server.common.Response;
import io.edurt.datacap.server.common.State;
import io.edurt.datacap.server.entity.ExecuteEntity;
import io.edurt.datacap.server.entity.PluginAuditEntity;
import io.edurt.datacap.server.entity.SourceEntity;
import io.edurt.datacap.server.repository.PluginAuditRepository;
import io.edurt.datacap.server.repository.SourceRepository;
import io.edurt.datacap.server.security.UserDetailsService;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Optional;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AuditPluginHandler {
    private static final Logger log = LoggerFactory.getLogger(AuditPluginHandler.class);
    private final PluginAuditRepository pluginAuditRepository;
    private final SourceRepository sourceRepository;
    private PluginAuditEntity pluginAudit;

    public AuditPluginHandler(PluginAuditRepository pluginAuditRepository, SourceRepository sourceRepository) {
        this.pluginAuditRepository = pluginAuditRepository;
        this.sourceRepository = sourceRepository;
    }

    @Pointcut(value="@annotation(auditPlugin)")
    public void cut(AuditPlugin auditPlugin) {
    }

    @Before(value="cut(auditPlugin)")
    public void doBefore(AuditPlugin auditPlugin) {
        this.pluginAudit = new PluginAuditEntity();
        this.pluginAudit.setCreateTime(Timestamp.valueOf(LocalDateTime.now()));
    }

    @AfterReturning(pointcut="@annotation(auditPlugin)", returning="jsonResult")
    public void doAfterReturning(JoinPoint joinPoint, AuditPlugin auditPlugin, Response jsonResult) {
        this.handlerPlugin(joinPoint, this.pluginAudit, jsonResult);
    }

    protected void handlerPlugin(JoinPoint joinPoint, PluginAuditEntity pluginAudit, Response jsonResult) {
        try {
            if (jsonResult.getStatus().booleanValue()) {
                pluginAudit.setState(State.SUCCESS);
            } else {
                pluginAudit.setMessage(jsonResult.getMessage().toString());
                pluginAudit.setState(State.FAILURE);
            }
            if (joinPoint.getArgs().length > 0) {
                ExecuteEntity executeEntity = (ExecuteEntity)joinPoint.getArgs()[0];
                pluginAudit.setContent(executeEntity.getContent());
                Optional sourceEntity = this.sourceRepository.findById(Long.valueOf(executeEntity.getName()));
                pluginAudit.setPlugin((SourceEntity)sourceEntity.get());
            }
            pluginAudit.setUser(UserDetailsService.getUser());
            pluginAudit.setEndTime(Timestamp.valueOf(LocalDateTime.now()));
            this.pluginAuditRepository.save(pluginAudit);
        }
        catch (Exception ex) {
            log.error("Audit failed ", (Throwable)ex);
        }
    }
}

