/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.server.common;

import io.edurt.datacap.server.common.ServiceState;
import io.edurt.datacap.server.common.State;

public class Response<T> {
    private Boolean status;
    private Integer code;
    private Object message;
    private T data;

    public static Response success(Object data) {
        Response response = new Response();
        response.code = State.SUCCESS.getCode();
        response.message = State.SUCCESS.getValue();
        response.data = data;
        response.status = true;
        return response;
    }

    public static Response failure(String message) {
        Response response = new Response();
        response.code = State.FAILURE.getCode();
        response.message = message;
        response.status = false;
        return response;
    }

    public static Response failure(ServiceState state) {
        Response response = new Response();
        response.code = state.getCode();
        response.message = state.getValue();
        response.status = false;
        return response;
    }

    public static Response failure(ServiceState state, Object message) {
        Response response = new Response();
        response.code = state.getCode();
        response.message = message;
        response.status = false;
        return response;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public Integer getCode() {
        return this.code;
    }

    public Object getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMessage(Object message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$status = this.getStatus();
        Boolean other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        Object this$message = this.getMessage();
        Object other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        Object $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Response(status=" + this.getStatus() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }

    public Response() {
    }

    public Response(Boolean status, Integer code, Object message, T data) {
        this.status = status;
        this.code = code;
        this.message = message;
        this.data = data;
    }
}

