/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.server.service.impl;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import io.edurt.datacap.server.adapter.PageRequestAdapter;
import io.edurt.datacap.server.body.SharedSourceBody;
import io.edurt.datacap.server.common.JSON;
import io.edurt.datacap.server.common.PluginCommon;
import io.edurt.datacap.server.common.ServiceState;
import io.edurt.datacap.server.entity.PageEntity;
import io.edurt.datacap.server.entity.PluginEntity;
import io.edurt.datacap.server.entity.SourceEntity;
import io.edurt.datacap.server.entity.UserEntity;
import io.edurt.datacap.server.repository.SourceRepository;
import io.edurt.datacap.server.repository.UserRepository;
import io.edurt.datacap.server.security.UserDetailsService;
import io.edurt.datacap.server.service.SourceService;
import io.edurt.datacap.spi.FormatType;
import io.edurt.datacap.spi.Plugin;
import io.edurt.datacap.spi.model.Configure;
import io.edurt.datacap.spi.model.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class SourceServiceImpl
implements SourceService {
    private final SourceRepository sourceRepository;
    private final UserRepository userRepository;
    private final Injector injector;

    public SourceServiceImpl(SourceRepository sourceRepository, UserRepository userRepository, Injector injector) {
        this.sourceRepository = sourceRepository;
        this.userRepository = userRepository;
        this.injector = injector;
    }

    @Override
    public io.edurt.datacap.server.common.Response<SourceEntity> saveOrUpdate(SourceEntity configure) {
        configure.setConfigure(JSON.toJSON(configure.getConfigures()));
        configure.setUser(UserDetailsService.getUser());
        return io.edurt.datacap.server.common.Response.success(this.sourceRepository.save(configure));
    }

    @Override
    public io.edurt.datacap.server.common.Response<PageEntity<SourceEntity>> getAll(int offset, int limit) {
        PageRequest pageable = PageRequestAdapter.of(offset, limit);
        UserEntity user = UserDetailsService.getUser();
        return io.edurt.datacap.server.common.Response.success(PageEntity.build(this.sourceRepository.findAllByUserOrPublishIsTrue(user, (Pageable)pageable)));
    }

    @Override
    public io.edurt.datacap.server.common.Response<Long> delete(Long id) {
        this.sourceRepository.deleteById(id);
        return io.edurt.datacap.server.common.Response.success(id);
    }

    @Override
    public io.edurt.datacap.server.common.Response<Object> testConnection(SourceEntity configure) {
        Optional<Plugin> pluginOptional = PluginCommon.getPluginByNameAndType(this.injector, configure.getType(), configure.getProtocol());
        if (!pluginOptional.isPresent()) {
            return io.edurt.datacap.server.common.Response.failure(ServiceState.PLUGIN_NOT_FOUND);
        }
        Configure _configure = new Configure();
        Plugin plugin = pluginOptional.get();
        _configure.setHost(configure.getHost());
        _configure.setPort(configure.getPort());
        _configure.setUsername(Optional.ofNullable(configure.getUsername()));
        _configure.setPassword(Optional.ofNullable(configure.getPassword()));
        Optional _database = StringUtils.isNotEmpty((CharSequence)configure.getDatabase()) ? Optional.ofNullable(configure.getDatabase()) : Optional.empty();
        _configure.setDatabase(_database);
        _configure.setEnv(Optional.ofNullable(configure.getConfigures()));
        _configure.setSsl(Optional.ofNullable(configure.getSsl()));
        _configure.setFormat(FormatType.JSON);
        plugin.connect(_configure);
        Response response = plugin.execute(plugin.validator());
        plugin.destroy();
        if (response.getIsSuccessful().booleanValue()) {
            return io.edurt.datacap.server.common.Response.success(response);
        }
        return io.edurt.datacap.server.common.Response.failure(ServiceState.PLUGIN_EXECUTE_FAILED, response.getMessage());
    }

    @Override
    public io.edurt.datacap.server.common.Response<SourceEntity> getById(Long id) {
        return io.edurt.datacap.server.common.Response.success(this.sourceRepository.findById(id));
    }

    @Override
    public io.edurt.datacap.server.common.Response<Map<String, List<PluginEntity>>> getPlugins() {
        ConcurrentHashMap pluginMap = new ConcurrentHashMap();
        ((Set)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Plugin>>(){}))).stream().forEach(plugin -> {
            PluginEntity entity = new PluginEntity();
            entity.setName(plugin.name());
            entity.setDescription(plugin.description());
            entity.setType(plugin.type().name());
            ArrayList<PluginEntity> plugins = (ArrayList<PluginEntity>)pluginMap.get(plugin.type().name());
            if (ObjectUtils.isEmpty((Object)plugins)) {
                plugins = new ArrayList<PluginEntity>();
            }
            plugins.add(entity);
            pluginMap.put(plugin.type().name(), plugins);
        });
        return io.edurt.datacap.server.common.Response.success(pluginMap);
    }

    @Override
    public io.edurt.datacap.server.common.Response<Long> count() {
        return io.edurt.datacap.server.common.Response.success(this.sourceRepository.countByUserOrPublishIsTrue(UserDetailsService.getUser()));
    }

    @Override
    public io.edurt.datacap.server.common.Response<Object> shared(SharedSourceBody configure) {
        Optional sourceOptional = this.sourceRepository.findById(configure.getSourceId());
        if (!sourceOptional.isPresent()) {
            return io.edurt.datacap.server.common.Response.failure(ServiceState.SOURCE_NOT_FOUND);
        }
        Optional userOptional = this.userRepository.findById(configure.getUserId());
        if (!userOptional.isPresent()) {
            return io.edurt.datacap.server.common.Response.failure(ServiceState.USER_NOT_FOUND);
        }
        SourceEntity source = (SourceEntity)sourceOptional.get();
        source.setUser((UserEntity)userOptional.get());
        source.setPublish(configure.getPublish());
        return io.edurt.datacap.server.common.Response.success(this.sourceRepository.save(source));
    }
}

