/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugCategory;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.xml.XMLUtil;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class AddMessages {
    private final BugCollection bugCollection;
    private final Document document;

    public AddMessages(BugCollection bugCollection, Document document) {
        this.bugCollection = bugCollection;
        this.document = document;
    }

    public void execute() {
        Iterator elementIter = XMLUtil.selectNodes(this.document, "/BugCollection/BugInstance").iterator();
        Iterator<BugInstance> bugInstanceIter = this.bugCollection.iterator();
        HashSet<String> bugTypeSet = new HashSet<String>();
        HashSet<String> bugCategorySet = new HashSet<String>();
        HashSet<String> bugCodeSet = new HashSet<String>();
        while (elementIter.hasNext() && bugInstanceIter.hasNext()) {
            Element element = (Element)elementIter.next();
            BugInstance bugInstance = bugInstanceIter.next();
            String bugType = bugInstance.getType();
            bugTypeSet.add(bugType);
            BugPattern bugPattern = bugInstance.getBugPattern();
            bugCategorySet.add(bugPattern.getCategory());
            bugCodeSet.add(bugPattern.getAbbrev());
            element.addElement("ShortMessage").addText(bugPattern.getShortDescription());
            element.addElement("LongMessage").addText(bugInstance.getMessage());
            Iterator annElementIter = element.elements().iterator();
            Iterator<BugAnnotation> annIter = bugInstance.annotationIterator();
            while (annElementIter.hasNext() && annIter.hasNext()) {
                Element annElement = (Element)annElementIter.next();
                BugAnnotation ann = annIter.next();
                annElement.addElement("Message").addText(ann.toString());
            }
        }
        this.addBugCategories(bugCategorySet);
        this.addBugPatterns(bugTypeSet);
        this.addBugCodes(bugCodeSet);
    }

    private void addBugCategories(Set<String> bugCategorySet) {
        Element root = this.document.getRootElement();
        for (String category : bugCategorySet) {
            Element element = root.addElement("BugCategory");
            element.addAttribute("category", category);
            Element description = element.addElement("Description");
            description.setText(I18N.instance().getBugCategoryDescription(category));
            BugCategory bc = DetectorFactoryCollection.instance().getBugCategory(category);
            if (bc == null) continue;
            String s = bc.getAbbrev();
            if (s != null) {
                Element abbrev = element.addElement("Abbreviation");
                abbrev.setText(s);
            }
            if ((s = bc.getDetailText()) == null) continue;
            Element details = element.addElement("Details");
            details.setText(s);
        }
    }

    private void addBugCodes(Set<String> bugCodeSet) {
        Element root = this.document.getRootElement();
        for (String bugCode : bugCodeSet) {
            Element element = root.addElement("BugCode");
            element.addAttribute("abbrev", bugCode);
            Element description = element.addElement("Description");
            description.setText(I18N.instance().getBugTypeDescription(bugCode));
        }
    }

    private void addBugPatterns(Set<String> bugTypeSet) {
        Element root = this.document.getRootElement();
        for (String bugType : bugTypeSet) {
            BugPattern bugPattern = DetectorFactoryCollection.instance().lookupBugPattern(bugType);
            if (bugPattern == null) continue;
            Element details = root.addElement("BugPattern");
            details.addAttribute("type", bugType).addAttribute("abbrev", bugPattern.getAbbrev()).addAttribute("category", bugPattern.getCategory());
            details.addElement("ShortDescription").addText(bugPattern.getShortDescription());
            details.addElement("Details").addCDATA(bugPattern.getDetailText());
        }
    }

    @SuppressFBWarnings(value={"DM_EXIT"})
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: " + AddMessages.class.getName() + " <input collection> <output collection>");
            System.exit(1);
        }
        DetectorFactoryCollection.instance();
        String inputFile = args[0];
        String outputFile = args[1];
        Project project = new Project();
        SortedBugCollection inputCollection = new SortedBugCollection(project);
        inputCollection.readXML(inputFile);
        Document document = inputCollection.toDocument();
        AddMessages addMessages = new AddMessages(inputCollection, document);
        addMessages.execute();
        XMLWriter writer = new XMLWriter(new BufferedOutputStream(new FileOutputStream(outputFile)), OutputFormat.createPrettyPrint());
        writer.write(document);
        writer.close();
    }
}

