/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.StackMapAnalyzer;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassMember;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.analysis.MethodInfo;
import edu.umd.cs.findbugs.classfile.engine.bcel.AnalysisFactory;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.internalAnnotations.StaticConstant;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.Util;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.LVTHelper;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.meta.TypeQualifier;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.Type;

public class OpcodeStack
implements Constants2 {
    private static final String JAVA_UTIL_ARRAYS_ARRAY_LIST = "Ljava/util/Arrays$ArrayList;";
    private static final boolean DEBUG;
    private static final boolean DEBUG2;
    @StaticConstant
    static final HashMap<String, String> boxedTypes;
    private List<Item> stack;
    private List<Item> lvValues;
    private final List<Integer> lastUpdate;
    private boolean top;
    private boolean seenTransferOfControl;
    private final boolean useIterativeAnalysis = AnalysisContext.currentAnalysisContext().getBoolProperty(4);
    boolean encountedTop;
    boolean backwardsBranch;
    BitSet exceptionHandlers = new BitSet();
    private boolean jumpInfoChangedByBackwardsBranch;
    private boolean jumpInfoChangedByNewTarget;
    private Map<Integer, List<Item>> jumpEntries = new HashMap<Integer, List<Item>>();
    private Map<Integer, List<Item>> jumpStackEntries = new HashMap<Integer, List<Item>>();
    private BitSet jumpEntryLocations = new BitSet();
    int convertJumpToOneZeroState = 0;
    int convertJumpToZeroOneState = 0;
    int registerTestedFoundToBeNonnegative = -1;
    int zeroOneComing = -1;
    boolean oneMeansNull;
    boolean needToMerge = true;
    private boolean reachOnlyByBranch;
    private String methodName;
    DismantleBytecode v;

    public String toString() {
        if (this.isTop()) {
            return "TOP";
        }
        return this.stack.toString() + "::" + this.lvValues.toString();
    }

    public OpcodeStack() {
        this.stack = new ArrayList<Item>();
        this.lvValues = new ArrayList<Item>();
        this.lastUpdate = new ArrayList<Integer>();
    }

    public boolean hasIncomingBranches(int pc) {
        return this.jumpEntryLocations.get(pc) && this.jumpEntries.get(pc) != null;
    }

    public static String getExceptionSig(DismantleBytecode dbc, CodeException e) {
        if (e.getCatchType() == 0) {
            return "Ljava/lang/Throwable;";
        }
        Constant c = dbc.getConstantPool().getConstant(e.getCatchType());
        if (c instanceof ConstantClass) {
            return "L" + ((ConstantClass)c).getBytes(dbc.getConstantPool()) + ";";
        }
        return "Ljava/lang/Throwable;";
    }

    public void mergeJumps(DismantleBytecode dbc) {
        if (!this.needToMerge) {
            return;
        }
        this.needToMerge = false;
        if (dbc.getPC() == this.zeroOneComing) {
            this.pop();
            this.top = false;
            Item item = new Item("I");
            if (this.oneMeansNull) {
                item.setSpecialKind(20);
            } else {
                item.setSpecialKind(19);
            }
            item.setPC(dbc.getPC() - 8);
            item.setCouldBeZero(true);
            this.push(item);
            this.zeroOneComing = -1;
            if (DEBUG) {
                System.out.println("Updated to " + this);
            }
            return;
        }
        boolean stackUpdated = false;
        if (!(this.isTop() || this.convertJumpToOneZeroState != 3 && this.convertJumpToZeroOneState != 3)) {
            this.pop();
            Item topItem = new Item("I");
            topItem.setCouldBeZero(true);
            this.push(topItem);
            this.convertJumpToZeroOneState = 0;
            this.convertJumpToOneZeroState = 0;
            stackUpdated = true;
        }
        List<Item> jumpEntry = null;
        if (this.jumpEntryLocations.get(dbc.getPC())) {
            jumpEntry = this.jumpEntries.get(dbc.getPC());
        }
        boolean wasReachOnlyByBranch = this.isReachOnlyByBranch();
        if (jumpEntry != null) {
            this.setReachOnlyByBranch(false);
            List<Item> jumpStackEntry = this.jumpStackEntries.get(dbc.getPC());
            if (DEBUG2) {
                if (wasReachOnlyByBranch) {
                    System.out.println("Reached by branch at " + dbc.getPC() + " with " + jumpEntry);
                    if (jumpStackEntry != null) {
                        System.out.println(" and stack " + jumpStackEntry);
                    }
                } else if (!jumpEntry.equals(this.lvValues) || jumpStackEntry != null && !jumpStackEntry.equals(this.stack)) {
                    System.out.println("Merging at " + dbc.getPC() + " with " + jumpEntry);
                    if (jumpStackEntry != null) {
                        System.out.println(" and stack " + jumpStackEntry);
                    }
                }
            }
            if (this.isTop()) {
                this.lvValues = new ArrayList<Item>(jumpEntry);
                if (jumpStackEntry != null) {
                    this.stack = new ArrayList<Item>(jumpStackEntry);
                } else {
                    this.stack.clear();
                }
                this.setTop(false);
                return;
            }
            if (this.isReachOnlyByBranch()) {
                this.setTop(false);
                this.lvValues = new ArrayList<Item>(jumpEntry);
                if (!stackUpdated) {
                    if (jumpStackEntry != null) {
                        this.stack = new ArrayList<Item>(jumpStackEntry);
                    } else {
                        this.stack.clear();
                    }
                }
            } else {
                this.setTop(false);
                this.mergeLists(this.lvValues, jumpEntry, false);
                if (!stackUpdated && jumpStackEntry != null) {
                    this.mergeLists(this.stack, jumpStackEntry, false);
                }
            }
            if (DEBUG) {
                System.out.println(" merged lvValues " + this.lvValues);
            }
        } else if (this.isReachOnlyByBranch() && !stackUpdated) {
            this.stack.clear();
            Item item = null;
            for (CodeException e : dbc.getCode().getExceptionTable()) {
                if (e.getHandlerPC() != dbc.getPC()) continue;
                Item newItem = new Item(OpcodeStack.getExceptionSig(dbc, e));
                item = item == null ? newItem : Item.merge(item, newItem);
            }
            if (item != null) {
                this.push(item);
                this.setReachOnlyByBranch(false);
                this.setTop(false);
            } else {
                this.setTop(true);
            }
        }
    }

    private void setLastUpdate(int reg, int pc) {
        while (this.lastUpdate.size() <= reg) {
            this.lastUpdate.add(0);
        }
        this.lastUpdate.set(reg, pc);
    }

    public int getLastUpdate(int reg) {
        if (this.lastUpdate.size() <= reg) {
            return 0;
        }
        return this.lastUpdate.get(reg);
    }

    public int getNumLastUpdates() {
        return this.lastUpdate.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void sawOpcode(DismantleBytecode dbc, int seen) {
        block148: {
            block149: {
                if (dbc.isRegisterStore()) {
                    this.setLastUpdate(dbc.getRegisterOperand(), dbc.getPC());
                }
                this.precomputation(dbc);
                this.needToMerge = true;
                if (!this.isTop()) break block148;
                this.encountedTop = true;
                if (!OpcodeStack.DEBUG) break block149;
                System.out.printf("%4d: %14s %s%n", new Object[]{dbc.getPC(), OpcodeStack.OPCODE_NAMES[seen], this});
            }
            return;
        }
        try {
            if (seen == 167 && (nextPC = dbc.getPC() + 3) <= dbc.getMaxPC()) {
                prevOpcode1 = dbc.getPrevOpcode(1);
                prevOpcode2 = dbc.getPrevOpcode(2);
                nextOpcode = dbc.getCodeByte(dbc.getPC() + 3);
                if (!(prevOpcode1 != 3 && prevOpcode1 != 4 || prevOpcode2 != 198 && prevOpcode2 != 199 || nextOpcode != 3 && nextOpcode != 4 || prevOpcode1 == nextOpcode)) {
                    v0 = this.oneMeansNull = prevOpcode1 == 3;
                    if (prevOpcode2 != 198) {
                        this.oneMeansNull = this.oneMeansNull == false;
                    }
                    this.zeroOneComing = nextPC + 1;
                    this.convertJumpToZeroOneState = 0;
                    this.convertJumpToOneZeroState = 0;
                }
            }
            switch (seen) {
                case 4: {
                    this.convertJumpToOneZeroState = 1;
                    break;
                }
                case 167: {
                    if (this.convertJumpToOneZeroState == 1 && dbc.getBranchOffset() == 4) {
                        this.convertJumpToOneZeroState = 2;
                        break;
                    }
                    this.convertJumpToOneZeroState = 0;
                    break;
                }
                case 3: {
                    if (this.convertJumpToOneZeroState == 2) {
                        this.convertJumpToOneZeroState = 3;
                        break;
                    }
                    this.convertJumpToOneZeroState = 0;
                    break;
                }
                default: {
                    this.convertJumpToOneZeroState = 0;
                }
            }
            switch (seen) {
                case 3: {
                    this.convertJumpToZeroOneState = 1;
                    break;
                }
                case 167: {
                    if (this.convertJumpToZeroOneState == 1 && dbc.getBranchOffset() == 4) {
                        this.convertJumpToZeroOneState = 2;
                        break;
                    }
                    this.convertJumpToZeroOneState = 0;
                    break;
                }
                case 4: {
                    if (this.convertJumpToZeroOneState == 2) {
                        this.convertJumpToZeroOneState = 3;
                        break;
                    }
                    this.convertJumpToZeroOneState = 0;
                    break;
                }
                default: {
                    this.convertJumpToZeroOneState = 0;
                }
            }
            switch (seen) {
                case 25: {
                    this.pushByLocalObjectLoad(dbc, dbc.getRegisterOperand());
                    break;
                }
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    this.pushByLocalObjectLoad(dbc, seen - 42);
                    break;
                }
                case 24: {
                    this.pushByLocalLoad("D", dbc.getRegisterOperand());
                    break;
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    this.pushByLocalLoad("D", seen - 38);
                    break;
                }
                case 23: {
                    this.pushByLocalLoad("F", dbc.getRegisterOperand());
                    break;
                }
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    this.pushByLocalLoad("F", seen - 34);
                    break;
                }
                case 21: {
                    this.pushByLocalLoad("I", dbc.getRegisterOperand());
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    this.pushByLocalLoad("I", seen - 26);
                    break;
                }
                case 22: {
                    this.pushByLocalLoad("J", dbc.getRegisterOperand());
                    break;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    this.pushByLocalLoad("J", seen - 30);
                    break;
                }
                case 178: {
                    fieldSummary = AnalysisContext.currentAnalysisContext().getFieldSummary();
                    fieldOperand = dbc.getXFieldOperand();
                    if (fieldOperand != null && fieldSummary.isComplete() && !fieldOperand.isPublic() && (item = fieldSummary.getSummary(fieldOperand)) != null) {
                        itm = new Item(item);
                        itm.setLoadedFromField(fieldOperand, 0x7FFFFFFF);
                        itm.setPC(dbc.getPC());
                        this.push(itm);
                        break;
                    }
                    field = FieldAnnotation.fromReferencedField(dbc);
                    i = new Item(dbc.getSigConstantOperand(), field, 0x7FFFFFFF);
                    if ("separator".equals(field.getFieldName()) && "java.io.File".equals(field.getClassName())) {
                        i.setSpecialKind(10);
                    }
                    i.setPC(dbc.getPC());
                    this.push(i);
                    break;
                }
                case 18: 
                case 19: 
                case 20: {
                    cons = dbc.getConstantRefOperand();
                    this.pushByConstant(dbc, cons);
                    break;
                }
                case 193: {
                    this.pop();
                    this.push(new Item("I"));
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 198: 
                case 199: {
                    this.seenTransferOfControl = true;
                    topItem = this.pop();
                    if (seen == 155 || seen == 158) {
                        this.registerTestedFoundToBeNonnegative = Item.access$200(topItem);
                    }
                    if (topItem.valueCouldBeNegative() && (seen == 155 || seen == 158 || seen == 157 || seen == 156)) {
                        specialKind = topItem.getSpecialKind();
                        for (Item item : this.stack) {
                            if (item == null || item.getSpecialKind() != specialKind) continue;
                            item.setSpecialKind(0);
                        }
                        for (Item item : this.lvValues) {
                            if (item == null || item.getSpecialKind() != specialKind) continue;
                            item.setSpecialKind(0);
                        }
                    }
                    this.addJumpValue(dbc.getPC(), dbc.getBranchTarget());
                    break;
                }
                case 170: 
                case 171: {
                    this.seenTransferOfControl = true;
                    this.setReachOnlyByBranch(true);
                    this.pop();
                    this.addJumpValue(dbc.getPC(), dbc.getBranchTarget());
                    pc = dbc.getBranchTarget() - dbc.getBranchOffset();
                    for (int offset : dbc.getSwitchOffsets()) {
                        this.addJumpValue(dbc.getPC(), offset + pc);
                    }
                    break;
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: {
                    this.seenTransferOfControl = true;
                    this.setReachOnlyByBranch(true);
                    this.pop();
                    break;
                }
                case 87: 
                case 194: 
                case 195: {
                    this.pop();
                    break;
                }
                case 179: {
                    this.pop();
                    this.eraseKnowledgeOf(dbc.getXFieldOperand());
                    break;
                }
                case 181: {
                    this.pop(2);
                    this.eraseKnowledgeOf(dbc.getXFieldOperand());
                    break;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: {
                    this.seenTransferOfControl = true;
                    right = this.pop();
                    left = this.pop();
                    lConstant = left.getConstant();
                    rConstant = right.getConstant();
                    takeJump = false;
                    handled = false;
                    if (seen != 166 && seen != 165) ** GOTO lbl182
                    if (!(lConstant != null && rConstant != null && lConstant.equals(rConstant) == false || lConstant != null && right.isNull() != false) && (rConstant == null || !left.isNull())) ** GOTO lbl214
                    handled = true;
                    takeJump = seen == 166;
                    ** GOTO lbl214
lbl182:
                    // 1 sources

                    if (lConstant instanceof Integer && rConstant instanceof Integer) {
                        lC = (Integer)lConstant;
                        rC = (Integer)rConstant;
                        switch (seen) {
                            case 159: {
                                takeJump = lC == rC;
                                handled = true;
                                break;
                            }
                            case 160: {
                                takeJump = lC != rC;
                                handled = true;
                                break;
                            }
                            case 162: {
                                takeJump = lC >= rC;
                                handled = true;
                                break;
                            }
                            case 163: {
                                takeJump = lC > rC;
                                handled = true;
                                break;
                            }
                            case 164: {
                                takeJump = lC <= rC;
                                handled = true;
                                break;
                            }
                            case 161: {
                                takeJump = lC < rC;
                                handled = true;
                                break;
                            }
                            default: {
                                if (!OpcodeStack.$assertionsDisabled) {
                                    throw new AssertionError();
                                }
                                break;
                            }
                        }
                    }
lbl214:
                    // 11 sources

                    if (handled) {
                        if (!takeJump) break;
                        branchTarget = dbc.getBranchTarget();
                        this.addJumpValue(dbc.getPC(), branchTarget);
                        this.setTop(true);
                        break;
                    }
                    if (right.hasConstantValue(-2147483648) && left.mightRarelyBeNegative() || left.hasConstantValue(-2147483648) && right.mightRarelyBeNegative()) {
                        for (Item i : this.stack) {
                            if (i == null || !i.mightRarelyBeNegative()) continue;
                            i.setSpecialKind(0);
                        }
                        for (Item i : this.lvValues) {
                            if (i == null || !i.mightRarelyBeNegative()) continue;
                            i.setSpecialKind(0);
                        }
                    }
                    branchTarget = dbc.getBranchTarget();
                    this.addJumpValue(dbc.getPC(), branchTarget);
                    break;
                }
                case 88: {
                    it = this.pop();
                    if (it.getSize() != 1) break;
                    this.pop();
                    break;
                }
                case 46: 
                case 53: {
                    this.pop(2);
                    this.push(new Item("I"));
                    break;
                }
                case 89: {
                    this.handleDup();
                    break;
                }
                case 92: {
                    this.handleDup2();
                    break;
                }
                case 90: {
                    this.handleDupX1();
                    break;
                }
                case 91: {
                    this.handleDupX2();
                    break;
                }
                case 93: {
                    this.handleDup2X1();
                    break;
                }
                case 94: {
                    this.handleDup2X2();
                    break;
                }
                case 132: {
                    register = dbc.getRegisterOperand();
                    it = this.getLVValue(register);
                    it2 = new Item("I", dbc.getIntConstant());
                    this.pushByIntMath(dbc, 96, it2, it);
                    this.pushByLocalStore(register);
                    break;
                }
                case 191: {
                    this.pop();
                    this.seenTransferOfControl = true;
                    this.setReachOnlyByBranch(true);
                    this.setTop(true);
                    break;
                }
                case 192: {
                    castTo = dbc.getClassConstantOperand();
                    if (castTo.charAt(0) != '[') {
                        castTo = "L" + castTo + ";";
                    }
                    if (!Item.access$300(it = this.pop()).equals(castTo)) {
                        it = new Item(it, castTo);
                    }
                    this.push(it);
                    break;
                }
                case 0: {
                    break;
                }
                case 169: 
                case 177: {
                    this.seenTransferOfControl = true;
                    this.setReachOnlyByBranch(true);
                    break;
                }
                case 167: 
                case 200: {
                    this.seenTransferOfControl = true;
                    this.setReachOnlyByBranch(true);
                    this.addJumpValue(dbc.getPC(), dbc.getBranchTarget());
                    this.stack.clear();
                    this.setTop(true);
                    break;
                }
                case 95: {
                    this.handleSwap();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.push(new Item("I", seen - 3));
                    break;
                }
                case 9: 
                case 10: {
                    this.push(new Item("J", (Object)(seen - 9)));
                    break;
                }
                case 14: 
                case 15: {
                    this.push(new Item("D", (Object)(seen - 14)));
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    this.push(new Item("F", Float.valueOf(seen - 11)));
                    break;
                }
                case 1: {
                    this.push(new Item());
                    break;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    this.pushByLocalStore(dbc.getRegisterOperand());
                    break;
                }
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    this.pushByLocalStore(seen - 75);
                    break;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: {
                    this.pushByLocalStore(seen - 71);
                    break;
                }
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    this.pushByLocalStore(seen - 67);
                    break;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    this.pushByLocalStore(seen - 59);
                    break;
                }
                case 63: 
                case 64: 
                case 65: 
                case 66: {
                    this.pushByLocalStore(seen - 63);
                    break;
                }
                case 180: {
                    fieldSummary = AnalysisContext.currentAnalysisContext().getFieldSummary();
                    fieldOperand = dbc.getXFieldOperand();
                    if (fieldOperand != null && fieldSummary.isComplete() && !fieldOperand.isPublic() && (item = fieldSummary.getSummary(fieldOperand)) != null) {
                        addr = this.pop();
                        itm = new Item(item);
                        itm.setLoadedFromField(fieldOperand, addr.getRegisterNumber());
                        itm.setPC(dbc.getPC());
                        this.push(itm);
                        break;
                    }
                    item = this.pop();
                    reg = item.getRegisterNumber();
                    valueLoaded = new Item(dbc.getSigConstantOperand(), FieldAnnotation.fromReferencedField(dbc), reg);
                    valueLoaded.setPC(dbc.getPC());
                    this.push(valueLoaded);
                    break;
                }
                case 190: {
                    array = this.pop();
                    newItem = new Item("I", array.getConstant());
                    newItem.setSpecialKind(14);
                    this.push(newItem);
                    break;
                }
                case 51: {
                    this.pop(2);
                    newItem = new Item("I");
                    newItem.setSpecialKind(1);
                    this.push(newItem);
                    break;
                }
                case 52: {
                    this.pop(2);
                    newItem = new Item("I");
                    newItem.setSpecialKind(14);
                    this.push(newItem);
                    break;
                }
                case 49: {
                    this.pop(2);
                    this.push(new Item("D"));
                    break;
                }
                case 48: {
                    this.pop(2);
                    this.push(new Item("F"));
                    break;
                }
                case 47: {
                    this.pop(2);
                    this.push(new Item("J"));
                    break;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    this.pop(3);
                    break;
                }
                case 16: 
                case 17: {
                    this.push(new Item("I", (Object)dbc.getIntConstant()));
                    break;
                }
                case 96: 
                case 100: 
                case 104: 
                case 108: 
                case 112: 
                case 120: 
                case 122: 
                case 124: 
                case 126: 
                case 128: 
                case 130: {
                    it = this.pop();
                    it2 = this.pop();
                    this.pushByIntMath(dbc, seen, it2, it);
                    break;
                }
                case 116: {
                    it = this.pop();
                    if (it.getConstant() instanceof Integer) {
                        this.push(new Item("I", (Object)(-this.constantToInt(it))));
                        break;
                    }
                    this.push(new Item("I"));
                    break;
                }
                case 117: {
                    it = this.pop();
                    if (it.getConstant() instanceof Long) {
                        this.push(new Item("J", -this.constantToLong(it)));
                        break;
                    }
                    this.push(new Item("J"));
                    break;
                }
                case 118: {
                    it = this.pop();
                    if (it.getConstant() instanceof Float) {
                        this.push(new Item("F", Float.valueOf(-this.constantToFloat(it))));
                        break;
                    }
                    this.push(new Item("F"));
                    break;
                }
                case 119: {
                    it = this.pop();
                    if (it.getConstant() instanceof Double) {
                        this.push(new Item("D", -this.constantToDouble(it)));
                        break;
                    }
                    this.push(new Item("D"));
                    break;
                }
                case 97: 
                case 101: 
                case 105: 
                case 109: 
                case 113: 
                case 121: 
                case 123: 
                case 125: 
                case 127: 
                case 129: 
                case 131: {
                    it = this.pop();
                    it2 = this.pop();
                    this.pushByLongMath(seen, it2, it);
                    break;
                }
                case 148: {
                    this.handleLcmp();
                    break;
                }
                case 149: 
                case 150: {
                    this.handleFcmp(seen);
                    break;
                }
                case 151: 
                case 152: {
                    this.handleDcmp(seen);
                    break;
                }
                case 98: 
                case 102: 
                case 106: 
                case 110: 
                case 114: {
                    it = this.pop();
                    it2 = this.pop();
                    this.pushByFloatMath(seen, it, it2);
                    break;
                }
                case 99: 
                case 103: 
                case 107: 
                case 111: 
                case 115: {
                    it = this.pop();
                    it2 = this.pop();
                    this.pushByDoubleMath(seen, it, it2);
                    break;
                }
                case 145: {
                    it = this.pop();
                    newValue = new Item(it, "B");
                    newValue.setCouldBeNegative();
                    this.push(newValue);
                    break;
                }
                case 146: {
                    it = this.pop();
                    newValue = new Item(it, "C");
                    this.push(newValue);
                    break;
                }
                case 133: 
                case 140: 
                case 143: {
                    it = this.pop();
                    newValue = new Item(it, "J");
                    specialKind = it.getSpecialKind();
                    if (specialKind != 1 && seen == 133) {
                        newValue.setSpecialKind(21);
                    }
                    this.push(newValue);
                    break;
                }
                case 147: {
                    item1 = this.pop();
                    newValue = new Item(item1, "S");
                    newValue.setCouldBeNegative();
                    this.push(newValue);
                    break;
                }
                case 136: 
                case 139: 
                case 142: {
                    it = this.pop();
                    oldSpecialKind = it.getSpecialKind();
                    it = new Item(it, "I");
                    if (oldSpecialKind == 0) {
                        it.setSpecialKind(22);
                    }
                    this.push(it);
                    break;
                }
                case 134: 
                case 137: 
                case 144: {
                    it = this.pop();
                    if (it.getConstant() != null) {
                        this.push(new Item("F", Float.valueOf(this.constantToFloat(it))));
                        break;
                    }
                    this.push(new Item("F"));
                    break;
                }
                case 135: 
                case 138: 
                case 141: {
                    it = this.pop();
                    if (it.getConstant() != null) {
                        this.push(new Item("D", this.constantToDouble(it)));
                        break;
                    }
                    this.push(new Item("D"));
                    break;
                }
                case 187: {
                    item = new Item("L" + dbc.getClassConstantOperand() + ";", (Object)null);
                    item.setSpecialKind(18);
                    this.push(item);
                    break;
                }
                case 188: {
                    length = this.pop();
                    signature = "[" + BasicType.getType((byte)((byte)dbc.getIntConstant())).getSignature();
                    item = new Item(signature, length.getConstant());
                    item.setPC(dbc.getPC());
                    item.setSpecialKind(18);
                    this.push(item);
                    break;
                }
                case 189: {
                    length = this.pop();
                    signature = dbc.getClassConstantOperand();
                    signature = signature.charAt(0) == '[' ? "[" + signature : "[L" + signature + ";";
                    item = new Item(signature, length.getConstant());
                    item.setPC(dbc.getPC());
                    item.setSpecialKind(18);
                    this.push(item);
                    break;
                }
                case 197: {
                    dims = dbc.getIntConstant();
                    for (i = 0; i < dims; ++i) {
                        this.pop();
                    }
                    signature = dbc.getClassConstantOperand();
                    this.pushBySignature(signature, dbc);
                    this.getStackItem(0).setSpecialKind(18);
                    break;
                }
                case 50: {
                    this.pop();
                    it = this.pop();
                    arraySig = it.getSignature();
                    if (arraySig.charAt(0) == '[') {
                        this.pushBySignature(arraySig.substring(1), dbc);
                        break;
                    }
                    this.push(new Item());
                    break;
                }
                case 168: {
                    this.seenTransferOfControl = true;
                    this.setReachOnlyByBranch(false);
                    this.push(new Item(""));
                    this.addJumpValue(dbc.getPC(), dbc.getBranchTarget());
                    this.pop();
                    if (dbc.getBranchOffset() < 0) {
                        stackSize = this.stack.size();
                        this.stack.clear();
                        for (i = 0; i < stackSize; ++i) {
                            this.stack.add(new Item());
                        }
                    }
                    this.setTop(false);
                    break;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    this.processMethodCall(dbc, seen);
                    break;
                }
                case 186: {
                    this.processInvokeDynamic(dbc);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("OpCode " + seen + ":" + OpcodeStack.OPCODE_NAMES[seen] + " not supported ");
                }
            }
            ** if (!OpcodeStack.DEBUG) goto lbl-1000
        }
        catch (RuntimeException e) {
            try {
                msg = "Error processing opcode " + OpcodeStack.OPCODE_NAMES[seen] + " @ " + dbc.getPC() + " in " + dbc.getFullyQualifiedMethodName();
                AnalysisContext.logError(msg, e);
                if (OpcodeStack.DEBUG) {
                    e.printStackTrace();
                }
                this.clear();
                this.setTop(true);
                ** if (!OpcodeStack.DEBUG) goto lbl-1000
            }
            catch (Throwable var17_86) {
                if (OpcodeStack.DEBUG) {
                    System.out.printf("%4d: %14s %s%n", new Object[]{dbc.getPC(), OpcodeStack.OPCODE_NAMES[seen], this});
                }
                throw var17_86;
            }
lbl-1000:
            // 1 sources

            {
                System.out.printf("%4d: %14s %s%n", new Object[]{dbc.getPC(), OpcodeStack.OPCODE_NAMES[seen], this});
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            System.out.printf("%4d: %14s %s%n", new Object[]{dbc.getPC(), OpcodeStack.OPCODE_NAMES[seen], this});
        }
lbl-1000:
        // 2 sources

        {
        }
    }

    private void eraseKnowledgeOf(XField fieldOperand) {
        if (fieldOperand == null) {
            return;
        }
        for (Item item : this.stack) {
            if (item == null || !fieldOperand.equals(item.getXField())) continue;
            item.setLoadedFromField(null, -1);
        }
        for (Item item : this.lvValues) {
            if (item == null || !fieldOperand.equals(item.getXField())) continue;
            item.setLoadedFromField(null, -1);
        }
    }

    public void precomputation(DismantleBytecode dbc) {
        if (this.registerTestedFoundToBeNonnegative >= 0) {
            Item item;
            int i;
            for (i = 0; i < this.stack.size(); ++i) {
                item = this.stack.get(i);
                if (item == null || item.registerNumber != this.registerTestedFoundToBeNonnegative) continue;
                this.stack.set(i, item.cloneAndSetSpecialKind(14));
            }
            for (i = 0; i < this.lvValues.size(); ++i) {
                item = this.lvValues.get(i);
                if (item == null || item.registerNumber != this.registerTestedFoundToBeNonnegative) continue;
                this.lvValues.set(i, item.cloneAndSetSpecialKind(14));
            }
        }
        this.registerTestedFoundToBeNonnegative = -1;
        this.mergeJumps(dbc);
    }

    private int constantToInt(Item it) {
        Object constant = it.getConstant();
        if (constant instanceof Number) {
            return ((Number)constant).intValue();
        }
        if (constant instanceof Character) {
            return ((Character)constant).charValue();
        }
        throw new IllegalArgumentException(String.valueOf(constant));
    }

    private float constantToFloat(Item it) {
        return ((Number)it.getConstant()).floatValue();
    }

    private double constantToDouble(Item it) {
        return ((Number)it.getConstant()).doubleValue();
    }

    private long constantToLong(Item it) {
        return ((Number)it.getConstant()).longValue();
    }

    private void handleDcmp(int opcode) {
        Item it = this.pop();
        Item it2 = this.pop();
        if (it.getConstant() != null && it2.getConstant() != null) {
            double d = this.constantToDouble(it);
            double d2 = this.constantToDouble(it2);
            if (Double.isNaN(d) || Double.isNaN(d2)) {
                if (opcode == 152) {
                    this.push(new Item("I", (Object)1));
                } else {
                    this.push(new Item("I", (Object)-1));
                }
            }
            if (d2 < d) {
                this.push(new Item("I", (Object)-1));
            } else if (d2 > d) {
                this.push(new Item("I", (Object)1));
            } else {
                this.push(new Item("I", (Object)0));
            }
        } else {
            this.push(new Item("I"));
        }
    }

    private void handleFcmp(int opcode) {
        Item it = this.pop();
        Item it2 = this.pop();
        if (it.getConstant() != null && it2.getConstant() != null) {
            float f = this.constantToFloat(it);
            float f2 = this.constantToFloat(it2);
            if (Float.isNaN(f) || Float.isNaN(f2)) {
                if (opcode == 150) {
                    this.push(new Item("I", (Object)1));
                } else {
                    this.push(new Item("I", (Object)-1));
                }
            }
            if (f2 < f) {
                this.push(new Item("I", (Object)-1));
            } else if (f2 > f) {
                this.push(new Item("I", (Object)1));
            } else {
                this.push(new Item("I", (Object)0));
            }
        } else {
            this.push(new Item("I"));
        }
    }

    private void handleLcmp() {
        Item it = this.pop();
        Item it2 = this.pop();
        if (it.getConstant() != null && it2.getConstant() != null) {
            long l = this.constantToLong(it);
            long l2 = this.constantToLong(it2);
            if (l2 < l) {
                this.push(new Item("I", (Object)-1));
            } else if (l2 > l) {
                this.push(new Item("I", (Object)1));
            } else {
                this.push(new Item("I", (Object)0));
            }
        } else {
            this.push(new Item("I"));
        }
    }

    private void handleSwap() {
        Item i1 = this.pop();
        Item i2 = this.pop();
        this.push(i1);
        this.push(i2);
    }

    private void handleDup() {
        Item it = this.pop();
        this.push(it);
        this.push(it);
    }

    private void handleDupX1() {
        Item it = this.pop();
        Item it2 = this.pop();
        this.push(it);
        this.push(it2);
        this.push(it);
    }

    private void handleDup2() {
        Item it = this.pop();
        if (it.getSize() == 2) {
            this.push(it);
            this.push(it);
        } else {
            Item it2 = this.pop();
            this.push(it2);
            this.push(it);
            this.push(it2);
            this.push(it);
        }
    }

    private void handleDup2X1() {
        Item it = this.pop();
        Item it2 = this.pop();
        String signature = it.getSignature();
        if ("J".equals(signature) || "D".equals(signature)) {
            this.push(it);
            this.push(it2);
            this.push(it);
        } else {
            Item it3 = this.pop();
            this.push(it2);
            this.push(it);
            this.push(it3);
            this.push(it2);
            this.push(it);
        }
    }

    private void handleDup2X2() {
        Item it = this.pop();
        Item it2 = this.pop();
        if (it.isWide()) {
            if (it2.isWide()) {
                this.push(it);
                this.push(it2);
                this.push(it);
            } else {
                Item it3 = this.pop();
                this.push(it);
                this.push(it3);
                this.push(it2);
                this.push(it);
            }
        } else {
            Item it3 = this.pop();
            if (it3.isWide()) {
                this.push(it2);
                this.push(it);
                this.push(it3);
                this.push(it2);
                this.push(it);
            } else {
                Item it4 = this.pop();
                this.push(it2);
                this.push(it);
                this.push(it4);
                this.push(it3);
                this.push(it2);
                this.push(it);
            }
        }
    }

    private void handleDupX2() {
        Item it = this.pop();
        Item it2 = this.pop();
        String signature = it2.getSignature();
        if ("J".equals(signature) || "D".equals(signature)) {
            this.push(it);
            this.push(it2);
            this.push(it);
        } else {
            Item it3 = this.pop();
            this.push(it);
            this.push(it3);
            this.push(it2);
            this.push(it);
        }
    }

    private static void addBoxedType(Class<?> ... clss) {
        for (Class<?> c : clss) {
            try {
                Class primitiveType = (Class)c.getField("TYPE").get(null);
                boxedTypes.put(ClassName.toSlashedClassName(c.getName()), primitiveType.getName());
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private void markConstantValueUnknown(Item item) {
        Item sbItem;
        item.constValue = null;
        if (item.registerNumber >= 0 && (sbItem = this.getLVValue(item.registerNumber)).getSignature().equals(item.getSignature())) {
            sbItem.constValue = null;
        }
    }

    private void processMethodCall(DismantleBytecode dbc, int seen) {
        Item i;
        Item firstArg;
        int firstArgument;
        String clsName = dbc.getClassConstantOperand();
        String methodName = dbc.getNameConstantOperand();
        String signature = dbc.getSigConstantOperand();
        String appenderValue = null;
        boolean servletRequestParameterTainted = false;
        boolean sawUnknownAppend = false;
        Item sbItem = null;
        Item topItem = null;
        if (this.getStackDepth() > 0) {
            topItem = this.getStackItem(0);
        }
        int numberArguments = PreorderVisitor.getNumberArguments(signature);
        if (boxedTypes.containsKey(clsName) && topItem != null && ("valueOf".equals(methodName) && !signature.contains("String") || methodName.equals(boxedTypes.get(clsName) + "Value"))) {
            String newSignature;
            Item value = this.pop();
            Item newValue = new Item(value, newSignature = new SignatureParser(signature).getReturnTypeSignature());
            if (newValue.source == null) {
                newValue.source = XFactory.createReferencedXMethod(dbc);
            }
            if (newValue.specialKind == 0) {
                if ("B".equals(newSignature) || "Ljava/lang/Boolean;".equals(newSignature)) {
                    newValue.specialKind = 1;
                } else if ("C".equals(newSignature) || "Ljava/lang/Character;".equals(newSignature)) {
                    newValue.specialKind = 14;
                }
            }
            this.push(newValue);
            return;
        }
        for (int i2 = firstArgument = seen == 184 ? 0 : 1; i2 < firstArgument + numberArguments && i2 < this.getStackDepth(); ++i2) {
            Item item = this.getStackItem(i2);
            String itemSignature = item.getSignature();
            if (!"Ljava/lang/StringBuilder;".equals(itemSignature) && !"Ljava/lang/StringBuffer;".equals(itemSignature)) continue;
            this.markConstantValueUnknown(item);
        }
        boolean initializingServletWriter = false;
        if (seen == 183 && "<init>".equals(methodName) && clsName.startsWith("java/io") && clsName.endsWith("Writer") && numberArguments > 0 && (firstArg = this.getStackItem(numberArguments - 1)).isServletWriter()) {
            initializingServletWriter = true;
        }
        boolean topIsTainted = topItem != null && topItem.isServletParameterTainted();
        HttpParameterInjection injection = null;
        if (topIsTainted) {
            injection = topItem.injection;
        }
        if ("java/lang/StringBuffer".equals(clsName) || "java/lang/StringBuilder".equals(clsName)) {
            if ("<init>".equals(methodName)) {
                if ("(Ljava/lang/String;)V".equals(signature)) {
                    i = this.getStackItem(0);
                    appenderValue = (String)i.getConstant();
                    if (i.isServletParameterTainted()) {
                        servletRequestParameterTainted = true;
                    }
                } else if ("()V".equals(signature)) {
                    appenderValue = "";
                }
            } else if ("toString".equals(methodName) && this.getStackDepth() >= 1) {
                i = this.getStackItem(0);
                appenderValue = (String)i.getConstant();
                if (i.isServletParameterTainted()) {
                    servletRequestParameterTainted = true;
                }
            } else if ("append".equals(methodName)) {
                if (signature.indexOf("II)") == -1 && this.getStackDepth() >= 2) {
                    sbItem = this.getStackItem(1);
                    i = this.getStackItem(0);
                    if (i.isServletParameterTainted() || sbItem.isServletParameterTainted()) {
                        servletRequestParameterTainted = true;
                    }
                    Object sbVal = sbItem.getConstant();
                    Object sVal = i.getConstant();
                    if (sbVal != null && sVal != null) {
                        appenderValue = sbVal + sVal.toString();
                    } else {
                        this.markConstantValueUnknown(sbItem);
                    }
                } else if (signature.startsWith("([CII)")) {
                    sawUnknownAppend = true;
                    sbItem = this.getStackItem(3);
                    this.markConstantValueUnknown(sbItem);
                } else {
                    sawUnknownAppend = true;
                }
            }
        } else if (seen == 183 && "java/io/FileOutputStream".equals(clsName) && "<init>".equals(methodName) && ("(Ljava/io/File;Z)V".equals(signature) || "(Ljava/lang/String;Z)V".equals(signature)) && this.stack.size() > 3) {
            Item item = this.getStackItem(0);
            Object value = item.getConstant();
            if (value instanceof Integer && (Integer)value == 1) {
                this.pop(3);
                Item newTop = this.getStackItem(0);
                if ("Ljava/io/FileOutputStream;".equals(newTop.signature)) {
                    newTop.setSpecialKind(16);
                    newTop.source = XFactory.createReferencedXMethod(dbc);
                    newTop.setPC(dbc.getPC());
                }
                return;
            }
        } else if (seen == 183 && "java/io/BufferedOutputStream".equals(clsName) && "<init>".equals(methodName) && "(Ljava/io/OutputStream;)V".equals(signature)) {
            if (this.getStackItem(0).getSpecialKind() == 16 && "Ljava/io/BufferedOutputStream;".equals(this.getStackItem(2).signature)) {
                this.pop(2);
                Item newTop = this.getStackItem(0);
                newTop.setSpecialKind(16);
                newTop.source = XFactory.createReferencedXMethod(dbc);
                newTop.setPC(dbc.getPC());
                return;
            }
        } else {
            if (seen == 185 && "getParameter".equals(methodName) && "javax/servlet/http/HttpServletRequest".equals(clsName) || "javax/servlet/http/ServletRequest".equals(clsName)) {
                Item requestParameter = this.pop();
                this.pop();
                Item result = new Item("Ljava/lang/String;");
                result.setServletParameterTainted();
                result.source = XFactory.createReferencedXMethod(dbc);
                String parameterName = null;
                if (requestParameter.getConstant() instanceof String) {
                    parameterName = (String)requestParameter.getConstant();
                }
                result.injection = new HttpParameterInjection(parameterName, dbc.getPC());
                result.setPC(dbc.getPC());
                this.push(result);
                return;
            }
            if (seen == 185 && "getQueryString".equals(methodName) && "javax/servlet/http/HttpServletRequest".equals(clsName) || "javax/servlet/http/ServletRequest".equals(clsName)) {
                this.pop();
                Item result = new Item("Ljava/lang/String;");
                result.setServletParameterTainted();
                result.source = XFactory.createReferencedXMethod(dbc);
                result.setPC(dbc.getPC());
                this.push(result);
                return;
            }
            if (seen == 185 && "getHeader".equals(methodName) && "javax/servlet/http/HttpServletRequest".equals(clsName) || "javax/servlet/http/ServletRequest".equals(clsName)) {
                this.pop();
                this.pop();
                Item result = new Item("Ljava/lang/String;");
                result.setServletParameterTainted();
                result.source = XFactory.createReferencedXMethod(dbc);
                result.setPC(dbc.getPC());
                this.push(result);
                return;
            }
            if (seen == 184 && "asList".equals(methodName) && "java/util/Arrays".equals(clsName)) {
                this.pop();
                Item result = new Item(JAVA_UTIL_ARRAYS_ARRAY_LIST);
                this.push(result);
                return;
            }
            if (seen == 184 && "(Ljava/util/List;)Ljava/util/List;".equals(signature) && "java/util/Collections".equals(clsName)) {
                Item requestParameter = this.pop();
                if (JAVA_UTIL_ARRAYS_ARRAY_LIST.equals(requestParameter.getSignature())) {
                    Item result = new Item(JAVA_UTIL_ARRAYS_ARRAY_LIST);
                    this.push(result);
                    return;
                }
                this.push(requestParameter);
            }
        }
        this.pushByInvoke(dbc, seen != 184);
        if (sbItem != null && sbItem.isNewlyAllocated()) {
            this.getStackItem(0).setSpecialKind(18);
        }
        if (initializingServletWriter) {
            this.getStackItem(0).setIsServletWriter();
        }
        if ((sawUnknownAppend || appenderValue != null || servletRequestParameterTainted) && this.getStackDepth() > 0) {
            i = this.getStackItem(0);
            i.constValue = appenderValue;
            if (!sawUnknownAppend && servletRequestParameterTainted) {
                i.injection = topItem.injection;
                i.setServletParameterTainted();
            }
            if (sbItem != null) {
                i.registerNumber = sbItem.registerNumber;
                i.source = sbItem.source;
                if (i.injection == null) {
                    i.injection = sbItem.injection;
                }
                if (sbItem.registerNumber >= 0) {
                    this.setLVValue(sbItem.registerNumber, i);
                }
            }
            return;
        }
        if (("java/util/Random".equals(clsName) || "java/security/SecureRandom".equals(clsName)) && ("nextInt".equals(methodName) && "()I".equals(signature) || "nextLong".equals(methodName) && "()J".equals(signature))) {
            i = new Item(this.pop());
            i.setSpecialKind(2);
            this.push(i);
        } else if ("size".equals(methodName) && "()I".equals(signature) && Subtypes2.instanceOf(ClassName.toDottedClassName(clsName), "java.util.Collection")) {
            i = new Item(this.pop());
            if (i.getSpecialKind() == 0) {
                i.setSpecialKind(14);
            }
            this.push(i);
        } else if ("java/lang/String".equals(clsName) && numberArguments == 0 && topItem.getConstant() instanceof String) {
            Object result;
            String input = (String)topItem.getConstant();
            switch (methodName) {
                case "length": {
                    result = input.length();
                    break;
                }
                case "trim": {
                    result = input.trim();
                    break;
                }
                case "toString": 
                case "intern": {
                    result = input;
                    break;
                }
                default: {
                    result = null;
                }
            }
            if (result != null) {
                Item i3 = new Item(this.pop());
                i3.constValue = result;
                this.push(i3);
            }
        } else if (ClassName.isMathClass(clsName) && "abs".equals(methodName)) {
            i = new Item(this.pop());
            if (i.getSpecialKind() == 4) {
                i.setSpecialKind(13);
            } else if (i.getSpecialKind() == 2) {
                i.setSpecialKind(12);
            } else {
                i.setSpecialKind(11);
            }
            this.push(i);
        } else if (seen == 182 && "hashCode".equals(methodName) && "()I".equals(signature) || seen == 184 && "java/lang/System".equals(clsName) && "identityHashCode".equals(methodName) && "(Ljava/lang/Object;)I".equals(signature)) {
            i = new Item(this.pop());
            i.setSpecialKind(4);
            this.push(i);
        } else if (topIsTainted && (methodName.startsWith("encode") && "javax/servlet/http/HttpServletResponse".equals(clsName) || "trim".equals(methodName) && "java/lang/String".equals(clsName))) {
            i = new Item(this.pop());
            i.setSpecialKind(17);
            i.injection = injection;
            this.push(i);
        }
        if (!signature.endsWith(")V")) {
            i = new Item(this.pop());
            i.source = XFactory.createReferencedXMethod(dbc);
            this.push(i);
        }
    }

    private void processInvokeDynamic(DismantleBytecode dbc) {
        String signature = dbc.getSigConstantOperand();
        int numberArguments = PreorderVisitor.getNumberArguments(signature);
        this.pop(numberArguments);
        this.pushBySignature(new SignatureParser(signature).getReturnTypeSignature(), dbc);
    }

    private boolean mergeLists(List<Item> mergeInto, List<Item> mergeFrom, boolean errorIfSizesDoNotMatch) {
        int intoSize = mergeInto.size();
        int fromSize = mergeFrom.size();
        boolean changed = false;
        if (errorIfSizesDoNotMatch && intoSize != fromSize) {
            if (DEBUG2) {
                System.out.println("Bad merging items");
                System.out.println("current items: " + mergeInto);
                System.out.println("jump items: " + mergeFrom);
            }
        } else {
            if (DEBUG2 && intoSize != fromSize) {
                System.out.printf("Bad merging %d items from %d items%n", intoSize, fromSize);
                System.out.println("current items: " + mergeInto);
                System.out.println("jump items: " + mergeFrom);
            }
            ArrayList<Item> mergeIntoCopy = null;
            if (DEBUG2) {
                mergeIntoCopy = new ArrayList<Item>(mergeInto);
            }
            int common = Math.min(intoSize, fromSize);
            for (int i = 0; i < common; ++i) {
                Item newValue;
                Item oldValue = mergeInto.get(i);
                Item merged = Item.merge(oldValue, newValue = mergeFrom.get(i));
                if (merged == null || merged.equals(oldValue)) continue;
                mergeInto.set(i, merged);
                changed = true;
            }
            if (DEBUG2 && changed) {
                System.out.println("Merge results:");
                System.out.println("updating: " + mergeIntoCopy);
                System.out.println("    with: " + mergeFrom);
                System.out.println("   gives: " + mergeInto);
            }
        }
        return changed;
    }

    public void clear() {
        this.stack.clear();
        this.lvValues.clear();
    }

    public void printJumpEntries() {
        int i = this.jumpEntryLocations.nextSetBit(0);
        while (i >= 0) {
            List<Item> stack = this.jumpStackEntries.get(i);
            List<Item> locals = this.jumpEntries.get(i);
            if (stack != null) {
                System.out.printf("%4d: %s::%s%n", i, stack, locals);
            } else {
                System.out.printf("%4d:    ::%s%n", i, locals);
            }
            i = this.jumpEntryLocations.nextSetBit(i + 1);
        }
    }

    public boolean isJumpTarget(int pc) {
        return this.jumpEntryLocations.get(pc);
    }

    private void addJumpValue(int from, int target) {
        List<Item> atTarget;
        if (DEBUG) {
            System.out.println("Set jump entry at " + this.methodName + ":" + target + " pc to " + this.stack + " : " + this.lvValues);
        }
        if (from >= target) {
            this.backwardsBranch = true;
        }
        if ((atTarget = this.jumpEntries.get(target)) == null) {
            this.setJumpInfoChangedByBackwardBranch("new target", from, target);
            this.setJumpInfoChangedByNewTarget();
            this.jumpEntries.put(target, new ArrayList<Item>(this.lvValues));
            this.jumpEntryLocations.set(target);
            if (this.stack.size() > 0) {
                this.jumpStackEntries.put(target, new ArrayList<Item>(this.stack));
            }
        } else {
            if (this.mergeLists(atTarget, this.lvValues, false)) {
                this.setJumpInfoChangedByBackwardBranch("locals", from, target);
            }
            List<Item> stackAtTarget = this.jumpStackEntries.get(target);
            if (this.stack.size() > 0 && stackAtTarget != null && this.mergeLists(stackAtTarget, this.stack, false)) {
                this.setJumpInfoChangedByBackwardBranch("stack", from, target);
            }
        }
    }

    public void learnFrom(JumpInfo info) {
        if (info == null) {
            return;
        }
        this.jumpEntries = new HashMap<Integer, List<Item>>(info.jumpEntries);
        this.jumpStackEntries = new HashMap<Integer, List<Item>>(info.jumpStackEntries);
        this.jumpEntryLocations = (BitSet)info.jumpEntryLocations.clone();
    }

    public void initialize() {
        this.setTop(false);
        this.jumpEntries.clear();
        this.jumpStackEntries.clear();
        this.jumpEntryLocations.clear();
        this.encountedTop = false;
        this.backwardsBranch = false;
        this.lastUpdate.clear();
        this.convertJumpToZeroOneState = 0;
        this.convertJumpToOneZeroState = 0;
        this.zeroOneComing = -1;
        this.registerTestedFoundToBeNonnegative = -1;
        this.setReachOnlyByBranch(false);
    }

    public int resetForMethodEntry(DismantleBytecode visitor) {
        this.v = visitor;
        this.initialize();
        int result = this.resetForMethodEntry0(this.v);
        Code code = this.v.getMethod().getCode();
        if (code == null) {
            return result;
        }
        JumpInfo jump = null;
        jump = this.useIterativeAnalysis ? (visitor instanceof OpcodeStackDetector.WithCustomJumpInfo ? ((OpcodeStackDetector.WithCustomJumpInfo)visitor).customJumpInfo() : (visitor instanceof OpcodeStackDetector && !((OpcodeStackDetector)visitor).isUsingCustomUserValue() ? this.getJumpInfo() : this.getJumpInfoFromStackMap())) : this.getJumpInfoFromStackMap();
        this.learnFrom(jump);
        return result;
    }

    int nullSafeSize(@CheckForNull Collection<?> c) {
        if (c == null) {
            return 0;
        }
        return c.size();
    }

    private JumpInfo getJumpInfo() {
        MethodInfo mi;
        IAnalysisCache analysisCache = Global.getAnalysisCache();
        XMethod xMethod = XFactory.createXMethod(this.v.getThisClass(), this.v.getMethod());
        if (xMethod instanceof MethodInfo && !(mi = (MethodInfo)xMethod).hasBackBranch()) {
            return null;
        }
        try {
            return analysisCache.getMethodAnalysis(JumpInfo.class, xMethod.getMethodDescriptor());
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error getting jump information", e);
            return null;
        }
    }

    private StackMapAnalyzer.JumpInfoFromStackMap getJumpInfoFromStackMap() {
        MethodInfo mi;
        IAnalysisCache analysisCache = Global.getAnalysisCache();
        XMethod xMethod = XFactory.createXMethod(this.v.getThisClass(), this.v.getMethod());
        if (xMethod instanceof MethodInfo && !(mi = (MethodInfo)xMethod).hasBackBranch()) {
            return null;
        }
        try {
            return analysisCache.getMethodAnalysis(StackMapAnalyzer.JumpInfoFromStackMap.class, xMethod.getMethodDescriptor());
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error getting jump information from StackMap", e);
            return null;
        }
    }

    public void setJumpInfoChangedByBackwardBranch(String kind, int from, int to) {
        if (from < to) {
            return;
        }
        if (DEBUG && !this.isJumpInfoChangedByBackwardsBranch()) {
            System.out.printf("%s jump info at %d changed by jump from %d%n", kind, to, from);
        }
        this.setJumpInfoChangedByBackwardsBranch(from, to);
    }

    private int resetForMethodEntry0(PreorderVisitor visitor) {
        return this.resetForMethodEntry0(visitor.getClassName(), visitor.getMethod());
    }

    int resetForMethodEntry0(@SlashedClassName String className, Method m) {
        CodeException[] exceptionTable;
        this.methodName = m.getName();
        if (DEBUG) {
            System.out.println(" --- ");
        }
        String signature = m.getSignature();
        this.stack.clear();
        this.lvValues.clear();
        this.top = false;
        this.encountedTop = false;
        this.backwardsBranch = false;
        this.clearJumpInfoChangedByBackwardsBranch();
        this.clearJumpInfoChangedByNewTarget();
        this.setReachOnlyByBranch(false);
        this.seenTransferOfControl = false;
        this.exceptionHandlers.clear();
        Code code = m.getCode();
        if (code != null && (exceptionTable = code.getExceptionTable()) != null) {
            for (CodeException ex : exceptionTable) {
                this.exceptionHandlers.set(ex.getHandlerPC());
            }
        }
        if (DEBUG) {
            System.out.println(" --- " + className + " " + m.getName() + " " + signature);
        }
        Type[] argTypes = Type.getArgumentTypes((String)signature);
        int reg = 0;
        if (!m.isStatic()) {
            Item it = Item.initialArgument("L" + className + ";", reg);
            this.setLVValue(reg, it);
            reg += it.getSize();
        }
        for (Type argType : argTypes) {
            Item it = Item.initialArgument(argType.getSignature(), reg);
            this.setLVValue(reg, it);
            reg += it.getSize();
        }
        return reg;
    }

    public int getStackDepth() {
        return this.stack.size();
    }

    public Item getStackItem(int stackOffset) {
        if (stackOffset < 0 || stackOffset >= this.stack.size()) {
            AnalysisContext.logError("Can't get stack offset " + stackOffset + " from " + this.stack.toString() + " @ " + this.v.getPC() + " in " + this.v.getFullyQualifiedMethodName(), new IllegalArgumentException(stackOffset + " is not a value stack offset"));
            return new Item("Lfindbugs/OpcodeStackError;");
        }
        int tos = this.stack.size() - 1;
        int pos = tos - stackOffset;
        try {
            return this.stack.get(pos);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Requested item at offset " + stackOffset + " in a stack of size " + this.stack.size() + ", made request for position " + pos);
        }
    }

    private Item pop() {
        return this.stack.remove(this.stack.size() - 1);
    }

    public void replace(int stackOffset, Item value) {
        if (stackOffset < 0 || stackOffset >= this.stack.size()) {
            AnalysisContext.logError("Can't get replace stack offset " + stackOffset + " from " + this.stack.toString() + " @ " + this.v.getPC() + " in " + this.v.getFullyQualifiedMethodName(), new IllegalArgumentException(stackOffset + " is not a value stack offset"));
        }
        int tos = this.stack.size() - 1;
        int pos = tos - stackOffset;
        this.stack.set(pos, value);
    }

    public void replaceTop(Item newTop) {
        this.pop();
        this.push(newTop);
    }

    private void pop(int count) {
        while (count-- > 0) {
            this.pop();
        }
    }

    private void push(Item i) {
        this.stack.add(i);
    }

    private void pushByConstant(DismantleBytecode dbc, Constant c) {
        if (c instanceof ConstantClass) {
            this.push(new Item("Ljava/lang/Class;", ((ConstantClass)c).getConstantValue(dbc.getConstantPool())));
        } else if (c instanceof ConstantInteger) {
            this.push(new Item("I", (Object)((ConstantInteger)c).getBytes()));
        } else if (c instanceof ConstantString) {
            int s = ((ConstantString)c).getStringIndex();
            this.push(new Item("Ljava/lang/String;", (Object)this.getStringFromIndex(dbc, s)));
        } else if (c instanceof ConstantFloat) {
            this.push(new Item("F", Float.valueOf(((ConstantFloat)c).getBytes())));
        } else if (c instanceof ConstantDouble) {
            this.push(new Item("D", ((ConstantDouble)c).getBytes()));
        } else if (c instanceof ConstantLong) {
            this.push(new Item("J", ((ConstantLong)c).getBytes()));
        } else {
            throw new UnsupportedOperationException("StaticConstant type not expected");
        }
    }

    private void pushByLocalObjectLoad(DismantleBytecode dbc, int register) {
        LocalVariable lv;
        Method m = dbc.getMethod();
        LocalVariableTable lvt = m.getLocalVariableTable();
        if (lvt != null && (lv = LVTHelper.getLocalVariableAtPC(lvt, register, dbc.getPC())) != null) {
            String signature = lv.getSignature();
            this.pushByLocalLoad(signature, register);
            return;
        }
        this.pushByLocalLoad("Ljava/lang/Object;", register);
    }

    private void pushByIntMath(DismantleBytecode dbc, int seen, Item lhs, Item rhs) {
        Item newValue = new Item("I");
        if (lhs == null || rhs == null) {
            this.push(newValue);
            return;
        }
        try {
            int value;
            if (DEBUG) {
                System.out.println("pushByIntMath " + dbc.getFullyQualifiedMethodName() + " @ " + dbc.getPC() + " : " + lhs + OPCODE_NAMES[seen] + rhs);
            }
            if (rhs.getConstant() != null && lhs.getConstant() != null) {
                int lhsValue = this.constantToInt(lhs);
                int rhsValue = this.constantToInt(rhs);
                if ((seen == 108 || seen == 112) && rhsValue == 0) {
                    this.push(newValue);
                    return;
                }
                switch (seen) {
                    case 96: {
                        newValue = new Item("I", lhsValue + rhsValue);
                        break;
                    }
                    case 100: {
                        newValue = new Item("I", lhsValue - rhsValue);
                        break;
                    }
                    case 104: {
                        newValue = new Item("I", lhsValue * rhsValue);
                        break;
                    }
                    case 108: {
                        newValue = new Item("I", lhsValue / rhsValue);
                        break;
                    }
                    case 112: {
                        newValue = new Item("I", lhsValue % rhsValue);
                        break;
                    }
                    case 126: {
                        newValue = new Item("I", lhsValue & rhsValue);
                        if (((rhsValue & 0xFF) != 0 || rhsValue == 0) && ((lhsValue & 0xFF) != 0 || lhsValue == 0)) break;
                        newValue.setSpecialKind(3);
                        break;
                    }
                    case 128: {
                        newValue = new Item("I", lhsValue | rhsValue);
                        break;
                    }
                    case 130: {
                        newValue = new Item("I", lhsValue ^ rhsValue);
                        break;
                    }
                    case 120: {
                        newValue = new Item("I", lhsValue << rhsValue);
                        if (rhsValue < 8) break;
                        newValue.setSpecialKind(3);
                        break;
                    }
                    case 122: {
                        newValue = new Item("I", lhsValue >> rhsValue);
                        break;
                    }
                    case 124: {
                        newValue = new Item("I", lhsValue >>> rhsValue);
                    }
                }
            } else if (seen == 120 || seen == 122 || seen == 124) {
                int constant;
                if (rhs.getConstant() != null) {
                    constant = this.constantToInt(rhs);
                    if ((constant & 0x1F) == 0) {
                        newValue = new Item(lhs);
                    } else if (seen == 120 && (constant & 0x1F) >= 8) {
                        newValue.setSpecialKind(3);
                    }
                } else if (lhs.getConstant() != null && (constant = this.constantToInt(lhs)) == 0) {
                    newValue = new Item("I", 0);
                }
            } else if (lhs.getConstant() != null && seen == 126) {
                value = this.constantToInt(lhs);
                if (value == 0) {
                    newValue = new Item("I", 0);
                } else if ((value & 0xFF) == 0) {
                    newValue.setSpecialKind(3);
                } else if (value >= 0) {
                    newValue.setSpecialKind(14);
                }
            } else if (rhs.getConstant() != null && seen == 126) {
                value = this.constantToInt(rhs);
                if (value == 0) {
                    newValue = new Item("I", 0);
                } else if ((value & 0xFF) == 0) {
                    newValue.setSpecialKind(3);
                } else if (value >= 0) {
                    newValue.setSpecialKind(14);
                }
            } else if (seen == 126 && lhs.getSpecialKind() == 19) {
                newValue.setSpecialKind(19);
                newValue.setPC(lhs.getPC());
            } else if (seen == 126 && rhs.getSpecialKind() == 19) {
                newValue.setSpecialKind(19);
                newValue.setPC(rhs.getPC());
            } else if (seen == 128 && lhs.getSpecialKind() == 20) {
                newValue.setSpecialKind(20);
                newValue.setPC(lhs.getPC());
            } else if (seen == 128 && rhs.getSpecialKind() == 20) {
                newValue.setSpecialKind(20);
                newValue.setPC(rhs.getPC());
            }
        }
        catch (ArithmeticException e) {
        }
        catch (RuntimeException e) {
            String msg = "Error processing2 " + lhs + OPCODE_NAMES[seen] + rhs + " @ " + dbc.getPC() + " in " + dbc.getFullyQualifiedMethodName();
            AnalysisContext.logError(msg, e);
        }
        if (lhs.getSpecialKind() == 5 && rhs.getConstant() != null) {
            int rhsValue = this.constantToInt(rhs);
            if (seen == 108 && rhsValue == 2 || seen == 122 && rhsValue == 1) {
                newValue.setSpecialKind(6);
            }
        }
        if (seen == 96 && newValue.getSpecialKind() == 0 && lhs.getConstant() == null && rhs.getConstant() == null) {
            newValue.setSpecialKind(5);
        }
        if (seen == 112 && lhs.getSpecialKind() == 4) {
            newValue.setSpecialKind(9);
        }
        if (seen == 112 && lhs.getSpecialKind() == 2) {
            newValue.setSpecialKind(8);
        }
        if (seen == 112 && lhs.checkForIntegerMinValue()) {
            if (rhs.getConstant() != null) {
                int rhsValue = this.constantToInt(rhs);
                if (!Util.isPowerOfTwo(rhsValue)) {
                    newValue.setSpecialKind(lhs.getSpecialKindForRemainder());
                }
            } else {
                newValue.setSpecialKind(lhs.getSpecialKindForRemainder());
            }
        }
        if (DEBUG) {
            System.out.println("push: " + newValue);
        }
        newValue.setPC(dbc.getPC());
        this.push(newValue);
    }

    private void pushByLongMath(int seen, Item lhs, Item rhs) {
        Item newValue = new Item("J");
        try {
            if (rhs.getConstant() != null && lhs.getConstant() != null) {
                long lhsValue = this.constantToLong(lhs);
                if (seen == 121) {
                    newValue = new Item("J", lhsValue << this.constantToInt(rhs));
                    if (this.constantToInt(rhs) >= 8) {
                        newValue.setSpecialKind(3);
                    }
                } else if (seen == 123) {
                    newValue = new Item("J", lhsValue >> this.constantToInt(rhs));
                } else if (seen == 125) {
                    newValue = new Item("J", lhsValue >>> this.constantToInt(rhs));
                } else {
                    long rhsValue = this.constantToLong(rhs);
                    if (seen == 97) {
                        newValue = new Item("J", lhsValue + rhsValue);
                    } else if (seen == 101) {
                        newValue = new Item("J", lhsValue - rhsValue);
                    } else if (seen == 105) {
                        newValue = new Item("J", lhsValue * rhsValue);
                    } else if (seen == 109) {
                        newValue = new Item("J", lhsValue / rhsValue);
                    } else if (seen == 127) {
                        newValue = new Item("J", lhsValue & rhsValue);
                        if ((rhsValue & 0xFFL) == 0L && rhsValue != 0L || (lhsValue & 0xFFL) == 0L && lhsValue != 0L) {
                            newValue.setSpecialKind(3);
                        }
                    } else if (seen == 129) {
                        newValue = new Item("J", lhsValue | rhsValue);
                    } else if (seen == 131) {
                        newValue = new Item("J", lhsValue ^ rhsValue);
                    } else if (seen == 113) {
                        newValue = new Item("J", lhsValue % rhsValue);
                    }
                }
            } else if (rhs.getConstant() != null && seen == 121 && this.constantToInt(rhs) >= 8) {
                newValue.setSpecialKind(3);
            } else if (lhs.getConstant() != null && seen == 127 && (this.constantToLong(lhs) & 0xFFL) == 0L) {
                newValue.setSpecialKind(3);
            } else if (rhs.getConstant() != null && seen == 127 && (this.constantToLong(rhs) & 0xFFL) == 0L) {
                newValue.setSpecialKind(3);
            }
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        this.push(newValue);
    }

    private void pushByFloatMath(int seen, Item it, Item it2) {
        Item result;
        int specialKind = 7;
        if (it.getConstant() instanceof Float && it2.getConstant() instanceof Float) {
            result = seen == 98 ? new Item("F", Float.valueOf(this.constantToFloat(it2) + this.constantToFloat(it))) : (seen == 102 ? new Item("F", Float.valueOf(this.constantToFloat(it2) - this.constantToFloat(it))) : (seen == 106 ? new Item("F", Float.valueOf(this.constantToFloat(it2) * this.constantToFloat(it))) : (seen == 110 ? new Item("F", Float.valueOf(this.constantToFloat(it2) / this.constantToFloat(it))) : (seen == 114 ? new Item("F", Float.valueOf(this.constantToFloat(it2) % this.constantToFloat(it))) : new Item("F")))));
        } else {
            result = new Item("F");
            if (seen == 111) {
                specialKind = 15;
            }
        }
        result.setSpecialKind(specialKind);
        this.push(result);
    }

    private void pushByDoubleMath(int seen, Item it, Item it2) {
        Item result;
        int specialKind = 7;
        if (it.getConstant() instanceof Double && it2.getConstant() instanceof Double) {
            result = seen == 99 ? new Item("D", this.constantToDouble(it2) + this.constantToDouble(it)) : (seen == 103 ? new Item("D", this.constantToDouble(it2) - this.constantToDouble(it)) : (seen == 107 ? new Item("D", this.constantToDouble(it2) * this.constantToDouble(it)) : (seen == 111 ? new Item("D", this.constantToDouble(it2) / this.constantToDouble(it)) : (seen == 115 ? new Item("D", this.constantToDouble(it2) % this.constantToDouble(it)) : new Item("D")))));
        } else {
            result = new Item("D");
            if (seen == 111) {
                specialKind = 15;
            }
        }
        result.setSpecialKind(specialKind);
        this.push(result);
    }

    private void pushByInvoke(DismantleBytecode dbc, boolean popThis) {
        String signature = dbc.getSigConstantOperand();
        if ("<init>".equals(dbc.getNameConstantOperand()) && signature.endsWith(")V") && popThis) {
            Item next;
            this.pop(PreorderVisitor.getNumberArguments(signature));
            Item constructed = this.pop();
            if (this.getStackDepth() > 0 && constructed.equals(next = this.getStackItem(0))) {
                next = new Item(next);
                next.source = XFactory.createReferencedXMethod(dbc);
                next.pc = dbc.getPC();
                this.replace(0, next);
            }
            return;
        }
        this.pop(PreorderVisitor.getNumberArguments(signature) + (popThis ? 1 : 0));
        this.pushBySignature(new SignatureParser(signature).getReturnTypeSignature(), dbc);
    }

    public Item getItemMethodInvokedOn(DismantleBytecode dbc) {
        int opcode = dbc.getOpcode();
        switch (opcode) {
            case 182: 
            case 183: 
            case 185: {
                String signature = dbc.getSigConstantOperand();
                int stackOffset = PreorderVisitor.getNumberArguments(signature);
                return this.getStackItem(stackOffset);
            }
        }
        throw new IllegalArgumentException("Not visiting an instance method call");
    }

    private String getStringFromIndex(DismantleBytecode dbc, int i) {
        ConstantUtf8 name = (ConstantUtf8)dbc.getConstantPool().getConstant(i);
        return name.getBytes();
    }

    private void pushBySignature(String s, DismantleBytecode dbc) {
        if ("V".equals(s)) {
            return;
        }
        Item item = new Item(s, (Object)null);
        if (dbc != null) {
            item.setPC(dbc.getPC());
        }
        if ("B".equals(s)) {
            item.setSpecialKind(1);
        } else if ("C".equals(s)) {
            item.setSpecialKind(14);
        }
        this.push(item);
    }

    private void pushByLocalStore(int register) {
        Item it = new Item(this.pop());
        if (it.getRegisterNumber() != register) {
            OpcodeStack.clearRegisterLoad(this.lvValues, register);
            OpcodeStack.clearRegisterLoad(this.stack, register);
        }
        if (it.registerNumber == -1) {
            it.registerNumber = register;
        }
        this.setLVValue(register, it);
    }

    private static void clearRegisterLoad(List<Item> list, int register) {
        for (int pos = 0; pos < list.size(); ++pos) {
            Item i = list.get(pos);
            if (i == null || i.registerNumber != register && i.fieldLoadedFromRegister != register) continue;
            if ((i = new Item(i)).registerNumber == register) {
                i.registerNumber = -1;
            }
            if (i.fieldLoadedFromRegister == register) {
                i.fieldLoadedFromRegister = -1;
            }
            list.set(pos, i);
        }
    }

    private void pushByLocalLoad(String signature, int register) {
        Item oldItem = new Item(this.getLVValue(register));
        Item newItem = oldItem;
        if ("Ljava/lang/Object;".equals(newItem.signature) && !"Ljava/lang/Object;".equals(signature)) {
            newItem = new Item(oldItem);
            newItem.signature = signature;
        }
        if (newItem.getRegisterNumber() < 0) {
            if (newItem == oldItem) {
                newItem = new Item(oldItem);
            }
            newItem.registerNumber = register;
        }
        this.push(newItem);
    }

    private void setLVValue(int index, Item value) {
        int addCount = index - this.lvValues.size() + 1;
        while (addCount-- > 0) {
            this.lvValues.add(null);
        }
        if (!this.useIterativeAnalysis && this.seenTransferOfControl) {
            value = Item.merge(value, this.lvValues.get(index));
        }
        this.lvValues.set(index, value);
    }

    @Nonnull
    public Item getLVValue(int index) {
        if (index >= this.lvValues.size()) {
            return new Item();
        }
        Item item = this.lvValues.get(index);
        if (item != null) {
            return item;
        }
        return new Item();
    }

    public int getNumLocalValues() {
        return this.lvValues.size();
    }

    private void setTop(boolean top) {
        if (top) {
            if (!this.top) {
                this.top = true;
            }
        } else if (this.top) {
            this.top = false;
        }
    }

    public boolean isTop() {
        return this.top;
    }

    void setReachOnlyByBranch(boolean reachOnlyByBranch) {
        if (reachOnlyByBranch) {
            this.setTop(true);
        }
        this.reachOnlyByBranch = reachOnlyByBranch;
    }

    boolean isReachOnlyByBranch() {
        return this.reachOnlyByBranch;
    }

    boolean isJumpInfoChangedByBackwardsBranch() {
        return this.jumpInfoChangedByBackwardsBranch;
    }

    void clearJumpInfoChangedByBackwardsBranch() {
        this.jumpInfoChangedByBackwardsBranch = false;
    }

    void setJumpInfoChangedByBackwardsBranch(int from, int to) {
        this.jumpInfoChangedByBackwardsBranch = true;
    }

    protected boolean isJumpInfoChangedByNewTarget() {
        return this.jumpInfoChangedByNewTarget;
    }

    void clearJumpInfoChangedByNewTarget() {
        this.jumpInfoChangedByNewTarget = false;
    }

    protected void setJumpInfoChangedByNewTarget() {
        this.jumpInfoChangedByNewTarget = true;
    }

    static {
        DEBUG2 = DEBUG = SystemProperties.getBoolean("ocstack.debug");
        boxedTypes = new HashMap();
        OpcodeStack.addBoxedType(Integer.class, Long.class, Double.class, Short.class, Float.class, Boolean.class, Character.class, Byte.class);
    }

    public static class JumpInfoFactory
    extends AnalysisFactory<JumpInfo> {
        public JumpInfoFactory() {
            super("Jump info for opcode stack", JumpInfo.class);
        }

        @Override
        @CheckForNull
        public JumpInfo analyze(IAnalysisCache analysisCache, MethodDescriptor descriptor) throws CheckedAnalysisException {
            Method method = analysisCache.getMethodAnalysis(Method.class, descriptor);
            JavaClass jclass = this.getJavaClass(analysisCache, descriptor.getClassDescriptor());
            Code code = method.getCode();
            if (code == null) {
                return null;
            }
            JumpStackComputation branchAnalysis = new JumpStackComputation(descriptor);
            return JumpInfoFactory.computeJumpInfo(jclass, method, branchAnalysis);
        }

        @CheckForNull
        public static JumpInfo computeJumpInfo(JavaClass jclass, Method method, JumpStackComputation branchAnalysis) {
            branchAnalysis.setupVisitorForClass(jclass);
            XMethod createXMethod = XFactory.createXMethod(jclass, method);
            if (!(createXMethod instanceof MethodInfo)) {
                return null;
            }
            MethodInfo xMethod = (MethodInfo)createXMethod;
            int iteration = 1;
            OpcodeStack myStack = branchAnalysis.stack;
            do {
                if (DEBUG && iteration > 1) {
                    System.out.println("Iterative jump info for " + xMethod + ", iteration " + iteration);
                    myStack.printJumpEntries();
                    System.out.println();
                }
                branchAnalysis.doVisitMethod(method);
                if (xMethod.hasBackBranch() != myStack.backwardsBranch && !myStack.encountedTop) {
                    AnalysisContext.logError(String.format("For %s, mismatch on existence of backedge: %s for precomputation, %s for bytecode analysis", xMethod, xMethod.hasBackBranch(), myStack.backwardsBranch));
                }
                if (myStack.isJumpInfoChangedByNewTarget()) {
                    if (DEBUG) {
                        System.out.println("new target found, resetting iteration count");
                    }
                    iteration = 1;
                }
                if (iteration++ <= 40) continue;
                AnalysisContext.logError("Iterative jump info didn't converge after " + iteration + " iterations in " + xMethod + ", size " + method.getCode().getLength());
                break;
            } while (myStack.isJumpInfoChangedByBackwardsBranch() && myStack.backwardsBranch);
            if (iteration > 20 && iteration <= 40) {
                AnalysisContext.logError("Iterative jump info converged after " + iteration + " iterations in " + xMethod + ", size " + method.getCode().getLength());
            }
            return new JumpInfo(myStack.jumpEntries, myStack.jumpStackEntries, myStack.jumpEntryLocations);
        }

        static class JumpStackComputation
        extends BytecodeScanningDetector {
            static final boolean DEBUG1 = false;
            final MethodDescriptor descriptor;
            protected OpcodeStack stack = new OpcodeStack();

            private JumpStackComputation(MethodDescriptor descriptor) {
                this.descriptor = descriptor;
            }

            public OpcodeStack getStack() {
                return this.stack;
            }

            @Override
            public final void visitCode(Code obj) {
                if (!this.getMethodDescriptor().equals(this.descriptor)) {
                    throw new IllegalStateException();
                }
                this.stack.resetForMethodEntry0(this);
                super.visitCode(obj);
            }

            @Override
            public void sawOpcode(int seen) {
                this.stack.precomputation(this);
                this.stack.sawOpcode(this, seen);
            }
        }
    }

    public static class JumpInfo {
        final Map<Integer, List<Item>> jumpEntries;
        final Map<Integer, List<Item>> jumpStackEntries;
        final BitSet jumpEntryLocations;

        JumpInfo(Map<Integer, List<Item>> jumpEntries, Map<Integer, List<Item>> jumpStackEntries, BitSet jumpEntryLocations) {
            this.jumpEntries = jumpEntries;
            this.jumpStackEntries = jumpStackEntries;
            this.jumpEntryLocations = jumpEntryLocations;
        }

        public int getNextJump(int pc) {
            return this.jumpEntryLocations.nextSetBit(pc);
        }
    }

    public static class Item {
        @SpecialKind
        public static final int NOT_SPECIAL = 0;
        @SpecialKind
        public static final int SIGNED_BYTE = 1;
        @SpecialKind
        public static final int RANDOM_INT = 2;
        @SpecialKind
        public static final int LOW_8_BITS_CLEAR = 3;
        @SpecialKind
        public static final int HASHCODE_INT = 4;
        @SpecialKind
        public static final int INTEGER_SUM = 5;
        @SpecialKind
        public static final int AVERAGE_COMPUTED_USING_DIVISION = 6;
        @SpecialKind
        public static final int FLOAT_MATH = 7;
        @SpecialKind
        public static final int RANDOM_INT_REMAINDER = 8;
        @SpecialKind
        public static final int HASHCODE_INT_REMAINDER = 9;
        @SpecialKind
        public static final int FILE_SEPARATOR_STRING = 10;
        @SpecialKind
        public static final int MATH_ABS = 11;
        @SpecialKind
        public static final int MATH_ABS_OF_RANDOM = 12;
        @SpecialKind
        public static final int MATH_ABS_OF_HASHCODE = 13;
        @SpecialKind
        public static final int NON_NEGATIVE = 14;
        @SpecialKind
        public static final int NASTY_FLOAT_MATH = 15;
        @SpecialKind
        public static final int FILE_OPENED_IN_APPEND_MODE = 16;
        @SpecialKind
        public static final int SERVLET_REQUEST_TAINTED = 17;
        @SpecialKind
        public static final int NEWLY_ALLOCATED = 18;
        @SpecialKind
        public static final int ZERO_MEANS_NULL = 19;
        @SpecialKind
        public static final int NONZERO_MEANS_NULL = 20;
        @SpecialKind
        public static final int RESULT_OF_I2L = 21;
        @SpecialKind
        public static final int RESULT_OF_L2I = 22;
        @SpecialKind
        public static final int SERVLET_OUTPUT = 23;
        @SpecialKind
        public static final int TYPE_ONLY = 24;
        @StaticConstant
        public static final HashMap<Integer, String> specialKindNames = new HashMap();
        @SpecialKind
        private static int nextSpecialKind = Item.asSpecialKind(25);
        private static final int IS_INITIAL_PARAMETER_FLAG = 1;
        private static final int COULD_BE_ZERO_FLAG = 2;
        private static final int IS_NULL_FLAG = 4;
        public static final Object UNKNOWN = null;
        @SpecialKind
        private int specialKind = 0;
        private String signature;
        private Object constValue = UNKNOWN;
        @CheckForNull
        private ClassMember source;
        private int pc = -1;
        private int flags;
        private int registerNumber = -1;
        @Nullable
        private Object userValue;
        private HttpParameterInjection injection;
        private int fieldLoadedFromRegister = -1;

        @SpecialKind
        static int asSpecialKind(int kind) {
            return kind;
        }

        @SpecialKind
        public static int defineNewSpecialKind(String name) {
            int result;
            specialKindNames.put(nextSpecialKind, name);
            nextSpecialKind = result = Item.asSpecialKind(nextSpecialKind + 1);
            return result;
        }

        public void makeCrossMethod() {
            this.pc = -1;
            this.registerNumber = -1;
            this.fieldLoadedFromRegister = -1;
        }

        public int getSize() {
            if ("J".equals(this.signature) || "D".equals(this.signature)) {
                return 2;
            }
            return 1;
        }

        public int getPC() {
            return this.pc;
        }

        public void setPC(int pc) {
            this.pc = pc;
        }

        public boolean isWide() {
            return this.getSize() == 2;
        }

        public int hashCode() {
            int r = 42 + this.specialKind;
            if (this.signature != null) {
                r += this.signature.hashCode();
            }
            r *= 31;
            if (this.constValue != null) {
                r += this.constValue.hashCode();
            }
            r *= 31;
            if (this.source != null) {
                r += this.source.hashCode();
            }
            r *= 31;
            r += this.flags;
            r *= 31;
            return r += this.registerNumber;
        }

        public boolean usesTwoSlots() {
            return this.getSize() == 2;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Item)) {
                return false;
            }
            Item that = (Item)o;
            return Util.nullSafeEquals(this.signature, that.signature) && Util.nullSafeEquals(this.constValue, that.constValue) && Util.nullSafeEquals(this.source, that.source) && Util.nullSafeEquals(this.userValue, that.userValue) && Util.nullSafeEquals(this.injection, that.injection) && this.specialKind == that.specialKind && this.registerNumber == that.registerNumber && this.flags == that.flags && this.fieldLoadedFromRegister == that.fieldLoadedFromRegister;
        }

        public boolean sameValue(Item that) {
            return this.equals(that) && (this.registerNumber != -1 && this.registerNumber == that.registerNumber || this.fieldLoadedFromRegister != -1);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("< ");
            buf.append(this.signature);
            switch (this.specialKind) {
                case 1: {
                    buf.append(", signed_byte");
                    break;
                }
                case 2: {
                    buf.append(", random_int");
                    break;
                }
                case 3: {
                    buf.append(", low8clear");
                    break;
                }
                case 4: {
                    buf.append(", hashcode_int");
                    break;
                }
                case 5: {
                    buf.append(", int_sum");
                    break;
                }
                case 6: {
                    buf.append(", averageComputingUsingDivision");
                    break;
                }
                case 7: {
                    buf.append(", floatMath");
                    break;
                }
                case 15: {
                    buf.append(", nastyFloatMath");
                    break;
                }
                case 9: {
                    buf.append(", hashcode_int_rem");
                    break;
                }
                case 8: {
                    buf.append(", random_int_rem");
                    break;
                }
                case 12: {
                    buf.append(", abs_of_random");
                    break;
                }
                case 13: {
                    buf.append(", abs_of_hashcode");
                    break;
                }
                case 10: {
                    buf.append(", file_separator_string");
                    break;
                }
                case 11: {
                    buf.append(", Math.abs");
                    break;
                }
                case 14: {
                    buf.append(", non_negative");
                    break;
                }
                case 16: {
                    buf.append(", file opened in append mode");
                    break;
                }
                case 17: {
                    buf.append(", servlet request tainted");
                    break;
                }
                case 18: {
                    buf.append(", new");
                    break;
                }
                case 19: {
                    buf.append(", zero means null");
                    break;
                }
                case 20: {
                    buf.append(", nonzero means null");
                    break;
                }
                case 23: {
                    buf.append(", servlet_output");
                    break;
                }
                case 24: {
                    buf.append(", type_only");
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    buf.append(", #" + this.specialKind);
                    buf.append("(" + specialKindNames.get(this.specialKind) + ")");
                }
            }
            if (this.constValue != UNKNOWN) {
                if (this.constValue instanceof String) {
                    buf.append(", \"");
                    buf.append(this.constValue);
                    buf.append("\"");
                } else {
                    buf.append(", ");
                    buf.append(this.constValue);
                }
            }
            if (this.source instanceof XField) {
                buf.append(", ");
                if (this.fieldLoadedFromRegister != -1 && this.fieldLoadedFromRegister != Integer.MAX_VALUE) {
                    buf.append(this.fieldLoadedFromRegister).append(':');
                }
                buf.append(this.source);
            }
            if (this.source instanceof XMethod) {
                buf.append(", return value from ");
                buf.append(this.source);
            }
            if (this.isInitialParameter()) {
                buf.append(", IP");
            }
            if (this.isNull()) {
                buf.append(", isNull");
            }
            if (this.registerNumber != -1) {
                buf.append(", r");
                buf.append(this.registerNumber);
            }
            if (this.isCouldBeZero() && !this.isZero()) {
                buf.append(", cbz");
            }
            if (this.userValue != null) {
                buf.append(", uv: ");
                buf.append(this.userValue.toString());
            }
            buf.append(" >");
            return buf.toString();
        }

        public static Item merge(Item i1, Item i2) {
            if (i1 == null) {
                return i2;
            }
            if (i2 == null) {
                return i1;
            }
            if (i1.equals(i2)) {
                return i1;
            }
            Item m = new Item();
            if (i1.getSpecialKind() == 24 && i2.getSpecialKind() != 24) {
                return i2;
            }
            if (i2.getSpecialKind() == 24 && i1.getSpecialKind() != 24) {
                return i1;
            }
            m.flags = i1.flags & i2.flags;
            m.setCouldBeZero(i1.isCouldBeZero() || i2.isCouldBeZero());
            if (i1.pc == i2.pc) {
                m.pc = i1.pc;
            }
            if (Util.nullSafeEquals(i1.signature, i2.signature)) {
                m.signature = i1.signature;
            } else if (i1.isNull()) {
                m.signature = i2.signature;
            } else if (i2.isNull()) {
                m.signature = i1.signature;
            }
            if (Util.nullSafeEquals(i1.constValue, i2.constValue)) {
                m.constValue = i1.constValue;
            }
            if (Util.nullSafeEquals(i1.source, i2.source)) {
                m.source = i1.source;
            } else if ("".equals(i1.constValue)) {
                m.source = i2.source;
            } else if ("".equals(i2.constValue)) {
                m.source = i1.source;
            }
            if (Util.nullSafeEquals(i1.userValue, i2.userValue)) {
                m.userValue = i1.userValue;
            }
            if (i1.registerNumber == i2.registerNumber) {
                m.registerNumber = i1.registerNumber;
            }
            if (i1.fieldLoadedFromRegister == i2.fieldLoadedFromRegister) {
                m.fieldLoadedFromRegister = i1.fieldLoadedFromRegister;
            }
            if (i1.specialKind == 17) {
                m.specialKind = 17;
                m.injection = i1.injection;
            } else if (i2.specialKind == 17) {
                m.specialKind = 17;
                m.injection = i2.injection;
            } else if (i1.specialKind == i2.specialKind) {
                m.specialKind = i1.specialKind;
            } else if (i1.specialKind == 15 || i2.specialKind == 15) {
                m.specialKind = 15;
            } else if (i1.specialKind == 7 || i2.specialKind == 7) {
                m.specialKind = 7;
            }
            if (DEBUG) {
                System.out.println("Merge " + i1 + " and " + i2 + " gives " + m);
            }
            return m;
        }

        public Item(String signature, int constValue) {
            this(signature, (Object)constValue);
        }

        public static Item initialArgument(String signature, int reg) {
            Item it = new Item(signature);
            it.setInitialParameter(true);
            it.registerNumber = reg;
            return it;
        }

        public Item(String signature) {
            this(signature, UNKNOWN);
        }

        public static Item typeOnly(String signature) {
            Item it = new Item(signature, UNKNOWN);
            it.setSpecialKind(24);
            return it;
        }

        public Item(Item it) {
            this.signature = it.signature;
            this.constValue = it.constValue;
            this.source = it.source;
            this.fieldLoadedFromRegister = it.fieldLoadedFromRegister;
            this.registerNumber = it.registerNumber;
            this.userValue = it.userValue;
            this.injection = it.injection;
            this.flags = it.flags;
            this.specialKind = it.specialKind;
            this.pc = it.pc;
        }

        public Item(Item it, String signature) {
            this(it);
            char s;
            this.signature = DescriptorFactory.canonicalizeString(signature);
            if (this.constValue instanceof Number) {
                Number constantNumericValue = (Number)this.constValue;
                if ("B".equals(signature)) {
                    this.constValue = constantNumericValue.byteValue();
                } else if ("S".equals(signature)) {
                    this.constValue = constantNumericValue.shortValue();
                } else if ("C".equals(signature)) {
                    this.constValue = Character.valueOf((char)constantNumericValue.intValue());
                } else if ("I".equals(signature)) {
                    this.constValue = constantNumericValue.intValue();
                } else if ("D".equals(signature)) {
                    this.constValue = constantNumericValue.doubleValue();
                } else if ("F".equals(signature)) {
                    this.constValue = Float.valueOf(constantNumericValue.floatValue());
                }
            }
            if ((s = signature.charAt(0)) != 'L' && s != '[') {
                this.source = null;
            }
            this.setSpecialKindFromSignature();
        }

        public Item(Item it, int reg) {
            this(it);
            this.registerNumber = reg;
        }

        public Item(String signature, FieldAnnotation f) {
            this.signature = DescriptorFactory.canonicalizeString(signature);
            this.setSpecialKindFromSignature();
            if (f != null) {
                this.source = XFactory.createXField(f);
            }
            this.fieldLoadedFromRegister = -1;
        }

        public Item(String signature, FieldAnnotation f, int fieldLoadedFromRegister) {
            this.signature = DescriptorFactory.canonicalizeString(signature);
            if (f != null) {
                this.source = XFactory.createXField(f);
            }
            this.fieldLoadedFromRegister = fieldLoadedFromRegister;
        }

        public int getFieldLoadedFromRegister() {
            return this.fieldLoadedFromRegister;
        }

        public void setLoadedFromField(XField f, int fieldLoadedFromRegister) {
            this.source = f;
            this.fieldLoadedFromRegister = fieldLoadedFromRegister;
            this.registerNumber = -1;
        }

        @CheckForNull
        public String getHttpParameterName() {
            if (!this.isServletParameterTainted()) {
                throw new IllegalStateException();
            }
            if (this.injection == null) {
                return null;
            }
            return this.injection.parameterName;
        }

        public int getInjectionPC() {
            if (!this.isServletParameterTainted()) {
                throw new IllegalStateException();
            }
            if (this.injection == null) {
                return -1;
            }
            return this.injection.pc;
        }

        public Item(String signature, Object constantValue) {
            this.signature = DescriptorFactory.canonicalizeString(signature);
            this.setSpecialKindFromSignature();
            this.constValue = constantValue;
            if (constantValue instanceof Integer) {
                int value = (Integer)constantValue;
                if (value != 0 && (value & 0xFF) == 0) {
                    this.specialKind = 3;
                }
                if (value == 0) {
                    this.setCouldBeZero(true);
                }
            } else if (constantValue instanceof Long) {
                long value = (Long)constantValue;
                if (value != 0L && (value & 0xFFL) == 0L) {
                    this.specialKind = 3;
                }
                if (value == 0L) {
                    this.setCouldBeZero(true);
                }
            }
        }

        private void setSpecialKindFromSignature() {
            if ("B".equals(this.signature)) {
                this.specialKind = 1;
            } else if ("C".equals(this.signature)) {
                this.specialKind = 14;
            }
        }

        public void setCouldBeNegative() {
            if (this.specialKind == 14) {
                this.specialKind = 0;
            }
        }

        public Item() {
            this.signature = "Ljava/lang/Object;";
            this.constValue = null;
            this.setNull(true);
        }

        public static Item nullItem(String signature) {
            Item item = new Item(signature);
            item.constValue = null;
            item.setNull(true);
            return item;
        }

        @CheckForNull
        public JavaClass getJavaClass() throws ClassNotFoundException {
            if (this.isPrimitive() || this.isArray()) {
                return null;
            }
            String baseSig = this.signature;
            if (baseSig.length() == 0) {
                return null;
            }
            baseSig = baseSig.substring(1, baseSig.length() - 1);
            baseSig = baseSig.replace('/', '.');
            return Repository.lookupClass((String)baseSig);
        }

        public boolean isArray() {
            return this.signature.startsWith("[");
        }

        @Deprecated
        public String getElementSignature() {
            int pos;
            if (!this.isArray()) {
                return this.signature;
            }
            int len = this.signature.length();
            for (pos = 0; pos < len && this.signature.charAt(pos) == '['; ++pos) {
            }
            return this.signature.substring(pos);
        }

        public boolean isNonNegative() {
            if (this.specialKind == 14) {
                return true;
            }
            if (this.constValue instanceof Number) {
                double value = ((Number)this.constValue).doubleValue();
                return value >= 0.0;
            }
            return false;
        }

        public boolean isPrimitive() {
            return !this.signature.startsWith("L") && !this.signature.startsWith("[");
        }

        public int getRegisterNumber() {
            return this.registerNumber;
        }

        public String getSignature() {
            return this.signature;
        }

        public Object getConstant() {
            return this.constValue;
        }

        @Deprecated
        public FieldAnnotation getFieldAnnotation() {
            return FieldAnnotation.fromXField(this.getXField());
        }

        public XField getXField() {
            if (this.source instanceof XField) {
                return (XField)this.source;
            }
            return null;
        }

        public void setSpecialKind(@SpecialKind int specialKind) {
            this.specialKind = specialKind;
        }

        public Item cloneAndSetSpecialKind(@SpecialKind int specialKind) {
            Item that = new Item(this);
            that.specialKind = specialKind;
            return that;
        }

        @SpecialKind
        public int getSpecialKind() {
            return this.specialKind;
        }

        public boolean isBooleanNullnessValue() {
            return this.specialKind == 19 || this.specialKind == 20;
        }

        public void setUserValue(@Nullable Object value) {
            this.userValue = value;
        }

        @CheckForNull
        public XMethod getReturnValueOf() {
            if (this.source instanceof XMethod) {
                return (XMethod)this.source;
            }
            return null;
        }

        public boolean couldBeZero() {
            return this.isCouldBeZero();
        }

        public boolean mustBeZero() {
            Object value = this.getConstant();
            return value instanceof Number && ((Number)value).intValue() == 0;
        }

        @Nullable
        public Object getUserValue() {
            return this.userValue;
        }

        public boolean isServletParameterTainted() {
            return this.getSpecialKind() == 17;
        }

        public void setServletParameterTainted() {
            this.setSpecialKind(17);
        }

        public void setIsServletWriter() {
            this.setSpecialKind(23);
        }

        public boolean isServletWriter() {
            if (this.getSpecialKind() == 23) {
                return true;
            }
            if ("Ljavax/servlet/ServletOutputStream;".equals(this.getSignature())) {
                return true;
            }
            XMethod writingToSource = this.getReturnValueOf();
            return writingToSource != null && "javax.servlet.http.HttpServletResponse".equals(writingToSource.getClassName()) && ("getWriter".equals(writingToSource.getName()) || "getOutputStream".equals(writingToSource.getName()));
        }

        public boolean valueCouldBeNegative() {
            return !this.isNonNegative() && (this.getSpecialKind() == 2 || this.getSpecialKind() == 1 || this.getSpecialKind() == 4 || this.getSpecialKind() == 8 || this.getSpecialKind() == 9 || this.getSpecialKind() == 12 || this.getSpecialKind() == 13);
        }

        @SpecialKind
        public int getSpecialKindForAbs() {
            switch (this.getSpecialKind()) {
                case 4: {
                    return 13;
                }
                case 2: {
                    return 12;
                }
            }
            return 11;
        }

        @SpecialKind
        public int getSpecialKindForRemainder() {
            switch (this.getSpecialKind()) {
                case 4: {
                    return 9;
                }
                case 2: {
                    return 8;
                }
            }
            return 0;
        }

        public boolean checkForIntegerMinValue() {
            return !this.isNonNegative() && (this.getSpecialKind() == 2 || this.getSpecialKind() == 4);
        }

        public boolean mightRarelyBeNegative() {
            return !this.isNonNegative() && (this.getSpecialKind() == 12 || this.getSpecialKind() == 13);
        }

        private void setInitialParameter(boolean isInitialParameter) {
            this.setFlag(isInitialParameter, 1);
        }

        public boolean isInitialParameter() {
            return (this.flags & 1) != 0;
        }

        private void setCouldBeZero(boolean couldBeZero) {
            this.setFlag(couldBeZero, 2);
        }

        private boolean isCouldBeZero() {
            return (this.flags & 2) != 0 || this.isZero();
        }

        private boolean isZero() {
            return this.constValue != null && this.constValue.equals(0);
        }

        private void setNull(boolean isNull) {
            this.setFlag(isNull, 4);
        }

        private void setFlag(boolean value, int flagBit) {
            this.flags = value ? (this.flags |= flagBit) : (this.flags &= ~flagBit);
        }

        public boolean isNull() {
            return (this.flags & 4) != 0;
        }

        public void clearNewlyAllocated() {
            if (this.specialKind == 18) {
                if (this.signature.startsWith("Ljava/lang/StringB")) {
                    this.constValue = null;
                }
                this.specialKind = 0;
            }
        }

        public boolean isNewlyAllocated() {
            return this.specialKind == 18;
        }

        public boolean hasConstantValue(int value) {
            if (this.constValue instanceof Number) {
                return ((Number)this.constValue).intValue() == value;
            }
            return false;
        }

        public boolean hasConstantValue(long value) {
            if (this.constValue instanceof Number) {
                return ((Number)this.constValue).longValue() == value;
            }
            return false;
        }

        @Documented
        @TypeQualifier(applicableTo=Integer.class)
        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface SpecialKind {
        }
    }

    static class HttpParameterInjection {
        String parameterName;
        int pc;

        HttpParameterInjection(String parameterName, int pc) {
            this.parameterName = parameterName;
            this.pc = pc;
        }
    }

    @Documented
    @Target(value={ElementType.TYPE, ElementType.PACKAGE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CustomUserValue {
    }
}

