/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.obl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.obl.Obligation;
import edu.umd.cs.findbugs.ba.obl.ObligationSet;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class ObligationFactory {
    private final Map<String, Obligation> classNameToObligationMap;
    private final Set<String> slashedClassNames = new HashSet<String>();

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public ObligationFactory() {
        this.classNameToObligationMap = new HashMap<String, Obligation>();
    }

    public int getMaxObligationTypes() {
        return this.classNameToObligationMap.size();
    }

    public boolean signatureInvolvesObligations(String sig) {
        sig = sig.replaceAll("java/io/File", "java/io/");
        for (String c : this.slashedClassNames) {
            if (sig.indexOf(c) < 0) continue;
            return true;
        }
        return false;
    }

    public boolean isObligationType(ClassDescriptor classDescriptor) {
        try {
            return this.getObligationByType(BCELUtil.getObjectTypeInstance(classDescriptor.toDottedClassName())) != null;
        }
        catch (ClassNotFoundException e) {
            Global.getAnalysisCache().getErrorLogger().reportMissingClass(e);
            return false;
        }
    }

    public Iterator<Obligation> obligationIterator() {
        return this.classNameToObligationMap.values().iterator();
    }

    @CheckForNull
    public Obligation getObligationByType(ObjectType type) throws ClassNotFoundException {
        Iterator<Obligation> i = this.obligationIterator();
        while (i.hasNext()) {
            Obligation obligation = i.next();
            if (!Hierarchy.isSubtype((ReferenceType)type, (ReferenceType)obligation.getType())) continue;
            return obligation;
        }
        return null;
    }

    @CheckForNull
    public Obligation getObligationByType(ClassDescriptor classDescriptor) {
        try {
            return this.getObligationByType(BCELUtil.getObjectTypeInstance(classDescriptor.toDottedClassName()));
        }
        catch (ClassNotFoundException e) {
            Global.getAnalysisCache().getErrorLogger().reportMissingClass(e);
            return null;
        }
    }

    public Obligation[] getParameterObligationTypes(XMethod xmethod) {
        Type[] paramTypes = Type.getArgumentTypes((String)xmethod.getSignature());
        Obligation[] result = new Obligation[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            if (!(paramTypes[i] instanceof ObjectType)) continue;
            try {
                result[i] = this.getObligationByType((ObjectType)paramTypes[i]);
                continue;
            }
            catch (ClassNotFoundException e) {
                Global.getAnalysisCache().getErrorLogger().reportMissingClass(e);
            }
        }
        return result;
    }

    public Obligation addObligation(@DottedClassName String className) {
        int nextId = this.classNameToObligationMap.size();
        this.slashedClassNames.add(className.replace('.', '/'));
        Obligation obligation = new Obligation(className, nextId);
        if (this.classNameToObligationMap.put(className, obligation) != null) {
            throw new IllegalStateException("Obligation " + className + " added multiple times");
        }
        return obligation;
    }

    public Obligation getObligationById(int id) {
        for (Obligation obligation : this.classNameToObligationMap.values()) {
            if (obligation.getId() != id) continue;
            return obligation;
        }
        return null;
    }

    public Obligation getObligationByName(@DottedClassName String className) {
        return this.classNameToObligationMap.get(className);
    }

    public ObligationSet createObligationSet() {
        return new ObligationSet(this);
    }
}

