/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.vna;

import edu.umd.cs.findbugs.ba.XField;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

public class LoadedFieldSet {
    private final Map<XField, LoadStoreCount> loadStoreCountMap = new HashMap<XField, LoadStoreCount>();
    private final Map<InstructionHandle, XField> handleToFieldMap = new HashMap<InstructionHandle, XField>();
    private final BitSet loadHandleSet = new BitSet();

    public LoadedFieldSet(MethodGen methodGen) {
    }

    public LoadStoreCount getLoadStoreCount(XField field) {
        LoadStoreCount loadStoreCount = this.loadStoreCountMap.get(field);
        if (loadStoreCount == null) {
            loadStoreCount = new LoadStoreCount();
            this.loadStoreCountMap.put(field, loadStoreCount);
        }
        return loadStoreCount;
    }

    public void addLoad(InstructionHandle handle, XField field) {
        ++this.getLoadStoreCount((XField)field).loadCount;
        this.handleToFieldMap.put(handle, field);
        this.loadHandleSet.set(handle.getPosition());
    }

    public void addStore(InstructionHandle handle, XField field) {
        ++this.getLoadStoreCount((XField)field).storeCount;
        this.handleToFieldMap.put(handle, field);
    }

    public XField getField(InstructionHandle handle) {
        return this.handleToFieldMap.get(handle);
    }

    public boolean isLoaded(XField field) {
        return this.getLoadStoreCount((XField)field).loadCount > 0;
    }

    public boolean instructionIsLoad(InstructionHandle handle) {
        return this.loadHandleSet.get(handle.getPosition());
    }

    public static class LoadStoreCount {
        int loadCount;
        int storeCount;

        public int getLoadCount() {
            return this.loadCount;
        }

        public int getStoreCount() {
            return this.storeCount;
        }
    }
}

