/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.bcel;

import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.OpcodeStack;
import org.apache.bcel.classfile.Code;

public abstract class OpcodeStackDetector
extends BytecodeScanningDetector {
    private final boolean isUsingCustomUserValue = this.getClass().isAnnotationPresent(OpcodeStack.CustomUserValue.class);
    protected OpcodeStack stack;

    public OpcodeStack getStack() {
        return this.stack;
    }

    @Override
    public final void visitCode(Code obj) {
        if (!this.shouldVisitCode(obj)) {
            return;
        }
        this.stack = new OpcodeStack();
        this.stack.resetForMethodEntry(this);
        super.visitCode(obj);
        this.stack = null;
    }

    @Override
    public boolean beforeOpcode(int seen) {
        this.stack.precomputation(this);
        return !this.stack.isTop();
    }

    @Override
    public void afterOpcode(int seen) {
        this.stack.sawOpcode(this, seen);
    }

    @Override
    public abstract void sawOpcode(int var1);

    public final boolean isUsingCustomUserValue() {
        return this.isUsingCustomUserValue;
    }

    public static abstract class WithCustomJumpInfo
    extends OpcodeStackDetector {
        public abstract OpcodeStack.JumpInfo customJumpInfo();
    }
}

