/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.classfile.IClassPath;
import edu.umd.cs.findbugs.classfile.ICodeBase;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.IScannableCodeBase;
import edu.umd.cs.findbugs.classfile.ResourceNotFoundException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ClassPathImpl
implements IClassPath {
    private final List<IScannableCodeBase> appCodeBaseList = new LinkedList<IScannableCodeBase>();
    private final List<ICodeBase> auxCodeBaseList = new LinkedList<ICodeBase>();
    private final Map<String, ICodeBaseEntry> codeBaseEntryMap = new HashMap<String, ICodeBaseEntry>();

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (IScannableCodeBase iScannableCodeBase : this.appCodeBaseList) {
            buf.append(iScannableCodeBase);
            buf.append(" ");
        }
        for (ICodeBase iCodeBase : this.auxCodeBaseList) {
            buf.append("*");
            buf.append(iCodeBase);
            buf.append(" ");
        }
        return buf.toString();
    }

    @Override
    public void addCodeBase(ICodeBase codeBase) {
        if (codeBase.isApplicationCodeBase()) {
            if (!(codeBase instanceof IScannableCodeBase)) {
                throw new IllegalStateException();
            }
            this.appCodeBaseList.add((IScannableCodeBase)codeBase);
        } else {
            this.auxCodeBaseList.add(codeBase);
        }
    }

    @Override
    public Iterator<? extends ICodeBase> appCodeBaseIterator() {
        return this.appCodeBaseList.iterator();
    }

    @Override
    public Iterator<? extends ICodeBase> auxCodeBaseIterator() {
        return this.auxCodeBaseList.iterator();
    }

    @Override
    public void close() {
        for (ICodeBase iCodeBase : this.appCodeBaseList) {
            iCodeBase.close();
        }
        for (ICodeBase iCodeBase : this.auxCodeBaseList) {
            iCodeBase.close();
        }
        this.appCodeBaseList.clear();
        this.auxCodeBaseList.clear();
        this.codeBaseEntryMap.clear();
    }

    @Override
    public Map<String, ICodeBaseEntry> getApplicationCodebaseEntries() {
        HashMap<String, ICodeBaseEntry> appEntries = new HashMap<String, ICodeBaseEntry>();
        for (Map.Entry<String, ICodeBaseEntry> entry : this.codeBaseEntryMap.entrySet()) {
            ICodeBaseEntry codeBaseEntry = entry.getValue();
            if (!codeBaseEntry.getCodeBase().isApplicationCodeBase()) continue;
            appEntries.put(entry.getKey(), codeBaseEntry);
        }
        return appEntries;
    }

    @Override
    public ICodeBaseEntry lookupResource(String resourceName) throws ResourceNotFoundException {
        ICodeBaseEntry result = this.codeBaseEntryMap.get(resourceName);
        if (result == null) {
            result = this.search(this.appCodeBaseList, resourceName);
            if (result == null) {
                result = this.search(this.auxCodeBaseList, resourceName);
            }
            if (result == null) {
                throw new ResourceNotFoundException(resourceName);
            }
            this.codeBaseEntryMap.put(resourceName, result);
        }
        return result;
    }

    private ICodeBaseEntry search(List<? extends ICodeBase> codeBaseList, String resourceName) {
        for (ICodeBase iCodeBase : codeBaseList) {
            ICodeBaseEntry resource = iCodeBase.lookupResource(resourceName);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public void mapResourceNameToCodeBaseEntry(String resourceName, ICodeBaseEntry codeBaseEntry) {
        this.codeBaseEntryMap.put(resourceName, codeBaseEntry);
    }
}

