/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.FirstPassDetector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassSummary;
import edu.umd.cs.findbugs.ba.IncompatibleTypes;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.util.ClassName;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.generic.Type;

public class EqualsOperandShouldHaveClassCompatibleWithThis
extends OpcodeStackDetector
implements FirstPassDetector {
    final BugReporter bugReporter;
    final BugAccumulator bugAccumulator;
    final ClassSummary classSummary = new ClassSummary();

    public EqualsOperandShouldHaveClassCompatibleWithThis(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
        AnalysisContext context = AnalysisContext.currentAnalysisContext();
        context.setClassSummary(this.classSummary);
    }

    @Override
    public void visit(Code obj) {
        if ("equals".equals(this.getMethodName()) && "(Ljava/lang/Object;)Z".equals(this.getMethodSig())) {
            super.visit(obj);
            if (AnalysisContext.currentAnalysisContext().isApplicationClass(this.getThisClass())) {
                this.bugAccumulator.reportAccumulatedBugs();
            }
            this.bugAccumulator.clearBugs();
        }
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 182) {
            Object value;
            OpcodeStack.Item item;
            if ("equals".equals(this.getNameConstantOperand()) && "(Ljava/lang/Object;)Z".equals(this.getSigConstantOperand())) {
                OpcodeStack.Item item2 = this.stack.getStackItem(1);
                ClassDescriptor c = DescriptorFactory.createClassDescriptorFromSignature(item2.getSignature());
                this.check(c);
            } else if ("java/lang/Class".equals(this.getClassConstantOperand()) && ("isInstance".equals(this.getNameConstantOperand()) || "cast".equals(this.getNameConstantOperand())) && "Ljava/lang/Class;".equals((item = this.stack.getStackItem(1)).getSignature()) && (value = item.getConstant()) instanceof String) {
                ClassDescriptor c = DescriptorFactory.createClassDescriptor((String)value);
                this.check(c);
            }
        } else if (seen == 193 || seen == 192) {
            this.check(this.getClassDescriptorOperand());
        }
    }

    private void check(ClassDescriptor c) {
        OpcodeStack.Item item = this.stack.getStackItem(0);
        if (item.isInitialParameter() && item.getRegisterNumber() == 1) {
            ClassDescriptor thisClassDescriptor = this.getClassDescriptor();
            if (c.equals(thisClassDescriptor)) {
                return;
            }
            Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
            try {
                if (!c.isArray() && (subtypes2.isSubtype(c, thisClassDescriptor) || subtypes2.isSubtype(thisClassDescriptor, c))) {
                    return;
                }
                Type thisType = Type.getType((String)thisClassDescriptor.getSignature());
                Type cType = Type.getType((String)c.getSignature());
                IncompatibleTypes check = IncompatibleTypes.getPriorityForAssumingCompatible(thisType, cType, false);
                int priority = check.getPriority();
                if ("java/lang/Object".equals(this.getSuperclassName()) && ClassName.isAnonymous(this.getClassName())) {
                    ++priority;
                }
                this.bugAccumulator.accumulateBug(new BugInstance(this, "EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS", priority).addClassAndMethod(this).addType(c).describe("TYPE_FOUND"), this);
                this.classSummary.checksForEqualTo(thisClassDescriptor, c);
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
    }
}

