/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.Method;

public class FinalizerNullsFields
extends BytecodeScanningDetector {
    final BugReporter bugReporter;
    final BugAccumulator bugAccumulator;
    int state = 0;
    boolean sawAnythingElse;
    boolean inFinalize;
    boolean sawFieldNulling;

    public FinalizerNullsFields(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visit(Method obj) {
        this.inFinalize = "finalize".equals(obj.getName());
    }

    @Override
    public void visit(Field obj) {
    }

    @Override
    public void visit(Code obj) {
        this.state = 0;
        this.sawAnythingElse = false;
        this.sawFieldNulling = false;
        if (this.inFinalize) {
            super.visit(obj);
            this.bugAccumulator.reportAccumulatedBugs();
            if (!this.sawAnythingElse && this.sawFieldNulling) {
                BugInstance bug = new BugInstance(this, "FI_FINALIZER_ONLY_NULLS_FIELDS", 1).addClassAndMethod(this);
                this.bugReporter.reportBug(bug);
            }
        }
    }

    @Override
    public void sawOpcode(int seen) {
        if (this.state == 0 && seen == 42) {
            ++this.state;
        } else if (this.state == 1 && seen == 1) {
            ++this.state;
        } else if (this.state == 2 && seen == 181) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "FI_FINALIZER_NULLS_FIELDS", 2).addClassAndMethod(this).addReferencedField(this), this);
            this.sawFieldNulling = true;
            this.state = 0;
        } else if (seen == 177) {
            this.state = 0;
        } else {
            this.state = 0;
            this.sawAnythingElse = true;
        }
    }
}

