/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import java.util.List;

public class InstantiateStaticClass
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;

    public InstantiateStaticClass(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 183 && "<init>".equals(this.getNameConstantOperand()) && "()V".equals(this.getSigConstantOperand())) {
            XClass xClass = this.getXClassOperand();
            if (xClass == null) {
                return;
            }
            String clsName = this.getClassConstantOperand();
            if ("java/lang/Object".equals(clsName)) {
                return;
            }
            if ("<init>".equals(this.getMethodName()) && this.getPC() == 1) {
                return;
            }
            if ("<clinit>".equals(this.getMethodName()) && this.getClassName().equals(clsName)) {
                return;
            }
            if (this.isStaticOnlyClass(xClass)) {
                this.bugReporter.reportBug(new BugInstance(this, "ISC_INSTANTIATE_STATIC_CLASS", 3).addClassAndMethod(this).addSourceLine(this));
            }
        }
    }

    private boolean isStaticOnlyClass(XClass xClass) {
        if (xClass.getInterfaceDescriptorList().length > 0) {
            return false;
        }
        ClassDescriptor superclassDescriptor = xClass.getSuperclassDescriptor();
        if (superclassDescriptor == null) {
            return false;
        }
        String superClassName = superclassDescriptor.getClassName();
        if (!"java/lang/Object".equals(superClassName)) {
            return false;
        }
        int staticCount = 0;
        List<? extends XMethod> methods = xClass.getXMethods();
        for (XMethod xMethod : methods) {
            if (xMethod.isStatic() && !xMethod.isSynthetic()) {
                ++staticCount;
                continue;
            }
            if ("<init>".equals(xMethod.getName()) && "()V".equals(xMethod.getSignature())) continue;
            return false;
        }
        List<? extends XField> fields = xClass.getXFields();
        for (XField xField : fields) {
            if (xField.isStatic()) {
                ++staticCount;
                continue;
            }
            if (xField.isPrivate()) continue;
            return false;
        }
        return staticCount != 0;
    }
}

